﻿using System;
using BLL;
using Utils;
namespace UI.CrmCustomer
{
    public partial class CustomerMove : System.Web.UI.Page
    {
        string strCustomerID = "";
        CustomerBiz customerBiz = new CustomerBiz();
        protected void Page_Load(object sender, EventArgs e)
        {
            //获得客户的ID
            if (Request.QueryString["CustomerID"] != null)
            {
                strCustomerID = Request.QueryString["CustomerID"].ToString();
            }
            else
            {
                Response.Write(@"<script language='javascript'>alert('参数不能为空！Customer-Move-To-Other-User');</script>");
                return;
            }
            if (!IsPostBack)
            {
                JSUtility.AddConfirm(btnMoveOne, "真的要转移该客户吗？");
                JSUtility.AddConfirm(btnMoveAll, "真的要转移所有客户吗？");
            }
        }


        protected void btnMoveOne_Click(object sender, EventArgs e)
        {
            Move("One");

        }

        protected void btnMoveAll_Click(object sender, EventArgs e)
        {
            Move("All");
        }

        private void Move(string mType)
        {
            string account = txtAimAccount.Text.Trim();
            if (new AccountBiz().IsExist(account))
            {
                if (customerBiz.MoveCustomer(strCustomerID, account, mType))
                    JSUtility.Alert("转移成功！");
                else
                    JSUtility.Alert("转移失败！");                   
            }
            else
            {
                Response.Write(@"<script language='javascript'>alert('请通过后面按纽选择帐号或直接输入有效帐号！');</script>");
                return;
            }

            JSUtility.CloseTimeOut();
        }
    }
}