﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using BLL;
using Utils;
namespace UI.CrmCustomer
{
    public partial class CustomerSeaForIn : System.Web.UI.Page
    {
        CustomerBiz customerBiz = new CustomerBiz();
        string account = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] != null)
            {

                User user = Session["user"] as User;
                account = user.Account;
            }
            else
            {
                //弹出提示窗口
                Response.Write("<script>window.alert('您没有登陆！,建议登录之后再操作！') </script>");
                Response.End();
            }
            if (!Page.IsPostBack)
            {
                this.gvSearch.DataSource = customerBiz.GetList("", "0", "EMP$" + account, "", "", "");
                this.gvSearch.DataBind();
            }
        }


        protected void btnSearch_Click(object sender, EventArgs e)
        {
            this.gvSearch.DataSource = customerBiz.GetList(txtSearchWord.Text.Trim(), "0", "EMP$" + account, "", "", "");
            this.gvSearch.DataBind();
        }

        protected void btnAdd_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "CustomerAdd.aspx", RightChar.Add))
            {
                if (!AccountBiz.CheckRight(account, "CustomerList.aspx", RightChar.Add))
                {
                    JSUtility.Alert(this, "您没有增加的权限！");
                    return;
                }
            }


            SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
            //获取数据
            sdList.Add("SimpleName", txtCode.Text.Trim());
            sdList.Add("CustName", txtCustName.Text.Trim());
            sdList.Add("Addr", txtAddr.Text.Trim());
            string strTelHeader = txtTelHeader.Text.Trim();
            sdList.Add("Tel", strTelHeader + "-" + txtTel.Text.Trim());


            sdList.Add("LinkMan", txtLinkman.Text.Trim());
            sdList.Add("Mobile", txtMobile.Text.Trim());
            sdList.Add("CategoryID", "0");
            sdList.Add("Gade", "A");
            sdList.Add("Organize", "0");

            string strProvince = ddlProvince.SelectedValue.ToString();
            sdList.Add("Province", strProvince);
            sdList.Add("TypeID", "1");
            sdList.Add("FromToID", "1");//来源ＩＤ


            sdList.Add("StatuID", "1");
            //**需要检测以上数据的有效性
            //***判断该客户是否存在
            if (customerBiz.IsExist(txtCode.Text.Trim(), txtCustName.Text.Trim(), txtMobile.Text.Trim(), strTelHeader + "-" + txtTel.Text.Trim()))
            {
                JSUtility.Alert(this, "该客户名称，简称，联系手机或联系电话已经存在！");
                return;
            }
            //合成客户编号
            sdList.Add("CustomerCode", CodeConvert.GetFlowCode(strProvince, strTelHeader, txtCode.Text.Trim()));

            //***如果存在,可以向部门经理申请该客户为自己的客户            

            sdList.Add("Account", account);


                JSUtility.Alert(customerBiz.Insert(sdList));           

        }
    }
}