﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using BLL;
using Utils;
namespace UI.CrmCustomer
{
    public partial class LinkManAdd : System.Web.UI.Page
    {
        string account = "";
        string linkManID = "";
        LinkManBiz linkManBiz = new LinkManBiz();
        DefDicBiz defDicBiz = new DefDicBiz();

        string customerID = "";
        string custName = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.QueryString["CustomerID"] != null)
            {
                if (Request.QueryString["CustomerID"].ToString() != "")
                    customerID = Request.QueryString["CustomerID"].ToString();
            }
            if (Request.QueryString["CustName"] != null)
            {
                if (Request.QueryString["CustName"].ToString() != "")
                    custName = Request.QueryString["CustName"].ToString();
            }



            if (Request.QueryString["LinkManID"] != null)
            {
                linkManID = Request.QueryString["LinkManID"].ToString();
            }
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
            }
            else
            {
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }
            if (!IsPostBack)
            {
                txtCompanyName.Text = custName;
                hidCompanyID.Value = customerID;
                if (linkManID != "")
                {
                    BindData(linkManID);
                    btnAdd.Enabled = false;
                    JSUtility.AddConfirm(btnModi, "确实要修改吗？");
                    JSUtility.AddConfirm(btnDel, "您真的要删除联系人信息吗？");
                }
                else
                {
                    btnDel.Enabled = false;
                    btnModi.Enabled = false;
                }
            }
        }
        private void BindData(string customerID)
        {
            DataTable dt = linkManBiz.GetOneInfo(customerID);
            if (dt.Rows.Count > 0)
            {
                hidLinkManID.Value = customerID;
                txtCompanyName.Text = dt.Rows[0]["CustName"].ToString();
                hidCompanyID.Value = dt.Rows[0]["CustomerID"].ToString();
                txtAddr.Text = dt.Rows[0]["Addr"].ToString();
                txtAddrCode.Text = dt.Rows[0]["AddrCode"].ToString();
                txtBirthday.Text = StringUtility.GetDateFormat(dt.Rows[0]["Birthday"].ToString());
                    

                txtEmail.Text = dt.Rows[0]["Email"].ToString();
                txtFax.Text = dt.Rows[0]["Fax"].ToString();
                txtFields.Text = dt.Rows[0]["Fields"].ToString();
                txtJobPosition.Text = dt.Rows[0]["JobPosition"].ToString();
                txtMobile.Text = dt.Rows[0]["Mobile"].ToString();
                txtMSN.Text = dt.Rows[0]["MSN"].ToString();
                txtName.Text = dt.Rows[0]["Name"].ToString();
                txtNiceName.Text = dt.Rows[0]["NiceName"].ToString();
                txtProfile.Text = dt.Rows[0]["Profile"].ToString();
                txtQQ.Text = dt.Rows[0]["QQ"].ToString();
                txtTel.Text = dt.Rows[0]["Tel"].ToString();
                txtWebURL.Text = dt.Rows[0]["WebUrl"].ToString();

                defDicBiz.InitDropDownList(ddlSex, dt.Rows[0]["Sex"].ToString());
            }

        }
        protected void btnAdd_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "LinkManAdd.aspx", RightChar.Add))
            {
                if (!AccountBiz.CheckRight(account, "LinkManList.aspx", RightChar.Add))
                {
                    JSUtility.Alert(this, "您没有增加的权限！");
                    return;
                }
            }

            SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
              
            string strCustomerName = txtCompanyName.Text;//客户名称           
            string strCustomerID = hidCompanyID.Value;//客户ID
            if (strCustomerID == null)
            { //根据名称获取ID
                Response.Write(@"<script language='javascript'>alert('请选择联系人所属于的公司！');</script>");
                return;
            }
            sdList.Add("CustomerID", strCustomerID);
            sdList.Add("Name", txtName.Text.Trim());
            sdList.Add("NiceName", txtNiceName.Text.Trim());
            sdList.Add("Sex", ddlSex.SelectedValue.Trim());

            sdList.Add("MSN", txtMSN.Text.Trim());
            sdList.Add("QQ",txtQQ.Text.Trim());
            sdList.Add("Tel",txtTel.Text.Trim());
            sdList.Add("WebUrl",txtWebURL.Text.Trim());
            sdList.Add("Mobile", txtMobile.Text.Trim());

            //下一阶段： 判断日期的有效性
             sdList.Add("Birthday",txtBirthday.Text.Trim());
            sdList.Add("Email",txtEmail.Text.Trim());
            sdList.Add("Fax",txtFax.Text.Trim());
            sdList.Add("Fields",txtFields.Text.Trim());
            sdList.Add("JobPosition", txtJobPosition.Text.Trim());

             sdList.Add("Profile",txtProfile.Text.Trim());
            sdList.Add("Addr",txtAddr.Text.Trim());
            sdList.Add("AddrCode",txtAddrCode.Text.Trim());
            sdList.Add("Account", account);
            if (linkManBiz.Insert(sdList))
            {
                JSUtility.AlertAndRedirect("增加成功！", "CustomerAdd.aspx");
            }
            else
            {
                JSUtility.Alert(this, "增加失败！");
                return;
            }
        }

        protected void btnModi_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "LinkManAdd.aspx", RightChar.Mod))
            {
                if (!AccountBiz.CheckRight(account, "LinkManList.aspx", RightChar.Mod))
                {
                    JSUtility.Alert(this, "您没有更新的权限！");
                    return;
                }
            }
            try
            {
                string linkManID = hidLinkManID.Value;
                if (string.IsNullOrEmpty(linkManID))
                {
                    JSUtility.Alert(this, "您没有更新的权限！");
                    return;
                }
                SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
                string strCustomerName = txtCompanyName.Text;//客户名称           
                string strCustomerID = hidCompanyID.Value;//客户ID
                if (strCustomerID == null)
                { //根据名称获取ID
                    Response.Write(@"<script language='javascript'>alert('请选择联系人所属于的公司！');</script>");
                    return;
                }
                sdList.Add("LinkManID", linkManID);
                sdList.Add("CustomerID", strCustomerID);
                sdList.Add("Name", txtName.Text.Trim());
                sdList.Add("NiceName", txtNiceName.Text.Trim());
                sdList.Add("Sex", ddlSex.SelectedValue.Trim());

                sdList.Add("MSN", txtMSN.Text.Trim());
                sdList.Add("QQ", txtQQ.Text.Trim());
                sdList.Add("Tel", txtTel.Text.Trim());
                sdList.Add("WebUrl", txtWebURL.Text.Trim());
                sdList.Add("Mobile", txtMobile.Text.Trim());

                //下一阶段： 判断日期的有效性
                sdList.Add("Birthday", txtBirthday.Text.Trim());
                sdList.Add("Email", txtEmail.Text.Trim());
                sdList.Add("Fax", txtFax.Text.Trim());
                sdList.Add("Fields", txtFields.Text.Trim());
                sdList.Add("JobPosition", txtJobPosition.Text.Trim());

                sdList.Add("Profile", txtProfile.Text.Trim());
                sdList.Add("Addr", txtAddr.Text.Trim());
                sdList.Add("AddrCode", txtAddrCode.Text.Trim());
                sdList.Add("Account", account);

                if (linkManBiz.Update(sdList))
                {
                    JSUtility.AlertAndRedirect("更新成功！", "LinkManAdd.aspx");
                }
                else
                {
                    JSUtility.Alert(this, "增加失败！");
                    return;
                }             
            }
            catch (Exception ex)
            {
                Response.Write("错误1，错误原因：" + ex.Message);
                Response.End();
            }
        }

        protected void btnDel_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "LinkManAdd.aspx", RightChar.Del))
            {
                if (!AccountBiz.CheckRight(account, "LinkManList.aspx", RightChar.Del))
                {
                    JSUtility.Alert(this, "您没有删除的权限！");
                    return;
                }
            }
            if (linkManID != "0")
            {
                if (linkManBiz.Delete(linkManID))
                {
                    JSUtility.Alert(this, "删除成功");
                    JSUtility.CloseWindow();
                }

                else
                    JSUtility.Alert(this, "删除失败");
            }
            else
                JSUtility.Alert(this, "请先选择数据");
        }
    }
}