﻿using System;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using BLL;
namespace UI.CrmCustomer
{
    public partial class LinkManList : System.Web.UI.Page
    {
        string sessionAccount = "";
        string customerID = "";
        string custName = "";
        string queryStringAccount = "";    
        LinkManBiz linkManBiz = new LinkManBiz();
        protected void Page_Load(object sender, EventArgs e)
        {
            //从Request.QueryString["CustomerID"]获得客户的ID，来显示该客户的所有联系人
            //主要用在查看客户信息的时候，点“客户联系人”来查看该客户的所有联系人
            if (Request.QueryString["CustomerID"] != null)
            {
                if (Request.QueryString["CustomerID"].ToString() != "")
                    customerID = Request.QueryString["CustomerID"].ToString();
            }
            if (Request.QueryString["CustName"] != null)
            {
                if (Request.QueryString["CustName"].ToString() != "")
                    custName = Request.QueryString["CustName"].ToString();
            }
            //从Request.QueryString["AccountID"]获得帐号的ID，显示该帐号的所有联系人
            //主要用在业务经理点每个业务员的时候，看他们的所有联系人
            //Request.QueryString.Keys;

            if (Request.QueryString["Account"] != null)
            {
                if (Request.QueryString["Account"].ToString() != "")
                    queryStringAccount =Request.QueryString["Account"].ToString();
            }
            ////从session获得登陆帐号的ID，显示该帐号的所有联系人
            //主要用在业务员登陆后，查看自己的所有联系人 
            //同时检验了本页面的使用权限，登陆后才能使用

            if (Session["user"] != null)
            {
                User user = Session["user"] as User;          
                sessionAccount = user.Account;
            }
            else
            {
                //弹出提示窗口
                Response.Write("<script>window.alert('您没有登陆！,建议登录之后再操作！') </script>");
                Response.End();
            }
            if (!Page.IsPostBack)
            {
                hlAdd.NavigateUrl = "LinkManAdd.aspx?CustomerID=" + customerID+"&CustName="+custName;
                DataTable dt = linkManBiz.GetList("", customerID, queryStringAccount, sessionAccount);
                gvLinkMan.DataSource = dt;
                gvLinkMan.DataBind();
            }
          
        }
        protected void btnSearch_Click(object sender, EventArgs e)
        {
               string strSearchWord = txtSearchWord.Text.Trim();
            DataTable dt = linkManBiz.GetList(strSearchWord, "", "", sessionAccount);
            gvLinkMan.DataSource = dt;
            gvLinkMan.DataBind();
        }
        protected void gvLinkMan_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            //隐藏前两列
            if (e.Row.RowType == DataControlRowType.DataRow || e.Row.RowType == DataControlRowType.Header)
            {
                e.Row.Cells[0].Visible = false;
                e.Row.Cells[1].Visible = false;
            }
            if (e.Row.RowType == DataControlRowType.DataRow)
            {

                LinkButton lbtnModify = (LinkButton)e.Row.FindControl("lbtnModify");
                LinkButton lbtnDelete = (LinkButton)e.Row.FindControl("lbtnDelete");
                lbtnDelete.Attributes.Add("onclick", "javascript:return confirm('你真的要删除此联系人？');");
            }
        }
        protected void gvLinkMan_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            switch (e.CommandName)
            {
                case "cmdModify":
                    Response.Redirect("LinkManAdd.aspx?LinkManID=" + e.CommandArgument);
                    break;
                case "cmdDelete":
                    linkManBiz.Delete(e.CommandArgument.ToString());                    
                    Response.Redirect("LinkManList.aspx");
                    break;
                default:

                    break;
            }
        }
    }
}