﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using BLL;
using Utils;

namespace UI.CrmCustomer
{
    public partial class SendAddrAdd : System.Web.UI.Page
    {
        string account = "";
        string sendAddrID = "";
        SendAddrBiz sendAddrBiz = new SendAddrBiz();
        DefDicBiz defDicBiz = new DefDicBiz();

        string customerID = "";
        string custName = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.QueryString["CustomerID"] != null)
            {
                if (Request.QueryString["CustomerID"].ToString() != "")
                    customerID = Request.QueryString["CustomerID"].ToString();
            }
            if (Request.QueryString["CustName"] != null)
            {
                if (Request.QueryString["CustName"].ToString() != "")
                    custName = Request.QueryString["CustName"].ToString();
            }

            if (Request.QueryString["SendAddrID"] != null)
            {
                if (Request.QueryString["SendAddrID"].ToString() != "")
                {
                    sendAddrID = Request.QueryString["SendAddrID"].ToString();
                }
               
            }
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
            }
            else
            {
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }
            if (!IsPostBack)
            {
                txtCompanyName.Text = custName;
                hidCompanyID.Value = customerID;

                if (sendAddrID != "")
                {
                    BindData(sendAddrID);
                    btnAdd.Enabled = false;
                    JSUtility.AddConfirm(btnModi, "确实要修改吗？");
                    JSUtility.AddConfirm(btnDel, "您真的要删除联系人信息吗？");
                }
                else
                {
                    btnDel.Enabled = false;
                    btnModi.Enabled = false;
                }
            }
        }

        private void BindData(string customerID)
        {
            DataTable dt = sendAddrBiz.GetOneInfo(customerID);
            if (dt.Rows.Count > 0)
            {
                txtCompanyName.Text = dt.Rows[0]["CustName"].ToString();
                hidCompanyID.Value = dt.Rows[0]["CustomerID"].ToString();
                txtReceiveMan.Text = dt.Rows[0]["ReceiveMan"].ToString();
                txtAddr.Text = dt.Rows[0]["Addr"].ToString();
                txtAddrCode.Text = dt.Rows[0]["AddrCode"].ToString();
                txtMobile.Text = dt.Rows[0]["Mobile"].ToString();
                txtProfile.Text = dt.Rows[0]["Profile"].ToString();
                txtTel.Text = dt.Rows[0]["Tel"].ToString();
             
            }
        }
        protected void btnAdd_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "SendAddrAdd.aspx", RightChar.Add))
            {
                if (!AccountBiz.CheckRight(account, "SendAddrList.aspx", RightChar.Add))
                {
                    JSUtility.Alert(this, "您没有增加的权限！");
                    return;
                }
            }
            SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
            string strCustomerName = txtCompanyName.Text;//客户名称           
            string strCustomerID = hidCompanyID.Value;//客户ID
            if (strCustomerID == null)
            { //根据名称获取ID
                Response.Write(@"<script language='javascript'>alert('请选择联系人所属于的公司！');</script>");
                return;
            }    
            
            sdList.Add("CustomerID", strCustomerID);
            sdList.Add("ReceiveMan", txtReceiveMan.Text.Trim());       
            sdList.Add("Tel", txtTel.Text.Trim());
             sdList.Add("Mobile", txtMobile.Text.Trim());
            sdList.Add("Profile", txtProfile.Text.Trim());
            sdList.Add("Addr", txtAddr.Text.Trim());
            sdList.Add("AddrCode", txtAddrCode.Text.Trim());
            sdList.Add("Account", account);
            
            if (sendAddrBiz.Insert(sdList))
            {
                JSUtility.AlertAndRedirect("增加成功！", "SendAddrAdd.aspx");
            }
            else
            {
                JSUtility.Alert(this, "增加失败！");
                return;
            }
        }

        protected void btnModi_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "SendAddrAdd.aspx", RightChar.Mod))
            {
                if (!AccountBiz.CheckRight(account, "SendAddrList.aspx", RightChar.Mod))
                {
                    JSUtility.Alert(this, "您没有更新的权限！");
                    return;
                }
            }
            try
            {               
                SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
                string strCustomerName = txtCompanyName.Text;//客户名称           
                string strCustomerID = hidCompanyID.Value;//客户ID
                if (strCustomerID == null)
                { //根据名称获取ID
                    Response.Write(@"<script language='javascript'>alert('请选择联系人所属于的公司！');</script>");
                    return;
                }
                sdList.Add("SendAddrID", sendAddrID);
                sdList.Add("CustomerID", strCustomerID);
                sdList.Add("ReceiveMan", txtReceiveMan.Text.Trim());
                sdList.Add("Tel", txtTel.Text.Trim());
                sdList.Add("Mobile", txtMobile.Text.Trim());
                sdList.Add("Profile", txtProfile.Text.Trim());
                sdList.Add("Addr", txtAddr.Text.Trim());
                sdList.Add("AddrCode", txtAddrCode.Text.Trim());
                sdList.Add("Account", account);
                if (sendAddrBiz.Update(sdList))
                {
                    JSUtility.AlertAndRedirect("更新成功！", "SendAddrAdd.aspx");
                }
                else
                {
                    JSUtility.Alert(this, "增加失败！");
                    return;
                }
            }
            catch (Exception ex)
            {
                Response.Write("错误1，错误原因：" + ex.Message);
                Response.End();
            }
        }

        protected void btnDel_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "SendAddrAdd.aspx", RightChar.Del))
            {
                if (!AccountBiz.CheckRight(account, "SendAddr.aspx", RightChar.Del))
                {
                    JSUtility.Alert(this, "您没有删除的权限！");
                    return;
                }
            }
            if (sendAddrID != "")
            {
                if (sendAddrBiz.Delete(sendAddrID))
                {
                    JSUtility.Alert(this, "删除成功");
                    JSUtility.CloseWindow();
                }

                else
                    JSUtility.Alert(this, "删除失败");
            }
            else
                JSUtility.Alert(this, "请先选择数据");
        }



    }
}