﻿using System;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using BLL;
namespace UI.CrmCustomer
{
    public partial class SendAddrList : System.Web.UI.Page
    {
        string customerID = "";
        string custName = "";

        string queryStringAccount = "";//来自于QueryString   次之
        string sessionAccount = "";//来自于 session  最低

       // string strSecSQL = "";//搜索的SQL语句
        SendAddrBiz sendAddrBiz = new SendAddrBiz();

        protected void Page_Load(object sender, EventArgs e)
        {           
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                sessionAccount = user.Account;
            }
            else
            {
                //弹出提示窗口
                Response.Write("<script>window.alert('您没有登陆！,建议登录之后再操作！') </script>");
                Response.End();
            }

            //从Request.QueryString["CustomerID"]获得客户的ID，来显示该客户的所有联系人
            //主要用在查看客户信息的时候，点“客户联系人”来查看该客户的所有联系人
            if (Request.QueryString["CustomerID"] != null)
            {
                if (Request.QueryString["CustomerID"].ToString() != "")
                    customerID = Request.QueryString["CustomerID"].ToString();
            }
            if (Request.QueryString["CustName"] != null)
            {
                if (Request.QueryString["CustName"].ToString() != "")
                    custName = Request.QueryString["CustName"].ToString();
            }
            //从Request.QueryString["AccountID"]获得帐号的ID，显示该帐号的所有联系人
            //主要用在业务经理点每个业务员的时候，看他们的所有联系人
            //Request.QueryString.Keys;
            if (Request.QueryString["Account"] != null)
            {
                if (Request.QueryString["Account"].ToString() != "")
                    queryStringAccount =Request.QueryString["Account"].ToString();
            }
            if (!Page.IsPostBack)
            {
                hlAdd.NavigateUrl = "SendAddrAdd.aspx?CustomerID=" + customerID + "&CustName=" + custName;
                DataTable dt = sendAddrBiz.GetList("", customerID, queryStringAccount, sessionAccount);
                gvList.DataSource = dt;
                gvList.DataBind();
            }
        }
        protected void gvSendAddr_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            //隐藏第一列
            if (e.Row.RowType == DataControlRowType.DataRow || e.Row.RowType == DataControlRowType.Header)
            {
                e.Row.Cells[0].Visible = false;
            }
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                LinkButton lbtnModify = (LinkButton)e.Row.FindControl("lbtnModify");
                LinkButton lbtnDelete = (LinkButton)e.Row.FindControl("lbtnDelete");
                lbtnDelete.Attributes.Add("onclick", "javascript:return confirm('你真的要删除此发货地址？');");
            }
        }
        protected void gvSendAddr_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            switch (e.CommandName)
            {
                case "cmdModify":
                    Response.Redirect("SendAddrAdd.aspx?SendAddrID=" + e.CommandArgument);
                    break;
                case "cmdDelete":
                    sendAddrBiz.Delete(e.CommandArgument.ToString()); 
                    Response.Redirect("SendAddrList.aspx");
                    break;
                default:

                    break;
            }
        }
        protected void btnSearch_Click(object sender, EventArgs e)
        {          
            string strSearchWord = txtSearchWord.Text.Trim();
            DataTable dt = sendAddrBiz.GetList(strSearchWord, "", "", sessionAccount);
            gvList.DataSource = dt;
            gvList.DataBind();
           
        }
    }
}