﻿using System;
using System.Text;
using System.Collections;
using System.Web.UI.WebControls;
using System.Data;
using BLL;
using Utils;

namespace UI.ModAccount
{
    public partial class AccountCopyRight : System.Web.UI.Page
    {
        AccountBiz accountBiz = new AccountBiz();
        string pAccount = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.Params["Account"] != null)
            {
                pAccount = Request.Params["Account"].ToString();
            }
            else
            {
                JSUtility.Alert(this, "参数错误");
                return;
            }
            if (!IsPostBack)
            {
                DataTable dt = accountBiz.GetLists("");
                if (pAccount != "")
                {
                    new DefDicBiz().InitDropDownList(dt, ddlAccount);
                    DataTable roleDt = accountBiz.GetOneInfo(pAccount);
                    if (!string.IsNullOrWhiteSpace(roleDt.Rows[0]["SysRoleID"].ToString()))
                    {
                        MainMenuTreeView.Enabled = false;
                        lbRole.Text = roleDt.Rows[0]["SysRoleID"].ToString();
                    }
                    else
                    Create_MainMenu_TreeView();
                }
            }


        }

        private void Create_MainMenu_TreeView()
        {
            MainMenuTreeView.Nodes.Clear();
            //取出菜单数据
            DataTable dt = accountBiz.GetMenuByAccount(pAccount);
            if (dt.Rows.Count <= 0)
            {
                return;
            }
            else
            {
                this.ViewState["dt"] = dt;

                //调用递归函数，完成树形结构的生成
                AddTree(0, (TreeNode)null);
            }
        }
        //递归添加树的节点
        private void AddTree(int ParentID, TreeNode pNode)
        {
            DataView dvTree = new DataView((DataTable)this.ViewState["dt"]);
            //过滤ParentID,得到当前的所有子节点
            dvTree.RowFilter = "[ParentID] = " + ParentID;

            foreach (DataRowView Row in dvTree)
            {
                TreeNode Node = new TreeNode();

                if (pNode == null)
                {    //添加根节点

                    Node.Text = Row["MenuName"].ToString() + "(" + Row["RightLimit"].ToString() + ")";
                    Node.Value = Row["AccountMenuID"].ToString();
                    MainMenuTreeView.Nodes.Add(Node);

                    //Node.Expanded = true;
                    AddTree(Int32.Parse(Row["MainMenuID"].ToString()), Node);    //再次递归
                }
                else
                {
                    Node.Text = Row["MenuName"].ToString() + "(" + Row["RightLimit"].ToString() + ")";
                    Node.Value = Row["AccountMenuID"].ToString();
                    pNode.ChildNodes.Add(Node);

                    //Node.Expanded = true;
                    AddTree(Int32.Parse(Row["MainMenuID"].ToString()), Node);     //再次递归
                }
            }
        }

        protected void btnCopy_Click(object sender, EventArgs e)
        {
            string role = lbRole.Text;
            string receiveAccount = ddlAccount.SelectedValue;
            if (string.IsNullOrWhiteSpace(role))
            {
                bool copyType = true;
                if (cbType.Checked == false)
                    copyType = false;

                if (receiveAccount == "0" || receiveAccount == "")
                {
                    JSUtility.Alert(this, "请选择接收账号");
                    return;
                }
                if (accountBiz.CopyRightsTo(pAccount, receiveAccount, copyType))
                {
                    JSUtility.Alert(this, "设置成功");
                }
                else
                    JSUtility.Alert(this, "设置失败");
            }
            else
            {try{
                string sql = "DELETE FROM Sys_AccountMenu  WHERE Account='" + receiveAccount + "'; insert into Sys_Account_Role (Account,SysRoleID) select '" + pAccount + "',SysRoleID from Sys_Account_Role' Where Account='" + receiveAccount + "'";
                // where account='01191'

                accountBiz.ExecSQL(sql);
                JSUtility.Alert(this, "设置成功");
            }
            catch (Exception ee)
            { JSUtility.Alert(this, "设置角色失败" + ee.Message); }
            }

        }
    }
}