﻿using System;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using BLL;
//因为要使用颜色，所以我们得引入命名空间
using System.Drawing;
namespace UI.ModAccount
{
    public partial class ModAccount_AccountList : System.Web.UI.Page
    {
        //生成数据库的实例

        DepartmentBiz departmentBiz = new DepartmentBiz();
        AccountBiz accountBiz = new AccountBiz();

        public Int32 iDepartmentID = 0;
        Int32 iSessionDepartmentID = 0;
        Int32 iSessionCompanyID = 0;
        string account = string.Empty;
        string strPropertie = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                iSessionCompanyID = user.CompanyID;
                iSessionDepartmentID = user.DepartemntID;

                account = user.Account;
                strPropertie = user.Propertie;
            }
            else
            {
                //弹出提示窗口
                Response.Write("<script>window.alert('您没有登陆！,建议登录之后再操作！') </script>");
                Response.End();
            }
            if (!IsPostBack)
            {
                departmentBiz.InitDropDownList(ddlDeptID, "0");
                DataTable dt = accountBiz.GetLists("", "0", "NY");
                GVAccount.DataSource = dt;
                GVAccount.DataBind();
            }
        }
        //





        //第一列不显示
        protected void GVAccount_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow || e.Row.RowType == DataControlRowType.Header)
            {
                e.Row.Cells[0].Visible = false;
            }
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                //我们先设置当鼠标上去的时候他的背景色改变
                e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#00FFFF'");
                //下面我们再设置当鼠标离开后背景色再还原
                e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c;");
                //为特定的数改变行样式这也是在这个事件里面，因为这个事件是在数据被绑定的时候执行的

                LinkButton lbtnOpen = (LinkButton)e.Row.FindControl("lbtnOpen");
                LinkButton lbtnClose = (LinkButton)e.Row.FindControl("lbtnClose");
                LinkButton lbtnDelete = (LinkButton)e.Row.FindControl("lbtnDelete");
                LinkButton lbtnConfigMenu = (LinkButton)e.Row.FindControl("lbtnConfigMenu");
                LinkButton lbtnConfigRight = (LinkButton)e.Row.FindControl("lbtnConfigRight");
                LinkButton lbtnTask = (LinkButton)e.Row.FindControl("lbtnTask");
                LinkButton lbtnHid = (LinkButton)e.Row.FindControl("lbtnHid");
                string role = Convert.ToString(DataBinder.Eval(e.Row.DataItem, "角色"));
                string State = Convert.ToString(DataBinder.Eval(e.Row.DataItem, "状态"));//我们得取出行中state字段绑定的值，用他作为判断条件
                if (State == "N")
                { //如果他的值等于，那么
                    e.Row.BackColor = Color.Silver;
                    lbtnOpen.Visible = true;
                    lbtnDelete.Visible = true;
                    lbtnHid.Visible = true;
                }
                else
                {
                    lbtnClose.Visible = true;
                    if (AccountBiz.GetRange(account, "AccountList.aspx") == RangeChar.Super)
                    {
                        lbtnConfigMenu.Visible = true;
                        //if (string.IsNullOrWhiteSpace(role))
                            lbtnConfigRight.Visible = true;
                        if (strPropertie == "sale")
                            lbtnTask.Visible = true;
                    }

                }
                lbtnDelete.Attributes.Add("onclick", "javascript:return confirm('你真的要删除此帐号？');");

            }

        }

        protected void GVAccount_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            string account = "";
            switch (e.CommandName)
            {
                case "cmdOpen":
                    account = e.CommandArgument.ToString();
                    if (accountBiz.UpdateStatu(account, "Y"))
                        Response.Redirect("AccountList.aspx");
                    break;
                case "cmdClose":
                    account = e.CommandArgument.ToString();
                    if (accountBiz.UpdateStatu(account, "N"))
                        Response.Redirect("AccountList.aspx");
                    break;
                case "cmdDelete":
                    account = e.CommandArgument.ToString();
                    if (accountBiz.DeleteOneInfo(account))
                        Response.Redirect("AccountList.aspx");
                    break;
                case "cmdConfigMenu":
                    account = e.CommandArgument.ToString();
                    Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "js", @"<script language='javascript'>ShowLink('../ModAccount/AccountMenuMgr.aspx?Account=" + account + "',800,550);</script>");

                    //Response.Redirect("~/ModAccount/AccountMenuMgr.aspx?Account=" + account);
                    break;
                case "cmdConfigRight":
                    account = e.CommandArgument.ToString();
                    Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "js", @"<script language='javascript'>ShowLink('AccountMenuRight.aspx?Account=" + account + "',800,550);</script>");

                    // Response.Redirect("~/ModAccount/AccountMenuRight.aspx?Account=" + account);
                    break;
                case "cmdTask":
                    account = e.CommandArgument.ToString();
                    Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "js", @"<script language='javascript'>ShowLink('../ModSale/TaskDistributionAddAMember.aspx?Account=" + account + "',800,550);</script>");

                    //Response.Redirect("~/ModSale/TaskDistributionAddAMember.aspx?Account=" + account);
                    break;

                case "cmdHid":
                    account = e.CommandArgument.ToString();
                    if (accountBiz.UpdateStatu(account, "H"))
                        Response.Redirect("AccountList.aspx");
                    break;
            }

        }
        protected void btnSearch_Click(object sender, EventArgs e)
        {
            string serWord = txtSearchWord.Text.Trim();
            string deptID = ddlDeptID.SelectedValue.ToString();
            string stateID = ddlStateID.SelectedValue.ToString();
            DataTable dt = accountBiz.GetLists(serWord, deptID, stateID);

            GVAccount.DataSource = dt;
            GVAccount.DataBind();
        }
    }
}