﻿using System;
using System.Text;
using System.Collections;
using System.Web.UI.WebControls;
using System.Data;
using BLL;
using Utils;
namespace UI.ModAccount
{
    public partial class AccountMenuRight : System.Web.UI.Page
    {
        string account;
        AccountBiz accountBiz = new AccountBiz();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.QueryString["Account"] == null)
            {  //弹出提示窗口
                Response.Write("<script>window.alert('只有选择了帐号才能到该页面操作！')</script>");
                return;
            }
            account = Request.QueryString["Account"].ToString().Trim();
            if ((account == "0") || (string.IsNullOrWhiteSpace(account)))
            {
                //弹出提示窗口
                Response.Write("<script>window.alert('只有选择了帐号才能到该页面操作！')</script>");
                return;
            }
            if (!IsPostBack)
            {
                Create_MainMenu_TreeView();
                this.MainMenuTreeView.Attributes.Add("onclick", "CheckEvent()");
                              
            }
        }

        private void Create_MainMenu_TreeView()
        {
            MainMenuTreeView.Nodes.Clear();
            //取出菜单数据
            DataTable dt = accountBiz.GetMenuByAccount(account);
            if (dt.Rows.Count <= 0)
            {
                return;
            }
            else
            {
                this.ViewState["dt"] = dt;

                //调用递归函数，完成树形结构的生成
                AddTree(0, (TreeNode)null);
            }
        }
        //递归添加树的节点
        private void AddTree(int ParentID, TreeNode pNode)
        {
             DataView dvTree = new DataView((DataTable)this.ViewState["dt"]);
            //过滤ParentID,得到当前的所有子节点
            dvTree.RowFilter = "[ParentID] = " + ParentID;

            foreach (DataRowView Row in dvTree)
            {
                TreeNode Node = new TreeNode();

                if (pNode == null)
                {    //添加根节点

                    Node.Text = Row["MenuName"].ToString() + "(" + Row["RightLimit"].ToString() + "-" + Row["RangeLimit"].ToString() + ")";
                    Node.Value = Row["AccountMenuID"].ToString();
                    MainMenuTreeView.Nodes.Add(Node);
                   
                    //Node.Expanded = true;
                    AddTree(Int32.Parse(Row["MainMenuID"].ToString()), Node);    //再次递归
                }
                else
                {  
                    Node.Text = Row["MenuName"].ToString() + "(" + Row["RightLimit"].ToString() + "-"+Row["RangeLimit"].ToString()+")";
                    Node.Value = Row["AccountMenuID"].ToString();
                    pNode.ChildNodes.Add(Node);
                   
                    //Node.Expanded = true;
                    AddTree(Int32.Parse(Row["MainMenuID"].ToString()), Node);     //再次递归
                }
            }
        }




       
        private string GetString(string strRight, string oldChar, string newChar, int startIndex, int count)
        {
            StringBuilder b = new StringBuilder(strRight);
            b.Replace(oldChar, newChar, startIndex, count);
            return b.ToString();
        }
        protected void btnConfig_Click(object sender, EventArgs e)
        {
            string strRight = "00000000000000000000";
            if (cbAdd.Checked) strRight = GetString(strRight, "0", "1", 0, 1);
            else strRight = GetString(strRight, "1", "0", 0, 1);
            if (cbDel.Checked) strRight = GetString(strRight, "0", "1", 1, 1);
            else strRight = GetString(strRight, "1", "0", 1, 1);
            if (cbMod.Checked) strRight = GetString(strRight, "0", "1", 2, 1);
            else strRight = GetString(strRight, "1", "0", 2, 1);
            if (cbSer.Checked) strRight = GetString(strRight, "0", "1", 3, 1);
            else strRight = GetString(strRight, "1", "0", 3, 1);

            if (cbIn.Checked) strRight = GetString(strRight, "0", "1", 4, 1);
            else strRight = GetString(strRight, "1", "0", 4, 1);
            if (cbOut.Checked) strRight = GetString(strRight, "0", "1", 5, 1);
            else strRight = GetString(strRight, "1", "0", 5, 1);
            if (cbPrint.Checked) strRight = GetString(strRight, "0", "1", 6, 1);
            else strRight = GetString(strRight, "1", "0", 6, 1);

            if (cbCheck.Checked) strRight = GetString(strRight, "0", "1", 7, 1);
            else strRight = GetString(strRight, "1", "0", 7, 1);
            if (cbCancelCheck.Checked) strRight = GetString(strRight, "0", "1", 8, 1);
            else strRight = GetString(strRight, "1", "0", 8, 1);

            if (cbApprove.Checked) strRight = GetString(strRight, "0", "1", 9, 1);
            else strRight = GetString(strRight, "1", "0", 9, 1);
            if (cbCancelApprove.Checked) strRight = GetString(strRight, "0", "1", 10, 1);
            else strRight = GetString(strRight, "1", "0", 10, 1);

            if (cbFei.Checked) strRight = GetString(strRight, "0", "1", 11, 1);
            else strRight = GetString(strRight, "1", "0", 11, 1);
            if (cbCancelFei.Checked) strRight = GetString(strRight, "0", "1", 12, 1);
            else strRight = GetString(strRight, "1", "0", 12, 1);

            if (cbSet.Checked) strRight = GetString(strRight, "0", "1", 13, 1);
            else strRight = GetString(strRight, "1", "0", 13, 1);

           
            ArrayList menuArray = new ArrayList();
            ArrayList newArray = GetAllSelectNodeID(MainMenuTreeView.Nodes, menuArray);           
            string rangeLimit = rbRange.SelectedValue;
            if (accountBiz.SetMenuRight(newArray, strRight, rangeLimit))
            { JSUtility.Alert(this, "设置成功"); }
            else
            { JSUtility.Alert(this, "设置失败"); }
        }

        private ArrayList GetAllSelectNodeID(TreeNodeCollection tnc, ArrayList menuArray)
        {
          
            foreach (TreeNode node in tnc)
            {
              
                if (node.Checked)//如果选中了此菜单
                {
                    menuArray.Add(node.Value.ToString());
 
                }              
                if (node.ChildNodes.Count != 0)
                    GetAllSelectNodeID(node.ChildNodes,menuArray);
            }
            return menuArray;
        }

        protected void btnBack_Click(object sender, EventArgs e)
        {
            Response.Redirect("AccountList.aspx");
        }

    }
}