﻿using System;
using System.Data;
using System.Collections.Generic;
using BLL;
using Utils;
namespace UI.ModAccount
{
    public partial class AccountMod : System.Web.UI.Page
    {
        //生成数据库的实例
        AccountBiz accountBiz = new AccountBiz();
         string account = string.Empty;
  
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.QueryString["Account"] != null)
            {
                account = Request.QueryString["Account"].ToString();
            }
            else
            {
                if (Session["user"] != null)
                {
                    User user = Session["user"] as User;
                    account = user.Account;                  
                }
                else
                {
                    JSUtility.Alert(this, "参数不能为空");
                    return;
                }
            }

           if (!Page.IsPostBack)
            {

            if (account != "")
            {
                BondAccountInfo(account);
    
            }
            }
          

        }
        protected void BondAccountInfo(string account)
        {
            try
            {
                DataTable dt = accountBiz.GetOneInfo(account);
               
                if (dt.Rows.Count > 0)
                {
                    txtAccount.Text = dt.Rows[0]["Account"].ToString();
                    txtEmail.Text = dt.Rows[0]["OfficeEmail"].ToString();
                  
                    txtEmpCode.Text = dt.Rows[0]["EmpCode"].ToString();
                  
                    txtMemo.Text = dt.Rows[0]["Memo"].ToString();
                    txtTel.Text = dt.Rows[0]["OfficeTel"].ToString();

                }
             

              
            }
            catch (Exception ee)
            {
                JSUtility.Alert(this, ee.Message);
            }

        }

        protected void ModifyBtn_Click(object sender, EventArgs e)
        {
            try
            {
                //获得TXT的值
                string strOldPwd = txtOldPwd.Text.Trim();
                string strPassword = txtPassword.Text.Trim();
                string strRePassword = txtRePassword.Text.Trim();
                string tel = txtTel.Text.Trim();
                string empCode = txtEmpCode.Text.Trim();
                string strMemo = txtMemo.Text.Trim();
                string email = txtEmail.Text.Trim();
                string strAccount = account;
                // txtAccount.Text.Trim();
               
                string strMessage = "";
             
                SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
                sdList.Add("Account", strAccount);
                if (!string.IsNullOrWhiteSpace(strOldPwd))
                {

                    DataTable dt = accountBiz.GetOneInfo(account);
                    if (dt.Rows[0]["Password"].ToString() == EncrypUtil.MD5Encrypt(strOldPwd))//如果更改密码
                    {
                        if ((strPassword != strRePassword) || strPassword.Length < 2)
                        {
                            Response.Write(@"<script language='javascript'>alert('新密码两次要输入相同且最小长度为2！');</script>");
                            return;
                        }
                        sdList.Add("Password", Utils.EncrypUtil.MD5Encrypt(strPassword));
                        strMessage = "修改密码成功！";
                    }
                    else
                    { strMessage = "修改注册信息成功！"; }
                }
               
              
                sdList.Add("EmpCode", empCode);
                sdList.Add("OfficeTel", tel);
                sdList.Add("OfficeEmail", email);
            
                sdList.Add("Memo", strMemo);

                if (accountBiz.Update("Sys_Account", sdList))
                    Utils.JSUtility.Alert(this,strMessage);
                else
                    Utils.JSUtility.Alert(this, "更新失败");                

            }
            catch (Exception ee)
            {
                //throw new Exception(ee.Message);
                JSUtility.Alert(this, ee.Message);   
            }
        }
    }
}