﻿using System;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using BLL;
namespace UI.ModAccount
{
    public partial class ModAccount_PersonCantact : System.Web.UI.Page
    {

        public Int32 iDepartmentID = 0;
        //Int32 iSessionCompanyID = 0;
        //Int32 iSessionDepartmentID = 0;
        //Int32 iRoleID = 0;
        //Int32 iAccountID = 0;
        //string strIsSpecial = "";
        //private string strAimTable = "Admin_Department";
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                //从session获得登陆的时候各个帐号储存的数据

                //显示左边帐号列表
                ShowAllCompany();
            }
        }
        protected void ShowAllCompany()
        {
            //string strSelect1 = "SELECT DeptID,ParentID,Name,ItemLevel,IsDir FROM Admin_Department Where  State='Y' Order By AbsIndex DESC";
            DataSet dtAllCompany = new DepartmentBiz().GetDataSet("NOR");
            if (dtAllCompany.Tables[0].Rows.Count <= 0)
            {
                SubLeftID.Visible = false;
            }
            else
            {
                CreatMainMenu(0, dtAllCompany);
            }

        }

        protected void CreatMainMenu(Int32 iLevel, DataSet ds)
        {
            SalesTreeView.Nodes.Clear();
            //取出部门数据
            //string strSQL = "select DeptID,ParentID,Name from aaa order by AbsIndex ASC";
            //DataSet ds = this.link.ExecuteSqlGetDataSet(strSQL);

            if (ds == null)
            {
                return;
            }
            else
            {
                this.ViewState["ds"] = ds;
                //调用递归函数，完成树形结构的生成
                AddTree(iLevel, (TreeNode)null);
            }
        }
        //递归添加树的节点
        private void AddTree(int ParentID, TreeNode pNode)
        {
            DataSet ds = (DataSet)this.ViewState["ds"];
            DataView dvTree = new DataView(ds.Tables[0]);
            //过滤ParentID,得到当前的所有子节点
            dvTree.RowFilter = "[ParentID] = " + ParentID;

            foreach (DataRowView Row in dvTree)
            {
                TreeNode Node = new TreeNode();
                if (pNode == null)
                {    //添加根节点
                    Node.Text = Row["Name"].ToString();
                    Node.Value = Row["DeptID"].ToString();
                    SalesTreeView.Nodes.Add(Node);
                    Node.Expanded = true;
                    AddTree(Int32.Parse(Row["DeptID"].ToString()), Node);    //再次递归
                }
                else
                {   //̀添加当前节点的子节点
                    Node.Text = Row["Name"].ToString();
                    Node.Value = Row["DeptID"].ToString();
                    pNode.ChildNodes.Add(Node);
                    Node.Expanded = true;
                    AddTree(Int32.Parse(Row["DeptID"].ToString()), Node);     //再次递归

                }
            }
        }
        ////
        protected void SalesTreeView_SelectedNodeChanged(object sender, EventArgs e)
        {
            //获得该节点的ID，就是部门ID
            iDepartmentID = Int32.Parse(SalesTreeView.SelectedNode.Value.Trim());

            ShowNewGridview(iDepartmentID);
        }
        //在GridView里面显示新的内容
        protected void ShowNewGridview(Int32 iDepartmentID)
        {
            //取出该部门（公司）下所有分部门的ID
            //----获得所有ID开始
            //string strSQL = "select DeptID,ParentID from " + strAimTable + " order by AbsIndex DESC";
            //DataSet ds = this.link.ExecuteSqlGetDataSet(strSQL);
            DataSet ds = new DepartmentBiz().GetDataSet("NOR");
            //定义公司下面所有部门的ID组成的字符串
            string strDeptIDArray = iDepartmentID.ToString() + ",";
            if (ds == null)
            {
                return;
            }
            else
            {
                this.ViewState["ds"] = ds;
                strDeptIDArray += GetSubID(iDepartmentID);
            }

            //strDeptIDArray.ToString().Remove(strDeptIDArray.ToString().Length-1);
            //--获得所有部门ID结束

            //SELECT [Name], [Account],[Mobile], [OfficeTel], [OfficeEmail] FROM [JimView_Account] WHERE ([DeptID] > @DepartmentID) ORDER BY [DeptID]
            string strSelectSQL = "SELECT [EmpName], [Account],[Mobile], [OfficeTel], [OfficeEmail] FROM [JimView_Account] WHERE State = 'Y' and DeptID in (" + strDeptIDArray.ToString().Remove(strDeptIDArray.ToString().Length - 1) + ") ORDER BY DeptID";
            CantactSDS.SelectCommand = strSelectSQL;
            gvCantact.DataSourceID = CantactSDS.ID;
        }
        //递归获得部门下所有子部门的ID
        protected string GetSubID(Int32 ParentID)
        {
            string strDeptIDArray = "";

            DataSet ds = (DataSet)this.ViewState["ds"];
            DataView dvData = new DataView(ds.Tables[0]);
            //过滤ParentID
            dvData.RowFilter = "[ParentID] = " + ParentID;

            foreach (DataRowView Row in dvData)
            {
                strDeptIDArray += Row["DeptID"].ToString() + ",";
                strDeptIDArray += GetSubID(Int32.Parse(Row["DeptID"].ToString()));
            }
            return strDeptIDArray;
        }

        //////////
        protected void btnSearch_Click(object sender, EventArgs e)
        {
            string strSearchWord = txtSearchWord.Text.Trim();

            string strSearchSQL = "SELECT [EmpName], [Account],[Mobile], [OfficeTel], [OfficeEmail] FROM [JimView_Account] WHERE State = 'Y' and EmpName like '%" + strSearchWord + "%' ORDER BY DeptID ";
            CantactSDS.SelectCommand = strSearchSQL;
            gvCantact.DataSourceID = CantactSDS.ID;

        }
    }
}