﻿using System;
using System.Collections.Generic;
using System.Web.UI.WebControls;
using System.Data;
using BLL;
using Utils;
namespace UI.ModEmployee
{
    public partial class DefDutyAdd : System.Web.UI.Page
    {
        DefDicBiz defineDictionary = new DefDicBiz();
        DutyBiz dutyBiz = new DutyBiz();
        DepartmentBiz departmentBiz = new DepartmentBiz();
        string id = "0";//By Update
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.Params["ID"] != null)
            {
                id = Request.Params["ID"].ToString();
                btnAdd.Enabled = false;
            }
            else
            {
                btnUpdate.Enabled = false;
                btnDelete.Enabled = false;
                btnClo.Enabled = false;
                btnOpen.Enabled = false;
            }

            if (!IsPostBack)
            {
                departmentBiz.InitDropDownList(ddlDeptID, "");//针对一层结构使用
                ddlDeptID.Items.Add(new ListItem("共用", "-1"));
                defineDictionary.InitDropDownList("Admin_Emp_DutyType", ddlDutyType, "0");
                if (id != "0")
                    BindData(id);
                
            }
        }
        private void BindData(string id)
        {
            DataTable dt = defineDictionary.GetOneInfo("Admin_Emp_Duty", id);
            if (dt.Rows.Count > 0)
            {
                txtMemo.Text = dt.Rows[0]["Memo"].ToString();
                txtAbsIndex.Text = dt.Rows[0]["AbsIndex"].ToString();              
                txtName.Text = dt.Rows[0]["Name"].ToString();

               // departmentBiz.InitDropDownList(ddlDeptID, dt.Rows[0]["OfDeptName"].ToString().Trim());
                defineDictionary.InitSynDropDownList(ddlDeptID, dt.Rows[0]["OfDeptName"].ToString().Trim());
                //ddlDeptID.Items.Add(new ListItem("共用", "-1"));
                defineDictionary.InitSynDropDownList2(ddlDutyType, dt.Rows[0]["TypeID"].ToString());
                txtProfile.Text = dt.Rows[0]["Profile"].ToString();
                if (dt.Rows[0]["Statu"].ToString() == "Y") btnOpen.Enabled = false;
                else
                    btnClo.Enabled = false;
            }
            else
            {
                JSUtility.Alert(this, "无数据");
            }

        }
        protected void btnAdd_Click(object sender, EventArgs e)
        {
            string name = txtName.Text.Trim();
            if (string.IsNullOrWhiteSpace(name))
            {
                JSUtility.Alert(this, "名称不能为空！");
                return;
            }
            if (defineDictionary.IsExistOneInfo("Admin_Emp_Duty", name))
            {
                JSUtility.Alert(this, "名称已经使用，请输入新名称！\n（如果该名称被关闭，你可以打开它）");
                return;
            }
            string memo = txtMemo.Text.Trim();
            string absIndex = txtAbsIndex.Text.Trim();//
            if (!Utils.RegexRule.IsInt(absIndex))
            {
                JSUtility.Alert(this, "索引一定要填写数字！");
                return;
            }
            string deptName = ddlDeptID.SelectedItem.Text.Trim();
            if (deptName == "请选择部门")
            {
                JSUtility.Alert(this, "请选择部门！");
                return;
            }
            string dutyType = ddlDutyType.SelectedValue.ToString();
            if (dutyType == "0")
            {
                JSUtility.Alert(this, "请选择职位级别！");
                return;
            }
            SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
            sdList.Add("Name", name);
            sdList.Add("OfDeptName", deptName);
            sdList.Add("Memo", memo);
            sdList.Add("AbsIndex", absIndex);
            sdList.Add("SalIndex", txtSalIndex.Text.Trim());
            sdList.Add("TypeID", dutyType);
            sdList.Add("Profile", txtProfile.Text);
            defineDictionary.Insert("Admin_Emp_Duty", sdList);

            JSUtility.AlertAndRedirect("增加职位成功", "DefDutyAdd.aspx");
            
        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            string name = txtName.Text.Trim();
            if (string.IsNullOrWhiteSpace(name))
            {
                JSUtility.Alert(this, "名称不能为空！");
                return;
            }
          
            string memo = txtMemo.Text.Trim();
            string absIndex = txtAbsIndex.Text.Trim();//
            if (!Utils.RegexRule.IsInt(absIndex))
            {
                JSUtility.Alert(this, "索引一定要填写数字！");
                return;
            }
            string deptName = ddlDeptID.SelectedItem.Text.Trim();
            if (deptName == "请选择部门")
            {
                JSUtility.Alert(this, "请选择部门！");
                return;
            }
            string dutyType = ddlDutyType.SelectedValue.ToString();
            if (dutyType == "0")
            {
                JSUtility.Alert(this, "请选择职位级别！");
                return;
            }
            SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
            sdList.Add("ID", id);
            sdList.Add("Name", name);
            sdList.Add("OfDeptName", deptName);
            sdList.Add("Memo", memo);
            sdList.Add("AbsIndex", absIndex);
            sdList.Add("SalIndex", txtSalIndex.Text.Trim());
            sdList.Add("TypeID", dutyType);
            sdList.Add("Profile", txtProfile.Text);
            defineDictionary.Update("Admin_Emp_Duty", sdList);
           
            JSUtility.Alert(this,"更新职位成功");          
           
        }

        protected void btnDelete_Click(object sender, EventArgs e)
        {

            if (id != "0")
            {
                string info = defineDictionary.Delete("Admin_Emp_Duty", new string[] { "ID", id, "N" });
               //职位被删除，则该职位的下限也要被删除 
                info += defineDictionary.Delete("Admin_Emp_LowLimit", new string[] { "DutyID", id, "N" });
                
                JSUtility.Alert(this,info);
                JSUtility.RefreshParent();
                JSUtility.CloseTimeOut();             
            }
            else
                JSUtility.Alert(this, "请先选择数据");
        }

        protected void btnClo_Click(object sender, EventArgs e)
        {
               if (id != "0")
            {
                if(dutyBiz.CloseDuty(id))
                    JSUtility.Alert(this,"关闭成功");
                else
                    JSUtility.Alert(this, "关闭操作失败");
            }
            else
                JSUtility.Alert(this, "请先选择数据");
        
        }

        protected void btnOpen_Click(object sender, EventArgs e)
        {
       if (id != "0")
            {
                if (dutyBiz.OpenDuty(id))
                    JSUtility.Alert(this, "开启成功");
                else
                    JSUtility.Alert(this, "开启操作失败");           
            }
            else
                JSUtility.Alert(this, "请先选择数据");
        
        }

       
    }
}