﻿using System;
using System.IO;
using System.Text;
using System.Collections.Generic;
using System.Data;
using System.Web.UI.WebControls;
using BLL;
using Utils;
namespace UI.ModEmployee
{
    public partial class DefDutyList : System.Web.UI.Page
    {
        DefDicBiz defineDictionary = new DefDicBiz();
        EmployeeBiz employeeBiz = new EmployeeBiz();
        DutyBiz dutyBiz = new DutyBiz();
      //  string tableName = "Admin_Emp_Duty";
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                btnAdd.Attributes.Add("onclick", "javascript:ShowLink('DefDutyAdd.aspx',600,480);");
                btnView.Attributes.Add("onclick", "javascript:ShowLink('DefDutyGroup.aspx',600,480);");
                defineDictionary.InitDropDownList("Admin_Emp_DutyType", ddlDutyType, "0");
                BindData("Y");
            }
        }

      
        private void BindData(string statu)
        {
            //if (statu == "N")
            //{
            //    btnClose.Visible = false;
            //    btnOpen.Visible = true;
            //}
            //else
            //{
            //    btnClose.Visible = true;
            //    btnOpen.Visible = false;
            //}
            DataTable dt = dutyBiz.GetLists("", statu, "List");
            gvList.DataSource = dt;
            gvList.DataBind();

        }

        protected void btnClose_Click(object sender, EventArgs e)
        {
            string arrayID = "0";
            for (int i = 0; i <= gvList.Rows.Count - 1; i++)
            {
                CheckBox cbox = (CheckBox)gvList.Rows[i].FindControl("CheckBox1");
                if (cbox.Checked == true)
                { 
                    //SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
                   // sdList.Add("ID", gvList.DataKeys[i].Value.ToString());
                   // sdList.Add("Statu", "N");
                   // defineDictionary.Update(tableName, sdList);
                    arrayID += "," + gvList.DataKeys[i].Value.ToString();
                }
            }
            if (!arrayID.EndsWith(","))
            {
                if (dutyBiz.CloseDuty(arrayID)) BindData("Y");
            }
        }

        protected void btnOpen_Click(object sender, EventArgs e)
        {
            string arrayID = "0";
            for (int i = 0; i <= gvList.Rows.Count - 1; i++)
            {
                CheckBox cbox = (CheckBox)gvList.Rows[i].FindControl("CheckBox1");
                if (cbox.Checked == true)
                {
 
                   // SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
                   // sdList.Add("ID", gvList.DataKeys[i].Value.ToString());
                   // sdList.Add("Statu", "Y");
                   // defineDictionary.Update(tableName, sdList);
                    arrayID += "," + gvList.DataKeys[i].Value.ToString();
                }
            }
            if (!arrayID.EndsWith(","))
            {
                if (dutyBiz.OpenDuty(arrayID)) BindData("N");
            }
            
        }

        protected void gvList_RowDataBound(object sender, GridViewRowEventArgs e)
        {

            if (e.Row.RowType == DataControlRowType.DataRow || e.Row.RowType == DataControlRowType.Header)
            {
                e.Row.Cells[1].Visible = false;
            }

        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            string serWord = txtSerWord.Text.Trim();
            string statuType=ddlStatuType.SelectedValue;

            string sortWay = ddlSortWay.SelectedValue;

            DataTable dt = dutyBiz.GetLists(serWord, statuType, sortWay);
            gvList.DataSource = dt;
            gvList.DataBind();
        }

        protected void btnGroup_Click(object sender, EventArgs e)
        {
            try
            {
                string empCode = txtEmpCode.Text.Trim();
                if (string.IsNullOrWhiteSpace(empCode))
                {
                    JSUtility.Alert(this, "请输入工号!");
                    return;
                }
                if (!employeeBiz.IsExistEmpCode(empCode))
                {
                    JSUtility.Alert(this, "员工编号不存在");
                    return;
                }
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i <= gvList.Rows.Count - 1; i++)
                {
                    CheckBox cbox = (CheckBox)gvList.Rows[i].FindControl("CheckBox1");
                    if (cbox.Checked == true)
                    {
                        builder.Append(gvList.DataKeys[i].Value.ToString() + ",");
                    }
                }
             
                if (builder == null)
                { //删除
                    //defineDictionary.Delete("Admin_Emp_DutyGroup", new string[] { "EmpCode", empCode, "S" });
                    dutyBiz.DelDutyGroup(empCode);
                }
                else
                {
                    dutyBiz.DelDutyGroup(empCode);
                   // defineDictionary.Delete("Admin_Emp_DutyGroup", new string[] { "EmpCode", empCode, "S" });
                    string filter = "(" + builder.ToString() + "0)";
                    SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
                    sdList.Add("EmpCode", empCode);
                    sdList.Add("DutyArray", filter);
                    defineDictionary.Insert("Admin_Emp_DutyGroup", sdList);
                    JSUtility.Alert(this, "增加成功!");
                }
            }
            catch (Exception ee)
            {
                JSUtility.Alert(this, ee.Message);
            }

        }

        protected void btnNoUse_Click(object sender, EventArgs e)
        {          
            if (dutyBiz.CloseNoUseDuty())
            { JSUtility.Alert(this, "关闭成功!"); }
            else
            { JSUtility.Alert(this, "关闭失败!"); }

        }

        protected void btnType_Click(object sender, EventArgs e)
        {
            string dutyType = ddlDutyType.SelectedValue.ToString();
            if (dutyType == "0")
            {
                JSUtility.Alert(this, "请选择职位级别！");
                return;
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i <= gvList.Rows.Count - 1; i++)
            {
                CheckBox cbox = (CheckBox)gvList.Rows[i].FindControl("CheckBox1");
                if (cbox.Checked == true)
                {
                    builder.Append(gvList.DataKeys[i].Value.ToString() + ",");
                }
            }
            if (builder != null)
            {
                string filter = "(" + builder.ToString() + "0)";
                if (dutyBiz.SetDutyType( dutyType, filter))
                { JSUtility.Alert(this, "设置成功!"); }
                else
                { JSUtility.Alert(this, "设置失败!"); }
            }
            else
            { JSUtility.Alert(this, "没有选择职位!"); }
        }
    }
}