﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using BLL;
using Utils;
namespace UI.ModEmployee
{
    public partial class EmpAdd : System.Web.UI.Page
    {
        DefDicBiz defDicBiz = new DefDicBiz();
        EmployeeBiz employeeBiz = new EmployeeBiz();

        string empCode = "";//更新
        string account = "";

        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
            }
            else
            {
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }
            if (Request.QueryString["EmpCode"] != null)
            {
                empCode = Request.QueryString["EmpCode"].ToString();
            }
            if (!IsPostBack)
            {
                defDicBiz.InitDropDownList("Admin_Emp_Duty", ddlDutyID, "0");
                defDicBiz.InitDropDownList("Admin_Work_State", ddlStateID, "试用期");
                defDicBiz.InitDropDownList("Admin_Work_Area", ddlAreaID, "未知");
                defDicBiz.InitDropDownList("Admin_Emp_Education", ddlEducationID, "大专");


                if (empCode != "")
                {
                    BindEmpInfo(empCode);
                }
                else
                {
                    JSUtility.AddConfirm(btnDelete, "您真的要删除该员工的信息吗？");
                    //insert new info
                    defDicBiz.InitXMLDropDownList(ddlSalaryState, "SalaryState.xml", "无");
                    new DepartmentBiz().InitDropDownList(ddlDeptID, "");//针对一层结构使用
                    txtJoinTime.Text = System.DateTime.Now.ToString("yyyy-MM-dd");
                }




            }
        }
        private void BindEmpInfo(string empCode)
        {
            DataTable dt = employeeBiz.GetOneInfo(empCode);
            if (dt.Rows.Count > 0)
            {
                btnAdd.Enabled = false;
                txtEmpCode.Text = empCode;
                txtEmpName.Text = dt.Rows[0]["EmpName"].ToString();
                //ddlEmpSex.SelectedValue.Trim();

                //ddlDeptID.SelectedValue.Trim();
                //ddlDutyID.SelectedValue.Trim();
                //ddlAreaID.SelectedValue.Trim();
                //ddlStateID.SelectedValue.Trim();
                if (dt.Rows[0]["StateID"].ToString() == "3")//离职超过45天不能更新
                {
                    if (StringUtility.GetDiffDays(dt.Rows[0]["LeaveTime"].ToString(), DateTime.Now.ToString("yyyy-MM-dd")) > 45)
                        btnUpdate.Enabled = false; //离职的档案不可修改
                }
                defDicBiz.InitDropDownList(ddlEmpSex, dt.Rows[0]["EmpSex"].ToString().Trim());
                defDicBiz.InitDropDownList(ddlDutyID, dt.Rows[0]["DutyID"].ToString());
                defDicBiz.InitDropDownList(ddlStateID, dt.Rows[0]["StateID"].ToString());
                ddlStateID.Enabled = false;
                defDicBiz.InitDropDownList(ddlAreaID, dt.Rows[0]["AreaID"].ToString());
                defDicBiz.InitDropDownList(ddlEducationID, dt.Rows[0]["EducationID"].ToString());

                new DepartmentBiz().InitDropDownList(ddlDeptID, dt.Rows[0]["DeptID"].ToString());

                // new DepartmentBiz().InitDropDownList(ddlDeptID, dt.Rows[0]["DeptID"].ToString());

                txtSalaryAccount.Text = dt.Rows[0]["SalaryAccount"].ToString();
                txtWorkGroup.Text = dt.Rows[0]["WorkGroup"].ToString();
                txtSafetyAmount.Text = dt.Rows[0]["SafetyAmount"].ToString();
                txtZipCode.Text = dt.Rows[0]["ZipCode"].ToString();

                defDicBiz.InitDropDownList(ddlIsCheck, dt.Rows[0]["IsCheck"].ToString());
                defDicBiz.InitXMLDropDownList(ddlSalaryState, "SalaryState.xml", dt.Rows[0]["SalaryState"].ToString());
                string birthday = dt.Rows[0]["Birthday"].ToString();
                if (Utils.RegexRule.IsDate(birthday))
                    txtBirthday.Text = Convert.ToDateTime(birthday).ToString("yyyy-MM-dd");

                //txtBirthday.Text = dt.Rows[0]["Birthday"].ToString();

                defDicBiz.InitDropDownList(ddlHrFrom, dt.Rows[0]["HrFrom"].ToString());
                defDicBiz.InitDropDownList(ddlVehicle, dt.Rows[0]["Vehicle"].ToString());

                txtNowAddr.Text = dt.Rows[0]["NowAddr"].ToString();
                txtWishWorkAddr.Text = dt.Rows[0]["WishWorkAddr"].ToString();
                txtSpecialRelation.Text = dt.Rows[0]["SpecialRelation"].ToString();
                txtSpecialLinkWay.Text = dt.Rows[0]["SpecialLinkWay"].ToString();
                txtSpecialLinkMan.Text = dt.Rows[0]["SpecialLinkMan"].ToString();

                defDicBiz.InitDropDownList(ddlIsMarry, dt.Rows[0]["IsMarry"].ToString());
                txtNationality.Text = dt.Rows[0]["Nationality"].ToString();
                txtRegistry.Text = dt.Rows[0]["Registry"].ToString();

                txtMobile.Text = dt.Rows[0]["Mobile"].ToString();
                txtHomeTel.Text = dt.Rows[0]["HomeTel"].ToString();


                txtAddr.Text = dt.Rows[0]["Addr"].ToString();

                string leaveTime = dt.Rows[0]["LeaveTime"].ToString();
                ViewState["VsLeaveTime"] = leaveTime;
                txtComputerLevel.Text = dt.Rows[0]["ComputerLevel"].ToString();
                txtLearnExperience.Text = dt.Rows[0]["LearnExperience"].ToString();
                txtJobExperience.Text = dt.Rows[0]["JobExperience"].ToString();
                txtFamilyMember.Text = dt.Rows[0]["FamilyMember"].ToString();

                string joinTime = dt.Rows[0]["JoinTime"].ToString();
                if (Utils.RegexRule.IsDate(joinTime))
                    txtJoinTime.Text = Convert.ToDateTime(joinTime).ToString("yyyy-MM-dd");


                txtTestTimeLong.Text = dt.Rows[0]["TestTimeLong"].ToString();


                txtMemo.Text = dt.Rows[0]["Memo"].ToString();


            }

        }



        protected void btnAdd_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpAdd.aspx", RightChar.Add))
            {
                if (!AccountBiz.CheckRight(account, "EmpList.aspx", RightChar.Add))
                {
                    JSUtility.Alert(this, "您没有增加员工的权限！");
                    return;
                }
            }
            string areaID = ddlAreaID.SelectedValue.Trim();
            if (areaID == "0")
            {
                JSUtility.Alert(this, "请选择区域");
                return;
            }
            string empCode = txtEmpCode.Text.Trim();
            SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
            sdList.Add("EmpCode", empCode);
            sdList.Add("EmpName", txtEmpName.Text.Trim());
            sdList.Add("EmpSex", ddlEmpSex.SelectedValue.Trim());
            sdList.Add("DeptID", ddlDeptID.SelectedValue.Trim());
            sdList.Add("DutyID", ddlDutyID.SelectedValue.Trim());
            sdList.Add("AreaID", areaID);
            sdList.Add("StateID", (ddlStateID.SelectedValue.Trim() == "") ? "0" : ddlStateID.SelectedValue.Trim());
            sdList.Add("WorkGroup", txtWorkGroup.Text.Trim());
            sdList.Add("SafetyAmount", (txtSafetyAmount.Text.Trim() == "") ? "0" : txtSafetyAmount.Text.Trim());
            sdList.Add("ZipCode", txtZipCode.Text.Trim());
            sdList.Add("IsCheck", ddlIsCheck.SelectedValue.Trim());
      

            sdList.Add("Birthday", txtBirthday.Text.Trim());
            sdList.Add("IsMarry", ddlIsMarry.SelectedValue.Trim());
            sdList.Add("Nationality", txtNationality.Text.Trim());
            sdList.Add("Registry", txtRegistry.Text.Trim());

            sdList.Add("Mobile", txtMobile.Text.Trim());
            sdList.Add("HomeTel", txtHomeTel.Text.Trim());


            sdList.Add("Addr", txtAddr.Text.Trim());

            sdList.Add("EducationID", (ddlEducationID.SelectedValue.Trim() == "") ? "0" : ddlEducationID.SelectedValue.Trim());

            sdList.Add("ComputerLevel", txtComputerLevel.Text.Trim());
            sdList.Add("LearnExperience", RegexRule.HTMLEncode(txtLearnExperience.Text.Trim()));
            sdList.Add("JobExperience", RegexRule.HTMLEncode(txtJobExperience.Text.Trim()));
            sdList.Add("FamilyMember", RegexRule.HTMLEncode(txtFamilyMember.Text.Trim()));

            string ttl = (txtTestTimeLong.Text.Trim() == "") ? "0" : txtTestTimeLong.Text.Trim();

            sdList.Add("JoinTime", txtJoinTime.Text.Trim());
            sdList.Add("TestTimeLong", ttl);
            if (ttl=="0")
                sdList.Add("TestEndTime", txtJoinTime.Text.Trim());




            sdList.Add("Memo", RegexRule.HTMLEncode(txtMemo.Text.Trim()));
            sdList.Add("WishWorkAddr", txtWishWorkAddr.Text.Trim());
            sdList.Add("NowAddr", txtNowAddr.Text.Trim());
            sdList.Add("HrFrom", ddlHrFrom.SelectedValue.Trim());
            sdList.Add("Vehicle", ddlVehicle.SelectedValue.Trim());
            sdList.Add("SpecialLinkMan", txtSpecialLinkMan.Text.Trim());
            sdList.Add("SpecialLinkWay", txtSpecialLinkWay.Text.Trim());
            sdList.Add("SpecialRelation", txtSpecialRelation.Text.Trim());
            sdList.Add("Account", account);

            
                SortedDictionary<string, string> hList = new SortedDictionary<string, string>();
                hList.Add("EmpCode", txtEmpCode.Text.Trim());
                hList.Add("EmpName", txtEmpName.Text.Trim());
                hList.Add("BankName", ddlSalaryState.SelectedValue.Trim());
                hList.Add("BankAccount", txtSalaryAccount.Text.Trim());
             
                
                    JSUtility.Alert(this, employeeBiz.Insert(sdList, hList));           

        }



        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpAdd.aspx", RightChar.Mod))
            {
                if (!AccountBiz.CheckRight(account, "EmpList.aspx", RightChar.Mod))
                {
                    JSUtility.Alert(this, "您没有修改员工的权限！");
                    return;
                }
            }
            string stateID = ddlStateID.SelectedValue.Trim();
            if (stateID == "" || stateID == "0")
            {
                JSUtility.Alert(this, "必须选择员工状态");
                return;
            }

            string bankAccount = txtSalaryAccount.Text.Trim();
            SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
            sdList.Add("EmpCode", txtEmpCode.Text.Trim());
            sdList.Add("EmpName", txtEmpName.Text.Trim());
            sdList.Add("EmpSex", ddlEmpSex.SelectedValue.Trim());
            sdList.Add("DeptID", ddlDeptID.SelectedValue.Trim());
            sdList.Add("DutyID", ddlDutyID.SelectedValue.Trim());
            sdList.Add("AreaID", (ddlAreaID.SelectedValue.Trim() == "") ? "0" : ddlAreaID.SelectedValue.Trim());
            sdList.Add("StateID", stateID);
            sdList.Add("WorkGroup", txtWorkGroup.Text.Trim());
            sdList.Add("SafetyAmount", (txtSafetyAmount.Text.Trim() == "") ? "0" : txtSafetyAmount.Text.Trim());
            sdList.Add("ZipCode", txtZipCode.Text.Trim());
            sdList.Add("IsCheck", ddlIsCheck.SelectedValue.Trim());
           ///// sdList.Add("SalaryState", ddlSalaryState.SelectedValue.Trim());
           ///// sdList.Add("SalaryAccount", bankAccount);
            sdList.Add("Birthday", txtBirthday.Text.Trim());

            sdList.Add("IsMarry", ddlIsMarry.SelectedValue.Trim());
            sdList.Add("Nationality", txtNationality.Text.Trim());
            sdList.Add("Registry", txtRegistry.Text.Trim());

            sdList.Add("Mobile", txtMobile.Text.Trim());
            sdList.Add("HomeTel", txtHomeTel.Text.Trim());


            sdList.Add("Addr", txtAddr.Text.Trim());

            sdList.Add("EducationID", (ddlEducationID.SelectedValue.Trim() == "") ? "0" : ddlEducationID.SelectedValue.Trim());

            sdList.Add("ComputerLevel", txtComputerLevel.Text.Trim());
            sdList.Add("LearnExperience", RegexRule.HTMLEncode(txtLearnExperience.Text.Trim()));
            sdList.Add("JobExperience", RegexRule.HTMLEncode(txtJobExperience.Text.Trim()));
            sdList.Add("FamilyMember", RegexRule.HTMLEncode(txtFamilyMember.Text.Trim()));
            string leaveTime = "";
            if (ViewState.Count > 0)  leaveTime = ViewState["VsLeaveTime"].ToString();
            //
            if (stateID == "3")
            {
                if (leaveTime == "")
                    sdList.Add("LeaveTime", System.DateTime.Now.ToString("yyyy-MM-dd"));
            }
            else
            {
                if (leaveTime != "")
                    sdList.Add("LeaveTime", "null");//XmlUtility.GetWebParam("DateOfLeaveTime")
            }

            string ttl = (txtTestTimeLong.Text.Trim() == "") ? "0" : txtTestTimeLong.Text.Trim();
            sdList.Add("JoinTime", txtJoinTime.Text.Trim());
            sdList.Add("TestTimeLong", ttl);
            if (ttl == "0")
                sdList.Add("TestEndTime", txtJoinTime.Text.Trim());
            else
                sdList.Add("TestEndTime", "null");
            
            sdList.Add("WishWorkAddr", txtWishWorkAddr.Text.Trim());
            sdList.Add("NowAddr", txtNowAddr.Text.Trim());
            sdList.Add("HrFrom", ddlHrFrom.SelectedValue.Trim());
            sdList.Add("Vehicle", ddlVehicle.SelectedValue.Trim());
            sdList.Add("SpecialLinkMan", txtSpecialLinkMan.Text.Trim());
            sdList.Add("SpecialLinkWay", txtSpecialLinkWay.Text.Trim());
            sdList.Add("SpecialRelation", txtSpecialRelation.Text.Trim());
            sdList.Add("Account", account);
            sdList.Add("Memo", RegexRule.HTMLEncode(txtMemo.Text.Trim()));

          
                SortedDictionary<string, string> hList = new SortedDictionary<string, string>();
                hList.Add("EmpCode", txtEmpCode.Text.Trim());
                hList.Add("EmpName", txtEmpName.Text.Trim());
                hList.Add("BankName", ddlSalaryState.SelectedValue.Trim());
                hList.Add("BankAccount", bankAccount);
            
                    JSUtility.Alert(this, employeeBiz.Update(sdList, hList));
           

        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpAdd.aspx", RightChar.Ser))
            {
                if (!AccountBiz.CheckRight(account, "EmpList.aspx", RightChar.Ser))
                {
                    JSUtility.Alert(this, "您没有查询的权限！");
                    return;
                }
            }
            string empCode = txtEmpCode.Text.Trim();
            if (!string.IsNullOrWhiteSpace(empCode))
            {
                BindEmpInfo(empCode);
            }
            else
            {
                JSUtility.Alert(this, "没有该员工信息");
            }
        }

        protected void btnDelete_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpAdd.aspx", RightChar.Del))
            {
                if (!AccountBiz.CheckRight(account, "EmpList.aspx", RightChar.Del))
                {
                    JSUtility.Alert(this, "您没有删除员工的权限！");
                    return;
                }
            }
            string empCode = txtEmpCode.Text.Trim();
            if (!string.IsNullOrWhiteSpace(empCode))
            {
                if (employeeBiz.DeleteOneInfo(empCode))
                    JSUtility.Alert(this, "删除信息成功");
                else
                    JSUtility.Alert(this, "删除信息失败");
            }
            else
            {
                JSUtility.Alert(this, "请输入员工编号");
            }
        }

        protected void txtEmpCode_TextChanged(object sender, EventArgs e)
        {
            string empCode = txtEmpCode.Text.Trim();
            if (!string.IsNullOrWhiteSpace(empCode))
            {
                BindEmpInfo(empCode);
            }

        }

        protected void ddlDeptID_SelectedIndexChanged(object sender, EventArgs e)
        {
            string deptName = ddlDeptID.SelectedItem.Text.Trim();
            // defDicBiz.InitDropDownList("Admin_Emp_Duty", ddlDutyID, defaultSelectItem);
            DataTable dt = new DutyBiz().GetDutyLists("Admin_Emp_Duty", deptName);
            defDicBiz.InitDropDownList(dt, ddlDutyID);
        }

        //protected void txtEmpCode_TextChanged(object sender, EventArgs e)
        //{
        //    string code = txtEmpCode.Text.Trim();
        //    BindEmpInfo(code);
        //}


    }
}