﻿using System;
using System.Data;
using System.Text;
using BLL;
using Utils;
namespace UI.ModEmployee
{
    public partial class EmpCreateCodeList : System.Web.UI.Page
    {
        string strHead = "0";
        EmployeeBiz employeeBiz = new EmployeeBiz();
        string account = "";
        int deptID =0;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
                deptID = user.DepartemntID;
                if (AccountBiz.GetRange(account, "EmpCreateCodeList.aspx") !=RangeChar.Super) btnCreate.Enabled = false;
            }
            else
            {
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }
            if (Request.Params["StrHead"] != null)
            {
                strHead = Request.Params["StrHead"].ToString();
            }
            FillContent("0",strHead);
            if (!IsPostBack)
            {
                new DepartmentBiz().InitDropDownList(ddlDeptID, deptID.ToString());
                txtLen.Text = XmlUtility.GetWebParam("EmpCodeLength");
            }

        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            string serWord = txtSerWord.Text.Trim();
            string inDeptID = ddlDeptID.SelectedValue.ToString();
       
            FillContent(inDeptID, serWord);
        }
       

        private void FillContent(string deptID,string serWord)
        {

            DataTable dt = employeeBiz.GetCodeList(deptID,serWord);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                if (dt.Rows[i]["Statu"].ToString()=="R")
                    builder.Append("<a href=\"javascript:ShowLink('EmpCreateCodeSet.aspx?StrCode=" + dt.Rows[i]["EmpCode"].ToString() + "',300,200)\"><font color=red>" + dt.Rows[i]["EmpCode"].ToString() + "  " + dt.Rows[i]["EmpName"].ToString() + "</font></a> &nbsp;&nbsp;");
                else
                builder.Append("<a href=\"javascript:ShowLink('EmpCreateCodeSet.aspx?StrCode="+dt.Rows[i]["EmpCode"].ToString()+"',300,210)\">"+dt.Rows[i]["EmpCode"].ToString()+"</a> ");
            }
            ltContent.Text = builder.ToString();
        }

        protected void btnCreate_Click(object sender, EventArgs e)
        {
            string len = txtLen.Text.Trim();
            if (RegexRule.IsInt(len))
            {
                if (employeeBiz.CreateCodeDict(len))
                {
                    JSUtility.Alert(this, "生成成功！");
                }
                else
                { JSUtility.Alert(this, "生成失败！"); }
            }
            else
                JSUtility.Alert(this, "请输入一个小于9的整数！");

        }
    }
}