﻿using System;
using System.Data;
using BLL;
using Utils;
namespace UI.ModEmployee
{
    public partial class EmpCreateCodeSet : System.Web.UI.Page
    {
        string strCode = "0";
        EmployeeBiz employeeBiz=new EmployeeBiz();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] == null)
            {
               
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }
            if (Request.Params["StrCode"] != null)
            {
                strCode = Request.Params["StrCode"].ToString();
            }
            if (!IsPostBack)
            {
                
                if (strCode != "0")
                {
                    DataTable dt = employeeBiz.GetCodeStatu(strCode);
                    if (dt.Rows.Count > 0)
                    {
                        string strStatu = dt.Rows[0]["Statu"].ToString();
                        if (strStatu == "R") rbSet.Checked = true;
                        else if (strStatu == "Y") rbCancel.Checked = true;
                        else if (strStatu == "N") rbRefuse.Checked = true;
                        txtEmpName.Text = dt.Rows[0]["EmpName"].ToString();
                        new DepartmentBiz().InitDropDownList(ddlDeptID, dt.Rows[0]["DeptID"].ToString());
                    }
                }
                else
                { new DepartmentBiz().InitDropDownList(ddlDeptID, "0"); }
            }
        }

        protected void btnSet_Click(object sender, EventArgs e)
        {
            string statu=string.Empty;
            lbTitle.Text = strCode;
            if (rbSet.Checked)
            {
                statu = "R";
            }
            else if (rbCancel.Checked)
            {
                statu = "Y";
            }
            else if (rbRefuse.Checked)
            {
                statu = "N";
            }
            else
            { }
            if (strCode == "0") return;

            string deptID = ddlDeptID.SelectedValue.ToString();
            string empName = txtEmpName.Text.Trim();
            if (statu != "R")
            { deptID = "0";
              empName = "";
            }
            if (employeeBiz.SetCodeStatu(strCode, deptID, empName,statu))
                JSUtility.CloseAndRefresh();
            else
                JSUtility.Alert(this, "设置失败");
        }
    }
}