﻿using System;
using System.Collections.Generic;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using BLL;
using Utils;

namespace UI.ModEmployee
{
    public partial class EmpDutyAdd : System.Web.UI.Page
    {
        EmployeeBiz employeeBiz = new EmployeeBiz();
        EmpDutyBiz empDutyBiz = new EmpDutyBiz();
        DefDicBiz defDicBiz = new DefDicBiz();
        DepartmentBiz departmentBiz = new DepartmentBiz();
        IBizSQL iBizSQL = new BizSQL();
        string id = "0";//By Update
        string account = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
            }
            else
            {
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }
            if (Request.Params["ID"] != null)
            {
                id = Request.Params["ID"].ToString();
                btnAdd.Enabled = false;
            }
            else
            {
                btnUpdate.Enabled = false;
                btnDelete.Enabled = false;
            }
            if (!IsPostBack)
            {
                //ddlChangeTypeName
                this.InputAccount.Value = account;
                if (id != "0")
                {
                     BindData(id);
                }
                else
                {
                    defDicBiz.InitDropDownList(departmentBiz.GetCompany(),ComID, "");                 
                    defDicBiz.InitDropDownList("Admin_Emp_Duty", DutyID, "0");
                    defDicBiz.InitDropDownList("Admin_Work_Area", AreaID, "0");
                    defDicBiz.InitDropDownList("Admin_Work_State", StateID, "0");
                    departmentBiz.InitDropDownList(DeptID, "0");

                    BTime.Text = System.DateTime.Now.ToString("yyyy-MM-dd");
                }
                JSUtility.AddConfirm(btnDelete, "您真的要删除该信息吗？");


            }
        }
        private void BindData(string id)
        {
            DataTable dt = empDutyBiz.GetOneInfo(id);
            if (dt.Rows.Count > 0)
            {
                
                EmpCode.Text = dt.Rows[0]["EmpCode"].ToString();
                this.EimID.Value = id.ToString();
               
                DataTable dt2 = employeeBiz.GetOneInfo(dt.Rows[0]["EmpCode"].ToString());
                if (dt2.Rows.Count > 0)
                {
                    OldComName.Text = dt2.Rows[0]["ComName"].ToString();
                    OldDeptName.Text = dt2.Rows[0]["DeptName"].ToString();
                    OldDutyName.Text = dt2.Rows[0]["DutyName"].ToString();
                    OldAreaName.Text = dt2.Rows[0]["AreaName"].ToString();
                    EmpName.Text = dt2.Rows[0]["EmpName"].ToString();
                    StateName.Text = dt2.Rows[0]["StateName"].ToString();
                }

                defDicBiz.InitDropDownList(departmentBiz.GetCompany(), ComID, dt.Rows[0]["ComID"].ToString());  
                defDicBiz.InitDropDownList("Admin_Emp_Duty", DutyID, dt.Rows[0]["DutyID"].ToString());
                departmentBiz.InitDropDownList(DeptID, dt.Rows[0]["DeptID"].ToString());
                defDicBiz.InitDropDownList("Admin_Work_Area", AreaID, dt.Rows[0]["AreaID"].ToString());
                defDicBiz.InitDropDownList("Admin_Work_State", StateID, dt.Rows[0]["StateID"].ToString());

                string bTime = dt.Rows[0]["BTime"].ToString();
                if (Utils.RegexRule.IsDate(bTime))
                    BTime.Text = Convert.ToDateTime(bTime).ToString("yyyy-MM-dd");
                string eTime = dt.Rows[0]["ETime"].ToString();
                if (Utils.RegexRule.IsDate(eTime))
                    ETime.Text = Convert.ToDateTime(eTime).ToString("yyyy-MM-dd");
                Memo.Text = dt.Rows[0]["Memo"].ToString();

            }
            else
            {
                JSUtility.Alert(this, "无数据");
            }

        }
        protected void txtEmpCode_TextChanged(object sender, EventArgs e)
        {
            string empCode = EmpCode.Text.Trim();
            if (!string.IsNullOrWhiteSpace(empCode))
            {
                if (Utils.StringUtility.IncludeHZ(empCode))//如果包含汉字
                {
                    DataTable dt = employeeBiz.GetOneInfoByName(empCode);
                    if (dt.Rows.Count == 0)
                    {
                        JSUtility.Alert(this, "不存在该员工姓名: " + empCode);
                    }
                    else if (dt.Rows.Count == 1)
                    {
                        if (dt.Rows[0]["StateName"].ToString() != "离职")
                        {
                            EmpCode.Text = dt.Rows[0]["EmpCode"].ToString();
                            OldComName.Text = dt.Rows[0]["ComName"].ToString();
                            OldDeptName.Text = dt.Rows[0]["DeptName"].ToString();
                            OldDutyName.Text = dt.Rows[0]["DutyName"].ToString();
                            EmpName.Text = dt.Rows[0]["EmpName"].ToString();
                            StateName.Text = dt.Rows[0]["StateName"].ToString();
                            OldAreaName.Text = dt.Rows[0]["AreaName"].ToString();

                            defDicBiz.InitSynDropDownList(ComID, dt.Rows[0]["ComName"].ToString());  
                            defDicBiz.InitSynDropDownList(DutyID, dt.Rows[0]["DutyName"].ToString());
                            defDicBiz.InitSynDropDownList(DeptID, dt.Rows[0]["DeptName"].ToString());
                            defDicBiz.InitSynDropDownList(AreaID, dt.Rows[0]["AreaName"].ToString());
                            defDicBiz.InitSynDropDownList(StateID, dt.Rows[0]["StateName"].ToString());
                        }
                        else
                            JSUtility.Alert(this, "该员工已经离职(复职之后才能操作): " + empCode);
                    }
                    else
                    {
                        string info = "存在同名，请输入工号：\n\n";
                        for (int i = 0; i < dt.Rows.Count; i++)
                        {
                            info += dt.Rows[i]["EmpCode"].ToString() + "  " + dt.Rows[i]["EmpName"].ToString() + "\n";
                        }
                        JSUtility.Alert(this, info);
                    }
                }
                else
                {
                    DataTable dt = employeeBiz.GetOneInfo(empCode);
                    if (dt.Rows.Count > 0)
                    {
                        EmpName.Text = dt.Rows[0]["EmpName"].ToString();
                        OldComName.Text = dt.Rows[0]["ComName"].ToString();
                        OldDeptName.Text = dt.Rows[0]["DeptName"].ToString();
                        OldDutyName.Text = dt.Rows[0]["DutyName"].ToString();                       
                        StateName.Text = dt.Rows[0]["StateName"].ToString();
                        OldAreaName.Text = dt.Rows[0]["AreaName"].ToString();

                        defDicBiz.InitSynDropDownList(ComID, dt.Rows[0]["ComName"].ToString());  
                        defDicBiz.InitSynDropDownList(DutyID, dt.Rows[0]["DutyName"].ToString());
                        defDicBiz.InitSynDropDownList(DeptID, dt.Rows[0]["DeptName"].ToString());
                        defDicBiz.InitSynDropDownList(AreaID, dt.Rows[0]["AreaName"].ToString());
                        defDicBiz.InitSynDropDownList(StateID, dt.Rows[0]["StateName"].ToString());
                    }
                    else
                        JSUtility.Alert(this, "不存在该员工编号: " + empCode);
                }
            }
            btnUpdate.Enabled = false;
            btnDelete.Enabled = false;
        }

        protected void btnAdd_Click(object sender, EventArgs e)
        {

            /*
            string empCode = EmpCode.Text.Trim();
            string changeTime = BTime.Text.Trim();
            SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
            sdList.Add("EmpCode", empCode);     
            sdList.Add("NewStateName", StateID.SelectedItem.Text.Trim());           
            sdList.Add("NewDutyName", DutyID.SelectedItem.Text.Trim());
            sdList.Add("NewDeptName", StringUtility.RemoveLeftSpace(DeptID.SelectedItem.Text.Trim()));
            sdList.Add("NewAreaName", AreaID.SelectedItem.Text.Trim());
            sdList.Add("ChangeTime", changeTime);
            sdList.Add("Memo", Memo.Text.Trim());
            sdList.Add("Account", account);
            iBizSQL.Insert("Admin_EmpOtherDuty", sdList);
            */

            if (iBizSQL.Insert("Admin_EmpOtherDuty",this))
            JSUtility.AlertAndRedirect("增加成功", "EmpDutyAdd.aspx");
            else
                JSUtility.Alert(this, "添加失败！");
        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            /*
           
            string empCode = EmpCode.Text.Trim();
            string changeTime = BTime.Text.Trim();
            SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
            sdList.Add("ID", id);
            sdList.Add("EmpCode", empCode);        
            sdList.Add("NewStateName", StateID.SelectedItem.Text.Trim());           
            sdList.Add("NewDutyName", DutyID.SelectedItem.Text.Trim());
            sdList.Add("NewDeptName", StringUtility.RemoveLeftSpace(DeptID.SelectedItem.Text.Trim()));
            sdList.Add("NewAreaName", AreaID.SelectedItem.Text.Trim());
            sdList.Add("ChangeTime", changeTime);
            
            sdList.Add("Memo", Memo.Text.Trim());
            sdList.Add("Account", account);
            iBizSQL.Update("Admin_EmpOtherDuty", sdList);
            */

            if (id != "0")
            {
                if (iBizSQL.Update("Admin_EmpOtherDuty", this))
                JSUtility.Alert(this, "更新成功");
               else
                   JSUtility.Alert(this, "更新失败");
            }
        }

        protected void btnDelete_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpDutyAdd.aspx", RightChar.Del))
            {
                if (!AccountBiz.CheckRight(account, "EmpDutyList.aspx", RightChar.Del))
                {
                    JSUtility.Alert(this, "您没有删除权限！");
                    return;
                }
            }
            if (id != "0")
            {
                if (empDutyBiz.DeleteOneInfo(id))
                    JSUtility.Alert(this, "删除成功");
                else
                    JSUtility.Alert(this, "删除失败");
            }
            else
                JSUtility.Alert(this, "请先选择数据");
        }



        protected void btnClose_Click(object sender, EventArgs e)
        {
            JSUtility.CloseWindow();
        }

        
    }
}