﻿using System;
using System.Collections.Generic;
using System.Data;
using BLL;
using Utils;
namespace UI.ModEmployee
{
    public partial class EmpDutyLowAdd : System.Web.UI.Page
    {
        DefDicBiz defineDictionary = new DefDicBiz();
        DepartmentBiz departmentBiz = new DepartmentBiz();
        DutyBiz dutyBiz = new DutyBiz();
        string id = "0";

        string account = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.Params["ID"] != null)
            {
                id = Request.Params["ID"].ToString();
                btnAdd.Enabled = false;
            }
            else
            {
                btnUpdate.Enabled = false;
                btnDelete.Enabled = false;
                btnDelAll.Enabled = false;
            }
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
            }
            else
            {
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }
            if (!IsPostBack)
            {
                if (id != "0")

                    BindData(id);
                else
                {
                    departmentBiz.InitDropDownList(ddlDeptID, "");
                    defineDictionary.InitDropDownList("Admin_Emp_Duty", ddlDutyID, "");
                }
            }
        }
        private void BindData(string id)
        {
            DataTable dt = defineDictionary.GetOneInfo("Admin_Emp_LowLimit", id);
            if (dt.Rows.Count > 0)
            {
                txtLowLimitNum.Text = dt.Rows[0]["LowLimitNum"].ToString();
                departmentBiz.InitDropDownList(ddlDeptID, dt.Rows[0]["DeptName"].ToString());
                defineDictionary.InitDropDownList("Admin_Emp_Duty", ddlDutyID, dt.Rows[0]["DutyName"].ToString().Trim());
            }
            else
            {
                JSUtility.Alert(this, "无数据");
            }

        }
        protected void btnAdd_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpDutyLowAdd.aspx", RightChar.Add))
            {
                if (!AccountBiz.CheckRight(account, "EmpDutyLowLimit.aspx", RightChar.Add))
                {
                    JSUtility.Alert(this, "无权限！");
                    return;
                }
            }
            try
            {
                string num = txtLowLimitNum.Text.Trim();
                if (!RegexRule.IsInt(num))
                {
                    JSUtility.Alert(this, "请先底限人数中输入整数！");
                    return;
                }
                string deptID = ddlDeptID.SelectedValue;
                string deptName = ddlDeptID.SelectedItem.Text;
                string dutyID = ddlDutyID.SelectedValue;
                string dutyName = ddlDutyID.SelectedItem.Text;
                if (dutyID=="" || dutyID=="0")
                {
                    JSUtility.Alert(this, "请选择部门的职位！");
                    return;

                }
                SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
                sdList.Add("DeptName", deptName);
                sdList.Add("DutyName", dutyName);
                sdList.Add("DeptID", deptID);
                sdList.Add("DutyID", dutyID);
                sdList.Add("LowLimitNum", num);

                defineDictionary.Insert("Admin_Emp_LowLimit", sdList);
               
                JSUtility.Alert(this, "增加成功");
               
            }
            catch
            {
                JSUtility.Alert(this, "增加失败");
            }

        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpDutyLowAdd.aspx", RightChar.Mod))
            {
                if (!AccountBiz.CheckRight(account, "EmpDutyLowLimit.aspx", RightChar.Mod))
                {
                    JSUtility.Alert(this, "无权限！");
                    return;
                }
            }
            //只更新底限人数
            string num = txtLowLimitNum.Text.Trim();
            if (!RegexRule.IsInt(num))
            {
                JSUtility.Alert(this, "请先底限人数中输入整数！");
                return;
            }   

            SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
            sdList.Add("ID", id);
            sdList.Add("LowLimitNum", num);

            string info = "";
            if (defineDictionary.Update("Admin_Emp_LowLimit", sdList))
             info="更新数量成功"; 
            else
                info="更新数量失败";

            JSUtility.Alert(this, info);
           
        }

        protected void btnDel_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpDutyLowAdd.aspx", RightChar.Del))
            {
                if (!AccountBiz.CheckRight(account, "EmpDutyLowLimit.aspx", RightChar.Del))
                {
                    JSUtility.Alert(this, "无权限！");
                    return;
                }
            }
            if (string.IsNullOrWhiteSpace(id))
            {
                JSUtility.Alert(this, "请先选择职位，然后才能删除！");
                return;
            }
            string msg = defineDictionary.Delete("Admin_Emp_LowLimit", new string[] { "ID", id, "N" });
            JSUtility.Alert(this, msg);          
        }

        protected void btnDelAll_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpDutyLowAdd.aspx", RightChar.Del))
            {
                if (!AccountBiz.CheckRight(account, "EmpDutyLowLimit.aspx", RightChar.Del))
                {
                    JSUtility.Alert(this, "无权限！");
                    return;
                }
            }
            string deptID = ddlDeptID.SelectedValue;
            if (string.IsNullOrWhiteSpace(id) || deptID=="0")
            {
                JSUtility.Alert(this, "请先选择部门，然后才能删除！");
                return;
            }
            if (dutyBiz.DelDutyLowLimit(deptID))
            { JSUtility.Alert(this, "成功删除部门下的设定！"); }
            else
            { JSUtility.Alert(this, "删除失败！"); }
        }

        /*
          protected void btnAdd_Click0(object sender, EventArgs e)
        {
            try
            {
                string num = txtLowLimitNum0.Text.Trim();
                if (!RegexRule.IsInt(num))
                {
                    JSUtility.Alert(this, "请先底限人数中输入整数！");
                    return;

                }
                string deptName = txtDeptName.Text.Trim();
                string dutyName = txtDutyName.Text.Trim();
                if (string.IsNullOrWhiteSpace(dutyName))
                {
                    JSUtility.Alert(this, "请选择部门的职位，如果没有职位，请先选择部门！");
                    return;
                }
                //判断职位是否存在
                if (!defineDictionary.IsExistOneInfo("Admin_Emp_Duty", dutyName))
                {
                    JSUtility.Alert(this, "该职位不存在，请在职位管理界面先添加职位!\n（如果改职位被关闭，请先打开）");
                    return;
                }
                if (!departmentBiz.IsExistOneInfo(deptName))
                {
                    JSUtility.Alert(this, "输入的部门名称错误，请输入正确的部门名称！");
                    return;
                }
                SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
                sdList.Add("DeptName", deptName);
                sdList.Add("DutyName", dutyName);
                sdList.Add("LowLimitNum", num);

                defineDictionary.Insert("Admin_Emp_LowLimit", sdList);
                BondData(deptName);
                JSUtility.Alert(this, "增加成功");
            }
            catch
            {
                JSUtility.Alert(this, "增加失败");
            }
        }
         */
       
    }
}