﻿using System;
using System.Web.UI.WebControls;
using BLL;
using Utils;
namespace UI.ModEmployee
{
    public partial class EmpDutyLowLimit : System.Web.UI.Page
    {
        DefDicBiz defineDictionary = new DefDicBiz();
        DepartmentBiz departmentBiz = new DepartmentBiz();
        DutyBiz dutyBiz = new DutyBiz();
        string account = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
            }
            else
            {
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }
            if (!IsPostBack)
            {
                departmentBiz.InitDropDownList(ddlDeptID, "");
                btnAdd.Attributes.Add("onclick", "javascript:ShowLink('EmpDutyLowAdd.aspx',600,480);");
                btnBatchAdd.Attributes.Add("onclick", "javascript:ShowLink('EmpDutyLownBatch.aspx',600,480);");
                BondData("0","");
            }
        }

        private void BondData(string deptID,string dutyName)
        {
            gvList.DataSource = dutyBiz.GetDutyLowLimit(deptID, dutyName);
            gvList.DataBind();
        }






        protected void btnExport_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpDutyLowLimit.aspx", RightChar.Out))
            {
                JSUtility.Alert(this, "无权限！");
                return;
            }
            ExcelUtility.GridViewToExcel(gvList, "EmpLowLimit.xls");
        }





        protected void gvList_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow || e.Row.RowType == DataControlRowType.Header || e.Row.RowType == DataControlRowType.Footer)
            {
                e.Row.Cells[0].Visible = false;
            }
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#F3F8F8'");
                e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c;");
            }

            if (e.Row.RowType == DataControlRowType.Footer)
            {
                    e.Row.Cells[2].Text = "合计";
                    e.Row.Cells[3].Text = Utils.ToolUtility.ReturnTotal(gvList, 4).ToString();
            }
        }







        protected void btnSearch_Click1(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpDutyLowLimit.aspx", RightChar.Ser))
            {
                JSUtility.Alert(this, "无权限！");
                return;
            }
            string dutyName = txtDeptName.Text.Trim();
            string deptID = ddlDeptID.SelectedValue;
            BondData(deptID,dutyName);
        }
    }
}