﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using BLL;
using Utils;

namespace UI.ModEmployee
{
    public partial class EmpDutyLownBatch : System.Web.UI.Page
    {
        DutyBiz dutyBiz = new DutyBiz();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] == null)
            {

                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }
            if (!IsPostBack)
            {
                new DepartmentBiz().InitDropDownList(ddlDeptID, "");
            }
        }



        protected void btnAdd_Click(object sender, EventArgs e)
        {
            try
            {
                string deptID = ddlDeptID.SelectedValue.ToString();
                if (deptID == "0")
                {
                    JSUtility.Alert(this, "请选择部门");
                    return;
                }
                string deptName = ddlDeptID.SelectedItem.Text;

                for (int i = 0; i < gvList.Rows.Count; i++)
                {
                    GridViewRow row = gvList.Rows[i];
                    string dutyID = ((Label)row.Cells[0].FindControl("lbID")).Text;
                    string dutyName = ((Label)row.Cells[0].FindControl("lbDutyName")).Text.Trim();
                    string lowLimit = ((TextBox)row.Cells[0].FindControl("txtLowLimit")).Text.Trim();
                    if (string.IsNullOrWhiteSpace(lowLimit))  continue;

                    dutyBiz.SetDutyLowLimit(deptID, deptName, dutyID, dutyName, "0", lowLimit);
                }
                JSUtility.Alert(this, "执行成功!");
            }
            catch { JSUtility.Alert(this, "执行失败!"); }



        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            //查出该部门所有在职员工的职位
            string deptID = ddlDeptID.SelectedValue.ToString();
            if (deptID == "0")
            {
                JSUtility.Alert(this, "请选择部门");
                return;
            }
            DataTable dt = dutyBiz.GetDutyByDeptID(deptID);
            gvList.DataSource = dt;
            gvList.DataBind();
        }


    }
}