﻿using System;
using System.Data;
using BLL;
using Utils;
namespace UI.ModEmployee
{
    public partial class EmpDutyNotice : System.Web.UI.Page
    {
      EmployeeBiz employeeBiz=  new EmployeeBiz();
      string account = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
            }
            else
            {
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }
            if (!IsPostBack)
            {
                JSUtility.AddReset(btnClear);
                new DepartmentBiz().InitDropDownList(ddlDeptID, "0");
                DataTable dt = employeeBiz.GetLists("", "", "", "", "JoinTime");
                if (dt.Rows.Count > 0)
                {
                    lbAmount.Text = "人数合计:    " + dt.Rows.Count;                   
                    gvList.DataSource = dt;
                    gvList.DataBind();
                }
            }
        }

        protected void btnEmSearch_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpDutyNotice.aspx", RightChar.Ser))
            {
                JSUtility.Alert(this, "您没有查询权限！");
                return;
            }
            string deptID = ddlDeptID.SelectedValue.Trim();
            string bTime = txtBtime.Text.Trim();
            string eTime = txtEtime.Text.Trim();
            string serWord = txtSerWord.Text.Trim();
            string timeType = ddlTimeType.SelectedValue;
            
            if (string.IsNullOrWhiteSpace(serWord) && StringUtility.GetDiffDays(bTime, eTime) > XmlUtility.GetNumFormConfig("daysOfSearch"))
            {
                JSUtility.Alert(this, "查询日期间隔不能大于" + XmlUtility.GetNumFormConfig("daysOfSearch") + "0天！");
                    return;
            }
            DataTable dt = employeeBiz.GetLists(serWord, deptID, bTime, eTime, timeType);
        
            if (dt.Rows.Count > 0)
            {
                lbAmount.Text = "人数合计:    " + dt.Rows.Count;
                //DataRow dr = dt.NewRow();
                //dr[0] = "合计:";
                //dr[1] = dt.Rows.Count;
                //dt.Rows.Add(dr);


                gvList.DataSource = dt;
                gvList.DataBind();
            }
            else
            {
                lbAmount.Text = "";
                JSUtility.Alert(this, "没有符合条件的数据");
            }
        }

        protected void btnClear_Click(object sender, EventArgs e)
        {

        }
        //根据gridview打印
        protected void btnPrint_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpDutyNotice.aspx", RightChar.Print))
            {
                JSUtility.Alert(this, "您没有打印权限！");
                return;
            }
            PrintUtility.Printer("上岗通知书", gvList);
        }
       
        protected void btnExcel_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpDutyNotice.aspx", RightChar.Out))
            {
                JSUtility.Alert(this, "您没有导出权限！");
                return;
            }
            string deptID = ddlDeptID.SelectedValue.Trim();
            string bTime = txtBtime.Text.Trim();
            string eTime = txtEtime.Text.Trim();
            string serWord = txtSerWord.Text.Trim();
            string timeType = ddlTimeType.SelectedValue;
            DataTable dt = employeeBiz.GetLists(serWord, deptID, bTime, eTime, timeType);
            ExcelUtility.ExportDsToXls(this, dt, "DutyNotice.xls");
           // ExcelUtility.GridViewToExcel(gvList, "DutyNotice.xls");
        }
    }
}