﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="EmpList.aspx.cs" Inherits="UI.ModEmployee.EmpList" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>员工档案管理</title>
    <link rel="stylesheet" type="text/css" href="../Styles/BaseStyle.css" />
    <script type="text/javascript" src="../JS/jsFunction.js"></script>
    <script type="text/javascript" src="../JS/calendar.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <table class="pagetop">
        <tr>
            <td>
                <div class="pagetopleft">
                    员工档案管理</div>
            </td>
            <td>
                <div class="pagetopright">
                    工号<asp:TextBox ID="txtSeWord" runat="server" Width="56px" CssClass="InputCss"></asp:TextBox>
                    日期<asp:TextBox ID="txtBtime" runat="server" CssClass="InputCss" Width="69px" MaxLength="10"
                        onclick="setday(this,false)" onkeypress="return validateKey(this,false, getkeyCode(event));"
                        Style="ime-mode: Disabled;"></asp:TextBox>
                    至<asp:TextBox ID="txtEtime" runat="server" CssClass="InputCss" Width="69px" MaxLength="10"
                        onclick="setday(this,false)" onkeypress="return validateKey(this,false, getkeyCode(event));"
                        Style="ime-mode: Disabled;"></asp:TextBox>
                    <asp:DropDownList ID="ddlDeptID" runat="server" CssClass="InputCss">
                    </asp:DropDownList>
                    <asp:DropDownList ID="ddlStateID" runat="server" CssClass="InputCss">
                    </asp:DropDownList>
                    <asp:DropDownList ID="ddlTimeType" runat="server" CssClass="InputCss">
                        <asp:ListItem Value="InputTime">录入时间</asp:ListItem>
                        <asp:ListItem Value="JoinTime">入职时间</asp:ListItem>
                        <asp:ListItem Value="TestEndTime">转正时间</asp:ListItem>
                        <asp:ListItem Value="LeaveTime">离职时间</asp:ListItem>
                        <asp:ListItem Value="Birthday">出生日期</asp:ListItem>
                    </asp:DropDownList>
                    <asp:Button ID="btnEmSearch" runat="server" Width="40px" Text="查询" OnClick="btnEmSearch_Click"
                        CssClass="ButtonCss" />                   
                    <asp:Button ID="btnAdd" runat="server" Text="增加" CssClass="ButtonCss" />
                     <asp:Button ID="btnOut" runat="server" Width="40px" Text="导出" 
                        CssClass="ButtonCss" onclick="btnOut_Click" />  
                </div>
            </td>
        </tr>
    </table>
    <asp:GridView ID="gvList" runat="server" DataKeyNames="EmpCode" Width="1200px" AutoGenerateColumns="False"
        BackColor="White" BorderColor="#E7E7FF" BorderStyle="None" BorderWidth="1px"
        CellPadding="3" GridLines="Horizontal">
        <Columns>
            <asp:BoundField DataField="DeptName" HeaderText="部门名称" SortExpression="DeptName"
                ItemStyle-HorizontalAlign="Center">
                <ItemStyle Width="120px" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="工号" SortExpression="EmpCode" ItemStyle-HorizontalAlign="Center">
                <ItemTemplate>
                    <a href="javascript:ShowLink('EmployeeShowDetail.aspx?EmpCode=<%# Eval("EmpCode")%>',880,610)">
                        <%# Eval("EmpCode") %></a>
                </ItemTemplate>
                <ItemStyle Width="100px" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="员工姓名" SortExpression="EmpName" ItemStyle-HorizontalAlign="Center">
                <ItemTemplate>
                    <a href="javascript:ShowLink('EmployeeShowDetail.aspx?EmpCode=<%# Eval("EmpCode")%>',880,610)">
                        <%# Eval("EmpName")%></a>
                </ItemTemplate>
                <ItemStyle Width="100px" />
            </asp:TemplateField>
            <asp:BoundField DataField="DutyName" HeaderText="职务" SortExpression="DutyName">
                <ItemStyle Width="120px" />
            </asp:BoundField>
            <asp:BoundField DataField="AreaName" HeaderText="区域" SortExpression="AreaName">
                <ItemStyle Width="90px" />
            </asp:BoundField>
            <asp:BoundField DataField="StateName" HeaderText="状态" SortExpression="StateName">
                <ItemStyle Width="80px" />
            </asp:BoundField>
            <asp:BoundField DataField="EmpSex" HeaderText="性别" SortExpression="EmpSex">
                <ItemStyle Width="60px" />
            </asp:BoundField>
            <asp:BoundField DataField="EducationName" HeaderText="学历" SortExpression="EducationName">
                <ItemStyle Width="70px" />
            </asp:BoundField>
            <asp:BoundField DataField="Registry" HeaderText="籍贯" SortExpression="Registry">
                <ItemStyle Width="100px" />
            </asp:BoundField>
            <asp:BoundField DataField="JoinTime" HeaderText="入职时间" DataFormatString="{0:d}" SortExpression="JoinTime">
                <ItemStyle Width="90px" />
            </asp:BoundField>
             <asp:BoundField DataField="LeaveTime" HeaderText="离职时间" DataFormatString="{0:d}" SortExpression="LeaveTime">
                <ItemStyle Width="90px" />
            </asp:BoundField>
            <asp:BoundField DataField="SafetyAmount" HeaderText="保险" SortExpression="SafetyAmount">
                <ItemStyle Width="80px" />
            </asp:BoundField>
            <asp:BoundField DataField="SalaryState" HeaderText="工资状态" SortExpression="SalaryState">
                <ItemStyle Width="80px" />
            </asp:BoundField>
            <asp:BoundField DataField="Remark" HeaderText="标注" SortExpression="Remark">
                <ItemStyle Width="70px" />
            </asp:BoundField>
            <asp:BoundField DataField="WorkGroup" HeaderText="班组" SortExpression="WorkGroup">
                <ItemStyle Width="70px" />
            </asp:BoundField>
            <asp:BoundField DataField="Mobile" HeaderText="手机" SortExpression="Mobile">
                <ItemStyle Width="90px" />
            </asp:BoundField>
        </Columns>
        <FooterStyle BackColor="#B5C7DE" ForeColor="#4A3C8C" />
        <RowStyle BackColor="#E7E7FF" ForeColor="#4A3C8C" />
        <PagerStyle BackColor="#E7E7FF" ForeColor="#4A3C8C" HorizontalAlign="Right" />
        <HeaderStyle BackColor="#4A3C8C" Font-Bold="True" ForeColor="#F7F7F7" />
        <AlternatingRowStyle BackColor="#F7F7F7" />
    </asp:GridView>
    <div id="divAmount" class="amountLine">
        <asp:Label ID="lbAmount" runat="server"></asp:Label>
    </div>
    </form>
</body>
</html>
