﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Text;
using System.Web.UI.WebControls;
using BLL;
using Utils;
namespace UI.ModEmployee
{
    public partial class EmpList : System.Web.UI.Page
    {

        //  static int RowsPerPage = XmlUtility.GetNumFormConfig("numOfEmp");

        string account = "";
        EmployeeBiz employeeBiz = new EmployeeBiz();
       DepartmentBiz departmentBiz= new DepartmentBiz();
        protected void Page_Load(object sender, EventArgs e)
        {

            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
            }
            else
            {
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }

            if (!IsPostBack)
            {
                btnAdd.Attributes.Add("onclick", "javascript:ShowLink('EmpAdd.aspx',850,600);");
                DefDicBiz defDicBiz = new DefDicBiz();
                defDicBiz.InitDropDownList("Admin_Work_State", ddlStateID, "");
                ddlStateID.Items.Add(new ListItem("在职", "10000"));
                departmentBiz.InitDropDownList(ddlDeptID, "0");

            }



        }
        protected void BindGv(string empCode, string bTime, string eTime, string deptID, string stateID, string timeType)
        {
            DataTable dt = employeeBiz.GetLists(empCode, bTime, eTime, deptID, stateID, timeType);
            int r = dt.Rows.Count;
            gvList.DataSource = dt;
            gvList.DataBind();
            if (r > 0)
            {
                lbAmount.Text = "总人数：" + r.ToString();
            }
        }



        protected void btnEmSearch_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpList.aspx", RightChar.Ser))
            {
                JSUtility.Alert(this, "您没有查询员工的权限！");
                return;
            }
            string empCode = txtSeWord.Text.Trim();
            string bTime = txtBtime.Text.Trim();
            string eTime = txtEtime.Text.Trim();
            string deptID = ddlDeptID.SelectedValue.ToString();
            string stateID = ddlStateID.SelectedValue.ToString();
            string timeType = ddlTimeType.SelectedValue;
            if (deptID=="0" &&stateID=="0" && string.IsNullOrEmpty(empCode) && string.IsNullOrEmpty(bTime))
            {
                bTime = System.DateTime.Now.AddMonths(-6).ToString("yyyy-MM-dd");
                txtBtime.Text = bTime;
                txtEtime.Text = System.DateTime.Now.ToString("yyyy-MM-dd");
            }
            BindGv(empCode, bTime, eTime, deptID, stateID, timeType);

        }

        protected void btnOut_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpList.aspx", RightChar.Out))
            {
                JSUtility.Alert(this, "您没有导出员工的权限！");
                return;
            }
            string empCode = txtSeWord.Text.Trim();
            string bTime = txtBtime.Text.Trim();
            string eTime = txtEtime.Text.Trim();
            string deptID = ddlDeptID.SelectedValue.ToString();
            string stateID = ddlStateID.SelectedValue.ToString();
            string timeType = ddlTimeType.SelectedValue;
            if (deptID == "0" && stateID == "0" && string.IsNullOrEmpty(empCode) && string.IsNullOrEmpty(bTime))
            {
                bTime = System.DateTime.Now.AddMonths(-6).ToString("yyyy-MM-dd");
                txtBtime.Text = bTime;
                txtEtime.Text = System.DateTime.Now.ToString("yyyy-MM-dd");
            }
            DataTable dt = employeeBiz.GetOutLists(empCode, bTime, eTime, deptID, stateID, timeType);
            if (dt.Rows.Count > 0)
                ExcelUtility.ExportDsToXls(this, dt, "Employee.xls");
            else
                JSUtility.Alert(this, "无数据！");

        }


    }
}