﻿using System;
using System.Data;
using BLL;
using Utils;
namespace UI.ModEmployee
{
    public partial class EmpListMutil : System.Web.UI.Page
    {
        string account = "";
        EmployeeBiz employeeBiz = new EmployeeBiz();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
            }
            else
            {
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }
        }

        protected void btnEmSearch_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpListMutil.aspx", RightChar.Ser))
            {
                JSUtility.Alert(this, "无权限！");
                return;
            }
            string empCode = txtCode.Text.Trim();
            string empName = txtName.Text.Trim();
            string empDept = txtDept.Text.Trim();
            string empDuty = txtDuty.Text.Trim();
            string empArea = txtArea.Text.Trim();
            if (empCode == "" && empName == "" && empDept == "" && empDuty == "" && empArea == "")
            {
                return;
            }
            ShowEmployeeDetail(empCode, empName, empDept, empDuty, empArea);
        }
        //显示客户详细信息
        protected void ShowEmployeeDetail(string empCode, string empName, string empDept, string empDuty, string empArea)
        {

            DataTable dt = employeeBiz.GetOneInfo(empCode, empName, empDept, empDuty, empArea);
            try
            {
                if (dt.Rows.Count == 1)
                {
                    string code = dt.Rows[0]["EmpCode"].ToString();
                    txtEmpCode.Text = code;
                    txtEmpName.Text = dt.Rows[0]["EmpName"].ToString();
                    ddlEmpSex.Text = dt.Rows[0]["EmpSex"].ToString();

                    ddlDeptID.Text = dt.Rows[0]["DeptName"].ToString();
                    ddlDutyID.Text = dt.Rows[0]["DutyName"].ToString();
                    ddlAreaID.Text = dt.Rows[0]["AreaName"].ToString();

                    txtWorkGroup.Text = dt.Rows[0]["WorkGroup"].ToString();
                    ddlStateID.Text = dt.Rows[0]["StateName"].ToString();
                    txtSafetyAmount.Text = dt.Rows[0]["SafetyAmount"].ToString();

                    txtNationality.Text = dt.Rows[0]["Nationality"].ToString();
                    ddlIsMarry.Text = dt.Rows[0]["IsMarry"].ToString();

                    string birthday = dt.Rows[0]["Birthday"].ToString();
                    if (Utils.RegexRule.IsDate(birthday))
                        txtBirthday.Text = Convert.ToDateTime(birthday).ToString("yyyy-MM-dd");

                    txtZipCode.Text = dt.Rows[0]["ZipCode"].ToString();
                    txtHomeTel.Text = dt.Rows[0]["HomeTel"].ToString();

                    ddlSalaryState.Text = dt.Rows[0]["SalaryState"].ToString();
                    lbSalaryAccount.Text = dt.Rows[0]["SalaryAccount"].ToString();

                    string leaveTime = dt.Rows[0]["LeaveTime"].ToString();
                    if (Utils.RegexRule.IsDate(leaveTime))
                        lbLeaveTime.Text = Convert.ToDateTime(leaveTime).ToString("yyyy-MM-dd");
                    txtMobile.Text = dt.Rows[0]["Mobile"].ToString();


                    txtRegistry.Text = dt.Rows[0]["Registry"].ToString();//籍贯


                    ddlEducationID.Text = dt.Rows[0]["EducationName"].ToString();


                    txtAddr.Text = dt.Rows[0]["Addr"].ToString();



                    string joinTime = dt.Rows[0]["JoinTime"].ToString();
                    if (Utils.RegexRule.IsDate(joinTime))
                        txtJoinTime.Text = Convert.ToDateTime(joinTime).ToString("yyyy-MM-dd");

                    txtTestTimeLong.Text = dt.Rows[0]["TestTimeLong"].ToString();
                    ddlIsCheck.Text = dt.Rows[0]["IsCheck"].ToString();

                    txtComputerLevel.Text = dt.Rows[0]["ComputerLevel"].ToString();

                    ddlHrFrom.Text = dt.Rows[0]["HrFrom"].ToString();
                    ddlVehicle.Text = dt.Rows[0]["Vehicle"].ToString();
                    txtNowAddr.Text = dt.Rows[0]["NowAddr"].ToString();
                    txtWishWorkAddr.Text = dt.Rows[0]["WishWorkAddr"].ToString();
                    txtSpecialRelation.Text = dt.Rows[0]["SpecialRelation"].ToString();
                    txtSpecialLinkWay.Text = dt.Rows[0]["SpecialLinkWay"].ToString();
                    txtSpecialLinkMan.Text = dt.Rows[0]["SpecialLinkMan"].ToString();

                    txtLearnExperience.Text = dt.Rows[0]["LearnExperience"].ToString();
                    txtJobExperience.Text = dt.Rows[0]["JobExperience"].ToString();
                    txtFamilyMember.Text = dt.Rows[0]["FamilyMember"].ToString();

                    txtMemo.Text = dt.Rows[0]["Memo"].ToString();

                    //显示其它明细
                    ShowChangeList(code);
                    ShowRewardsList(code);
                }
                else
                {
                    Response.Write(@"<script language='javascript'>alert('无数据！');</script>");
                    return;
                }

            }
            catch (Exception ee)
            {
                throw new Exception(ee.Message);
            }

        }
        private void ShowChangeList(string code)
        {
            EmpChangeBiz empChangeBiz = new EmpChangeBiz();
            DataTable dt = empChangeBiz.GetLists(code, "", "", "","");
            if (dt.Rows.Count > 0)
            {
                gvChange.Caption = "职位变动";
                gvChange.DataSource = dt;
                gvChange.DataBind();
            }
        }
        private void ShowRewardsList(string code)
        {
            DataTable dt = new EmpRewardsBiz().GetLists("", code, "", "", "");
            if (dt.Rows.Count > 0)
            {
                gvRewards.Caption = "奖惩信息";
                gvRewards.DataSource = dt;
                gvRewards.DataBind();
            }
        }
        // private void  ShowTrainList(string code)
        //{
        //    TrainBiz trainBiz = new TrainBiz();
        //    DataTable dt = trainBiz.GetLists(code, "", "", "");
   
        //     if (dt.Rows.Count > 0)
        //    {
        //        gvTrain.Caption = "培训信息";
        //    gvTrain.DataSource = dt;
        //    gvTrain.DataBind();
        //     }
        // }
         private void ShowPassedList(string code)
         {
             DataTable dt = new EmpPassedBiz().GetLists(code, "", "", "", "");
             if (dt.Rows.Count > 0)
             {
                 gvPassed.Caption = "转正信息";
                 gvPassed.DataSource = dt;
                 gvPassed.DataBind();
             }
         }
        protected void btnClear_Click(object sender, EventArgs e)
        {
            txtCode.Text = "";
            txtName.Text = "";
            txtDept.Text = "";
            txtDuty.Text = "";
            txtArea.Text = "";
        }

    }
}