﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using BLL;
using Utils;
//修改工号
namespace UI.ModEmployee
{
    public partial class EmpMidifyCode : System.Web.UI.Page
    {
        string account = "";
        EmployeeBiz employeeBiz = new EmployeeBiz();
        DepartmentBiz departmentBiz = new DepartmentBiz();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
            }
            else
            {
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }
            if (!IsPostBack)
            {
                departmentBiz.InitDropDownList(ddlOldDeptID, "");
                departmentBiz.InitDropDownList(ddlNewDeptID, "");
            }
        }

        protected void btnModi_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpMidifyCode.aspx", RightChar.Mod))
            {
                JSUtility.Alert(this, "无权限！");
                return;
            }
            string oldCode = txtOldCode.Text.Trim();
            string newCode = txtNewCode.Text.Trim();
            string codeType=string.Empty;
            if (rbEmp.Checked == true) codeType = "emp";
            else codeType = "sal";
            if (!employeeBiz.IsExistEmpCode(oldCode))
            {
                JSUtility.Alert(this, "旧工号没有被使用，无法修改！");
                return;
            }
            if (employeeBiz.IsExistEmpCode(newCode))
            {
                JSUtility.Alert(this, "新工号已经被使用，无法修改！");
                return;
            }
            if (employeeBiz.ModiEmpCode(oldCode, newCode, codeType))
            { JSUtility.Alert(this, "修改成功！"); }
            else
            { JSUtility.Alert(this, "修改失败！"); }

        }

        protected void txtOldCode_TextChanged(object sender, EventArgs e)
        {
            string oldCode = txtOldCode.Text.Trim();

               DataTable dt= employeeBiz.GetOneInfo(oldCode);
               if (dt.Rows.Count > 0)
               {
                   lbContent.Text = "姓名：" + dt.Rows[0]["EmpName"].ToString() + "  &nbsp;&nbsp;部门：" + dt.Rows[0]["DeptName"].ToString() + "  &nbsp;&nbsp;职位：" + dt.Rows[0]["DutyName"].ToString();
               }
           
        }

        protected void btnMove_Click(object sender, EventArgs e)
        {
            if (!AccountBiz.CheckRight(account, "EmpMidifyCode.aspx", RightChar.Mod))
            {
                JSUtility.Alert(this, "无权限！");
                return;
            }
            if (ddlOldDeptID.SelectedValue == "0" || ddlNewDeptID.SelectedValue=="0")
            {return;}
            if (employeeBiz.ChangeDept(ddlOldDeptID.SelectedValue, ddlNewDeptID.SelectedValue))
              JSUtility.Alert(this, "修改成功！");
            else
                JSUtility.Alert(this, "修改错误！");
        }
    }
}