﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Web.UI;
using BLL;
using Utils;
public partial class ModEmployee_EmployeeDetail : System.Web.UI.Page
{
    EmployeeBiz employeeBiz = new EmployeeBiz();
    EmpLeaveBiz empLeaveBiz = new EmpLeaveBiz();
    string empCode = "";
    string account = "";

    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["user"] != null)
        {
            User user = Session["user"] as User;
            account = user.Account;
          // isSpec= user.IsSpecial;
        }
        else
        {
            JSUtility.Alert(this, "您没有登录!请先登录。");
            return;
        }
        if (Request.QueryString["EmpCode"] != null)
        {

            empCode = Request.QueryString["EmpCode"].ToString();
        }
        else
        {
            Response.Write(@"<script language='javascript'>alert('参数不能为空！');</script>");
            return;
        }
        if (!Page.IsPostBack)
        {
            if (empCode != "")
            {
                ShowEmployeeDetail(empCode);
            }
        }
    }
    //显示客户详细信息
    protected void ShowEmployeeDetail(string empCode)
    {
        DataTable dt = employeeBiz.GetOneInfo(empCode);
        try
        {
            if (dt.Rows.Count == 1)
            {

                txtEmpCode.Text = dt.Rows[0]["EmpCode"].ToString();
                txtEmpName.Text = dt.Rows[0]["EmpName"].ToString();
                ddlEmpSex.Text = dt.Rows[0]["EmpSex"].ToString();

                ddlDeptID.Text = dt.Rows[0]["DeptName"].ToString();
                ddlDutyID.Text = dt.Rows[0]["DutyName"].ToString();
                ddlAreaID.Text = dt.Rows[0]["AreaName"].ToString();

                txtWorkGroup.Text = dt.Rows[0]["WorkGroup"].ToString();
                ddlStateID.Text = dt.Rows[0]["StateName"].ToString();
                txtSafetyAmount.Text = dt.Rows[0]["SafetyAmount"].ToString();

                txtNationality.Text = dt.Rows[0]["Nationality"].ToString();
                ddlIsMarry.Text = dt.Rows[0]["IsMarry"].ToString();

                string birthday = dt.Rows[0]["Birthday"].ToString();
                if (Utils.RegexRule.IsDate(birthday))
                    txtBirthday.Text = Convert.ToDateTime(birthday).ToString("yyyy-MM-dd");

                txtZipCode.Text = dt.Rows[0]["ZipCode"].ToString();
                txtHomeTel.Text = dt.Rows[0]["HomeTel"].ToString();

                ddlSalaryState.Text = dt.Rows[0]["SalaryState"].ToString();
                txtSalaryAmount.Text = dt.Rows[0]["SalaryAccount"].ToString();
                txtMobile.Text = dt.Rows[0]["Mobile"].ToString();


                txtRegistry.Text = dt.Rows[0]["Registry"].ToString();//籍贯


                ddlEducationID.Text = dt.Rows[0]["EducationName"].ToString();


                txtAddr.Text = dt.Rows[0]["Addr"].ToString();



                string joinTime = dt.Rows[0]["JoinTime"].ToString();
                if (Utils.RegexRule.IsDate(joinTime))
                    txtJoinTime.Text = Convert.ToDateTime(joinTime).ToString("yyyy-MM-dd");

                txtTestTimeLong.Text = dt.Rows[0]["TestTimeLong"].ToString();
                ddlIsCheck.Text = dt.Rows[0]["IsCheck"].ToString();

                txtComputerLevel.Text = dt.Rows[0]["ComputerLevel"].ToString();

                ddlHrFrom.Text = dt.Rows[0]["HrFrom"].ToString();
                ddlVehicle.Text = dt.Rows[0]["Vehicle"].ToString();
                txtNowAddr.Text = dt.Rows[0]["NowAddr"].ToString();
                txtWishWorkAddr.Text = dt.Rows[0]["WishWorkAddr"].ToString();
                txtSpecialRelation.Text = dt.Rows[0]["SpecialRelation"].ToString();
                txtSpecialLinkWay.Text = dt.Rows[0]["SpecialLinkWay"].ToString();
                txtSpecialLinkMan.Text = dt.Rows[0]["SpecialLinkMan"].ToString();

                txtLearnExperience.Text = dt.Rows[0]["LearnExperience"].ToString();
                txtJobExperience.Text = dt.Rows[0]["JobExperience"].ToString();
                txtFamilyMember.Text = dt.Rows[0]["FamilyMember"].ToString();

                txtMemo.Text = dt.Rows[0]["Memo"].ToString();
            }
            else
            {
                Response.Write(@"<script language='javascript'>alert('无数据！');</script>");
                return;
            }

        }
        catch (Exception ee)
        {
            throw new Exception(ee.Message);
        }

    }

    //进入到修改的页面
    protected void lbtnModify_Click(object sender, EventArgs e)
    {
        Response.Redirect("EmpAdd.aspx?EmpCode=" + empCode);
    }



    //删除员工的基本信息
    protected void lbtnDelete_Click(object sender, EventArgs e)
    {
        if (AccountBiz.GetRange(account, "EmpList.aspx") != RangeChar.Super)
        {
            JSUtility.Alert(this, "无权限！");
            return;
        }
        if (!AccountBiz.CheckRight(account, "EmpAdd.aspx", RightChar.Del))
        {
            if (!AccountBiz.CheckRight(account, "EmpList.aspx", RightChar.Del))
            {
                JSUtility.Alert(this, "无权限！");
                return;
            }
        }

        //如果存在该雇员的其它任何信息，则无法删除
        try
        {
            if (employeeBiz.DeleteOneInfo(empCode))
                Response.Write(@"<script language='javascript'>alert('删除成功！');</script>");
            else
                Response.Write(@"<script language='javascript'>alert('删除失败！');</script>");
        }
        catch
        {
            Response.Write("不能删除，因为存在关联数据！请联系管理员进行操作。");
        }
    }

    protected void linkPassed_Click(object sender, EventArgs e)
    {
        Response.Redirect("EmpPassedAdd.aspx?EmpCode=" + empCode);
    }

    protected void linkLeave_Click(object sender, EventArgs e)
    {
        Response.Redirect("EmpLeaveAdd.aspx?EmpCode=" + empCode);
    }

    protected void linkChange_Click(object sender, EventArgs e)
    {
        Response.Redirect("EmpChangeAdd.aspx?EmpCode=" + empCode);
    }

    protected void linkRewards_Click(object sender, EventArgs e)
    {
        Response.Redirect("EmpRewardsAdd.aspx?EmpCode=" + empCode);
    }
    /*
    //改方法取的时间为当天时间，如果不是当天时间，请到该员工离职信息中进行返聘操作。
    //返聘
    protected void lbtnBack_Click(object sender, EventArgs e)
    {
        if (!AccountBiz.CheckRight(account, "EmpAdd.aspx", RightChar.Mod))
        {
            if (!AccountBiz.CheckRight(account, "EmpList.aspx", RightChar.Mod))
            {
                JSUtility.Alert(this, "无权限！");
                return;
            }
        }
        try
        {
            //应该弹出窗口修改
            SortedDictionary<string, string> hList = new SortedDictionary<string, string>();
            hList.Add("EmpCode", empCode);

            hList.Add("StateID", "1");//字典中的ID
            hList.Add("JoinTime", System.DateTime.Now.ToString("yyyy-MM-dd"));//入职时间
            hList.Add("LeaveTime", "null");//离职时间XmlUtility.GetWebParam("DateOfLeaveTime")
            hList.Add("ReMark", System.DateTime.Now.ToString("yyyy-MM-dd") + "返聘");
            if (employeeBiz.Update("Admin_Employee", hList))
            {
               
                empLeaveBiz.Update(empCode); //把离职信息的状态修改为N
                JSUtility.AlertAndRedirect("返聘成功，员工基本信息也已经改变为正式状态", "EmployeeDetail.aspx?EmpCode=" + empCode);
            }
            else
                JSUtility.Alert(this, "返聘失败");

        }
        catch (Exception ee)
        {
            JSUtility.Alert(this, ee.Message);
        }
    }
    //改方法取的时间为当天时间，如果不是当天时间，请到该员工离职信息中(请长假那条信息)进行复职操作。
    //复职
    protected void lbtnRe_Click(object sender, EventArgs e)
    {
        if (!AccountBiz.CheckRight(account, "EmpAdd.aspx", RightChar.Mod))
        {
            if (!AccountBiz.CheckRight(account, "EmpList.aspx", RightChar.Mod))
            {
                JSUtility.Alert(this, "无权限！");
                return;
            }
        }
        try
        {
            SortedDictionary<string, string> hList = new SortedDictionary<string, string>();
            hList.Add("EmpCode", txtEmpCode.Text.Trim());
            //不更改入职日期
            hList.Add("StateID", "1");//字典中的ID
            hList.Add("LeaveTime", "null");//XmlUtility.GetWebParam("DateOfLeaveTime")
            hList.Add("ReMark", System.DateTime.Now.ToString("yyyy-MM-dd") + "复职");
            if (employeeBiz.Update("Admin_Employee", hList))
            {
                empLeaveBiz.Update(empCode); //把离职信息的状态修改为N
                JSUtility.Alert(this, "更新复职信息成功");
            }
            else
                JSUtility.Alert(this, "更新复职信息失败");
        }
        catch (Exception ee)
        {
            JSUtility.Alert(this, ee.Message);
        }
    }
    */


    protected void lbtnModi_Click(object sender, EventArgs e)
    {
        Response.Redirect("BankAccountModi.aspx?EmpCode=" + empCode);       
    }

    protected void lbtnReIn_Click(object sender, EventArgs e)
    {
        Response.Redirect("EmpReInAdd.aspx?EmpCode=" + empCode);
    }



    //
}
