﻿using System;
using System.Data;
using BLL;
using Utils;
namespace UI.ModSystem
{
    public partial class DefCodeConfAdd : System.Web.UI.Page
    {
        CodeConfigBiz codeConfigBiz = new CodeConfigBiz();
        DefDicBiz defDicBiz = new DefDicBiz();
        IBizSQL iBizSQL = new BizSQL();
        CheckRight checkRight = new CheckRight();
        string id = "0";//By Update
        string account = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
            }
            else
            {
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }
            if (Request.Params["CodeID"] != null)
            {
                id = Request.Params["CodeID"].ToString();
                btnAdd.Enabled = false;
            }
            else
            {
                btnUpdate.Enabled = false;
                btnDelete.Enabled = false;
            }

            if (!IsPostBack)
            {
                if (id != "0")
                    BindData(id);         
                JSUtility.AddConfirm(btnDelete, "您真的要删除该信息吗？");

            }
        }
        private void BindData(string id)
        {
            DataTable dt = codeConfigBiz.GetOneInfo(Int32.Parse(id));
            if (dt.Rows.Count > 0)
            {

                CodeName.Text = dt.Rows[0]["CodeName"].ToString();
                CodeID.Value = id;
                PreStr.Text = dt.Rows[0]["PreStr"].ToString();
                defDicBiz.InitDropDownList(FirObj, dt.Rows[0]["FirObj"].ToString());
                defDicBiz.InitDropDownList(HavYear, dt.Rows[0]["HavYear"].ToString());
                defDicBiz.InitDropDownList(HavMonth, dt.Rows[0]["HavMonth"].ToString());
                defDicBiz.InitDropDownList(HavDay, dt.Rows[0]["HavDay"].ToString());
                defDicBiz.InitDropDownList(FlowBitNum, dt.Rows[0]["FlowBitNum"].ToString());
                LastStr.Text = dt.Rows[0]["LastStr"].ToString();             
                Memo.Text = dt.Rows[0]["Memo"].ToString();

            }
            else
            {
                JSUtility.Alert(this, "无数据");
            }

        }
        protected void btnAdd_Click(object sender, EventArgs e)
        {
            if (!checkRight.CheckUrl(RightChar.Add)) {
                JSUtility.Alert(this, "无增加权限");
                return;
            }

            if (iBizSQL.Insert("Sys_CodeConfig", this))
                JSUtility.AlertAndRedirect("增加成功", "DefCodeConfAdd.aspx");
            else
                JSUtility.Alert(this, "添加失败！");
          
        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            if (!checkRight.CheckUrl(RightChar.Mod))
            {
                JSUtility.Alert(this, "无更新权限");
                return;
            }
            if (id != "0")
            {
                if (iBizSQL.Update("Sys_CodeConfig", this))
                    JSUtility.Alert(this, "更新成功");
                else
                    JSUtility.Alert(this, "更新失败");
            }
        }

        protected void btnDelete_Click(object sender, EventArgs e)
        {
            if (!checkRight.CheckUrl(RightChar.Del))
            {
                JSUtility.Alert(this, "无删除权限");
                return;
            }
            JSUtility.Alert(this,iBizSQL.Delete("Sys_CodeConfig", new string[] { "CodeID", id, "N" }));
        }
    }
}