﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using BLL;
using Utils;
namespace UI.ModSystem
{
    public partial class DefCodeConfList : System.Web.UI.Page
    {
        CheckRight checkRight = new CheckRight();
        CodeConfigBiz codeConfigBiz = new CodeConfigBiz();
        string account = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
            }
            else
            {
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }
            if (!IsPostBack)
            {
                btnAdd.Attributes.Add("onclick", "javascript:ShowLink('DefCodeConfAdd.aspx',850,600);");
              BindData("");
            }
        }
        private void   BindData(string serWord)
        {
            DataTable dt = codeConfigBiz.GetLists(serWord);
            if (dt.Rows.Count > 0)
            {
                lbAmount.Text = "合计:    " + dt.Rows.Count;
            }
            else
            {
                lbAmount.Text = "";
            }
            gvList.DataSource = dt;
            gvList.DataBind();
        }
        protected void btnEmSearch_Click(object sender, EventArgs e)
        {
            if (!checkRight.CheckUrl(RightChar.Ser))
            {
                JSUtility.Alert(this, "无增加权限");
                return;
            }
            BindData(txtSerWord.Text.Trim());
        }

        protected void btnExcel_Click(object sender, EventArgs e)
        {
            if (!checkRight.CheckUrl(RightChar.Out))
            {
                JSUtility.Alert(this, "无增加权限");
                return;
            }
            ExcelUtility.ExportDsToXls(this, codeConfigBiz.GetLists(txtSerWord.Text.Trim()), "CodeConflist.xls");
        }
    }
}