﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using BLL;
using Utils;
namespace UI.ModSystem
{
    public partial class GroupList : System.Web.UI.Page
    {
        GroupBiz groupBiz = new GroupBiz();
        string account = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
            }
            else
            {
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }
            if (!IsPostBack)
            {
               // btnAdd.Attributes.Add("onclick", "javascript:ShowLink('CredentialAdd.aspx',800,550);");
                BondData("");

            }
        }
        private void BondData(string serWord)
        {
            DataTable dt = groupBiz.GetGroupLists(account,"",serWord);

            if (dt.Rows.Count > 0)
            {
                lbAmount.Text = "合计:    " + dt.Rows.Count;
            }
            else
            {
                lbAmount.Text = "";
            }
            gvList.DataSource = dt;
            gvList.DataBind();

        }

        protected void btnExcel_Click(object sender, EventArgs e)
        {
            ExcelUtility.ExportDsToXls(this, groupBiz.GetGroupLists(account,"",txtSerWord.Text.Trim()),"Glist.xls");
        }

        protected void btnEmSearch_Click(object sender, EventArgs e)
        {
            BondData(txtSerWord.Text.Trim());
        }

        protected void gvList_RowDataBound(object sender, GridViewRowEventArgs e)
        {

        }

        protected void btnAdd_Click(object sender, EventArgs e)
        {
            string gName = txtGName.Text.Trim();
            string gProfile = txtGProfile.Text.Trim();
            string gType = txtGType.Text.Trim();
            string account = txtAccount.Text.Trim();
           
            if (string.IsNullOrWhiteSpace(gName))
            {
                JSUtility.Alert(this, "组名必须输入");
                return;
            }
            
            SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
            sdList.Add("GName", gName);
            sdList.Add("GProfile", gProfile);
            sdList.Add("GType", gType);
            sdList.Add("Account", account);

            if (groupBiz.Insert("Sys_Group", sdList))
            {
                BondData("");
                JSUtility.Alert(this, "增加成功");
            }
            else
                JSUtility.Alert(this, "增加失败");
        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            string groupID = hidGroupID.Value;
            string gName = txtGName.Text.Trim();
            string gProfile = txtGProfile.Text.Trim();
            string gType = txtGType.Text.Trim();
            string account = txtAccount.Text.Trim();
            if (string.IsNullOrWhiteSpace(groupID))
            {
                JSUtility.Alert(this, "请先选择记录");
                return;
            }
            if (string.IsNullOrWhiteSpace(gName))
            {
                JSUtility.Alert(this, "组名必须输入");
                return;
            }

            SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
            sdList.Add("GroupID", groupID);
            sdList.Add("GName", gName);
            sdList.Add("GProfile", gProfile);
            sdList.Add("GType", gType);
            sdList.Add("Account", account);

            if (groupBiz.Update("Sys_Group", sdList))
            {
                BondData("");
                JSUtility.Alert(this, "修改成功");
            }
            else
                JSUtility.Alert(this, "修改失败");
        }

        protected void btnDelete_Click(object sender, EventArgs e)
        {
            string groupID = hidGroupID.Value;           
            if (string.IsNullOrWhiteSpace(groupID))
            {
                JSUtility.Alert(this, "请先选择记录");
                return;
            }//new string[] { "", "N" };
            string msg=groupBiz.Delete("Sys_Group", new string[] { "GroupID", groupID,"N" });
           
                BondData("");
                JSUtility.Alert(this,msg);           
        }

     
    }
}