﻿using System;
using System.Data;
using System.Text;
using BLL;
using Utils;
namespace UI
{
    public partial class EntryLeft : System.Web.UI.Page
    {       
        MenuBiz menuBiz = new MenuBiz();
        IBizSQL bizSQL = new BizSQL();
        string account = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
            }
            else
            {
                Response.Write("1111：登录错误!!!!!请重新登录。");
                return;
            }
            if (!IsPostBack)
            {
                Create_Account_MainMenu_TreeView();
            }
        }
        private void Create_Account_MainMenu_TreeView()
        {

            string strAccount = account;
              
            DataSet ds = new DataSet();
            //取出菜单数据
            if (Enum.IsDefined(typeof(RootUser), strAccount))          
                ds = bizSQL.ExecSQL2("select MainMenuID,ParentID,MenuName,linkUrl from Sys_MainMenu  order by AbsIndex DESC");
            else        
                ds = menuBiz.GetAccountMenu(strAccount);  //菜单要 account_menu + role_menu                   
          
            if (ds == null)
            {
                //弹出提示窗口
                Response.Write("<script>window.alert('数据库里面没有记录！')</script>");
                return;
            }
            else
            {
                this.ViewState["ds"] = ds;
                StringBuilder sb = Addtree(0);
                Literal1.Text = sb.ToString();
            }
        }

        //new 递归添加树的节点
        private StringBuilder Addtree(int ParentID)
        {
            DataSet ds = (DataSet)this.ViewState["ds"];
            DataView dvTree = new DataView(ds.Tables[0]);
            //过滤ParentID,得到当前的所有子节点
            dvTree.RowFilter = "[ParentID] = " + ParentID;

            StringBuilder strb = new StringBuilder();
            strb.Append("<div id=\"menuContainer\">");
            int i = 1;
            foreach (DataRowView Row in dvTree)
            {
                if (ParentID == 0)
                {  //添加根节点
                    string url = Row["linkUrl"].ToString();
                    strb.Append(" <dl>");
                    strb.Append("<dt  onclick=switchtab(this,document.all.contenttab" + i.ToString() + ")>");
                    if (url.Length > 7)
                        strb.Append("<div><img src=\"../Images/index/biao.gif\"><a  href=" + Row["linkUrl"].ToString().Replace("~", "..") + " target=\"ifrmMain\" >" + Row["MenuName"].ToString() + "</a></div>");
                    else
                        strb.Append("<div><img src=\"../Images/index/biao.gif\">" + Row["MenuName"].ToString() + "</div>");
                   
                   // 
                    strb.Append("</dt><dd id=contenttab" + i.ToString() + " style=\"display: none\"> ");
                    strb.Append("<ul>");

                    strb.Append(AddSubTree(Int32.Parse(Row["MainMenuID"].ToString())));

                    strb.Append("</ul></dd></dl>");

                }
                i++;
            }
            strb.Append("</div>");
            return strb;
        }
        private StringBuilder AddSubTree(int SubID)
        {
            DataSet ds = (DataSet)this.ViewState["ds"];
            DataView dvTree = new DataView(ds.Tables[0]);
            //过滤ParentID,得到当前的所有子节点
            dvTree.RowFilter = "[ParentID] = " + SubID;

            StringBuilder strb = new StringBuilder();

            foreach (DataRowView Row in dvTree)
            {
                string url = Row["linkUrl"].ToString();

                if (url.Length > 7)
                    strb.Append("<li class=\"myli\"><a  href=" + url.Replace("~","..") + " target=\"ifrmMain\" >" + Row["MenuName"].ToString() + "</a></li>");
            }
            return strb;
        }
    }
}
