﻿using System;
using System.Data;
using System.Data.SqlClient;
using BLL;
using Utils;

namespace UI
{
    public partial class EntryTop : System.Web.UI.Page
    {
        AccountBiz accountBiz = new AccountBiz();
        DepartmentBiz departmentBiz = new DepartmentBiz();
        int iSessionCompanyID = 0;
        int iSessionDepartmentID = 0;
        string account = "";
        protected void Page_Init(object sender, EventArgs e)
        {
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                iSessionCompanyID = user.CompanyID;
                iSessionDepartmentID = user.DepartemntID;
                account = user.Account;
            }
            else
            {
                return;
            }
        }
        protected void Page_Load(object sender, EventArgs e)
        {


            if (!IsPostBack)
            {

                //显示公司，部门，姓名，帐号等信息
                ShowBaseInfo();
            }
        }


        private void ShowBaseInfo()
        {
            lbAccount.Text = account;
            lbSoftCnName.Text = XmlUtility.getSMSKey("ComCnName");
            if (Enum.IsDefined(typeof(RootUser), account))
            { lbEmpName.Text = account; }
            else
            {
                DataTable dt = accountBiz.GetOneInfo(account);
                if (dt.Rows.Count > 0)
                {
                    lbEmpName.Text = dt.Rows[0]["EmpName"].ToString();
                }
            }

            if (iSessionCompanyID == 0)
            { lbCompanyName.Text = "超级"; }
            else
            {
                DataTable dt2 = departmentBiz.GetLists("Select Name from Admin_Department Where DeptID=" + iSessionCompanyID);

                if (dt2.Rows.Count > 0)
                { lbCompanyName.Text = dt2.Rows[0]["Name"].ToString(); }
            }

            if (iSessionDepartmentID == 0)
            { lbDepartmentName.Text = "超级"; }
            else
            {
                DataTable dt3 = departmentBiz.GetLists("Select Name from Admin_Department Where DeptID=" + iSessionDepartmentID);

                if (dt3.Rows.Count > 0)
                { lbDepartmentName.Text = dt3.Rows[0]["Name"].ToString(); }
            }

        }

    }
}
