﻿using System;
using System.Collections.Generic;
using System.Web.UI.WebControls;
using BLL;
using Utils;
namespace UI.UC
{
    public partial class DefineDictionary : System.Web.UI.Page
    {
        DefDicBiz defineDictionary = new DefDicBiz();
        string tableName = "";
        protected void Page_Load(object sender, EventArgs e)
        {

            if (Request.QueryString["TableName"] != null)
            {
                tableName = Request.QueryString["TableName"];
            }
            if (Session["user"] == null)
            {
                //弹出提示窗口
                //  Response.Write("<script>window.alert('您没有登陆！,建议登录之后再操作！') </script>");
                //  Response.End();
            }
            if (!IsPostBack)
            {

                if (tableName != "") BindData(tableName, "Y");
            }
        }
        private void BindData(string tableName, string statu)
        {

            gvList.DataSource = new DefDicBiz().GetLists(tableName, statu);
            gvList.DataKeyNames = new string[] { "ID" };
            gvList.DataBind();
        }
        protected void btnAdd_Click(object sender, EventArgs e)
        {

            string name = txtName.Text.Trim();
            if (defineDictionary.IsExistOneInfo(tableName, name))
            {
                JSUtility.Alert(this, "名称已经使用，请输入新名称！（如果该名称被关闭，你可以打开它）");
                return;
            }
            string memo = txtMemo.Text.Trim();
            string absIndex = txtAbsIndex.Text.Trim();//
            if (!Utils.RegexRule.IsInt(absIndex))
            {
                JSUtility.Alert(this, "索引一定要填写数字！");
                return;
            }
            if (name == "")
            {
                JSUtility.Alert(this, "名称不能为空！");
                return;
            }
            SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
            sdList.Add("Name", name);
            sdList.Add("Memo", memo);
            sdList.Add("AbsIndex", absIndex);
            defineDictionary.Insert(tableName, sdList);
            BindData(tableName, "Y");

        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            string name = txtName.Text.Trim();
            string memo = txtMemo.Text.Trim();
            string absIndex = txtAbsIndex.Text.Trim();//
            if (!Utils.RegexRule.IsInt(absIndex))
            {
                JSUtility.Alert(this, "索引一定要填写数字！");
                return;
            }
            string id = hidID.Value;
            if (string.IsNullOrWhiteSpace(id) || name == "")
            {
                //弹出提示窗口
                JSUtility.Alert(this, "ID和名称不能为空！");
                return;
            }
            SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
            sdList.Add("ID", id);
            sdList.Add("Name", name);

            sdList.Add("AbsIndex", absIndex);
            sdList.Add("Memo", memo);

            if (defineDictionary.Update(tableName, sdList))
                BindData(tableName, "Y");
            else
                JSUtility.Alert(this, "更新失败");

        }


        protected void btnClose_Click(object sender, EventArgs e)
        {
            for (int i = 0; i <= gvList.Rows.Count - 1; i++)
            {
                CheckBox cbox = (CheckBox)gvList.Rows[i].FindControl("CheckBox1");
                if (cbox.Checked == true)
                {
                    //
                    SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
                    sdList.Add("ID", gvList.DataKeys[i].Value.ToString());
                    sdList.Add("Statu", "N");
                    defineDictionary.Update(tableName, sdList);


                }
            }
            BindData(tableName, "N");

        }

        protected void btnOpen_Click(object sender, EventArgs e)
        {

            for (int i = 0; i <= gvList.Rows.Count - 1; i++)
            {
                CheckBox cbox = (CheckBox)gvList.Rows[i].FindControl("CheckBox1");
                if (cbox.Checked == true)
                {
                    //
                    SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
                    sdList.Add("ID", gvList.DataKeys[i].Value.ToString());
                    sdList.Add("Statu", "Y");
                    defineDictionary.Update(tableName, sdList);


                }
            }
            BindData(tableName, "Y");
        }

        protected void btnDelete_Click(object sender, EventArgs e)
        {
            for (int i = 0; i <= gvList.Rows.Count - 1; i++)
            {
                CheckBox cbox = (CheckBox)gvList.Rows[i].FindControl("CheckBox1");
                if (cbox.Checked == true)
                {
                    //
                    defineDictionary.Delete(tableName, new string[] { "ID", gvList.DataKeys[i].Value.ToString(), "N" });
                }
            }
            BindData(tableName, "Y");
        }

        protected void btnShowOpen_Click(object sender, EventArgs e)
        {
            BindData(tableName, "Y");
        }

        protected void btnShowClose_Click(object sender, EventArgs e)
        {
            BindData(tableName, "N");
        }
    }
}
