﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Windows.Forms;
namespace Utils
{
   public class CodeConvert
    {
        /// <summary>
        /// 转半角的函数(DBC case)
        /// </summary>
        /// <param name="input">任意字符串</param>
        /// <returns>半角字符串</returns>
        ///<remarks>
        ///全角空格为12288，半角空格为32
        ///其他字符半角(33-126)与全角(65281-65374)的对应关系是：均相差65248
        ///</remarks>
        public static string ToDBC(string input)
        {
            char[] c = input.ToCharArray();
            for (int i = 0; i < c.Length; i++)
            {
                if (c[i] == 12290)
                {
                    c[i] = (char)46;
                    continue;
                }
                if (c[i] == 12288)
                {
                    c[i] = (char)32;
                    continue;
                }
                if (c[i] > 65280 && c[i] < 65375)
                    c[i] = (char)(c[i] - 65248);
            }
            return new string(c);
        }
        /// <summary>
        /// 转全角的函数(SBC case)
        /// </summary>
        /// <param name="input">任意字符串</param>
        /// <returns>全角字符串</returns>
        ///<remarks>
        ///全角空格为12288，半角空格为32
        ///其他字符半角(33-126)与全角(65281-65374)的对应关系是：均相差65248
        ///</remarks>        
        public static string ToSBC(string input)
        {
            //半角转全角：
            char[] c = input.ToCharArray();
            for (int i = 0; i < c.Length; i++)
            {
                if (c[i] == 46)
                {
                    c[i] = (char)12290;
                    continue;
                }
                if (c[i] == 32)
                {
                    c[i] = (char)12288;
                    continue;
                }
                if (c[i] < 127)
                    c[i] = (char)(c[i] + 65248);
            }
            return new string(c);
        }

        /// <summary>
        /// 只能输入数字和点号，用在价格和数量上
        /// </summary>
        /// <param name="e"></param>
        public static void SetDigit(KeyPressEventArgs e)
        {
            if (char.IsDigit(e.KeyChar) || e.KeyChar == '\b' || e.KeyChar == '.' || e.KeyChar == '。') e.Handled = false;
            else
                e.Handled = true;
        }
        /// <summary>
        /// 只能输入大小写字符、数字和-，用在　编号　上
        /// </summary>
        /// <param name="e"></param>
        public static void SetChar(KeyPressEventArgs e)
        {
            if ((e.KeyChar >= '0' && e.KeyChar <= '9') || (e.KeyChar >= 'A' && e.KeyChar <= 'Z') || (e.KeyChar >= 'a' && e.KeyChar <= 'z') || (e.KeyChar == '-') || e.KeyChar == '\b')
                e.Handled = false;
            else
                e.Handled = true;
        }
        /// <summary>
        /// 内容全角转半角
        /// </summary>
        /// <param name="textBox"></param>
        public static void CharToDBC(TextBox textBox)
        {
            string str = ToDBC(textBox.Text);
            textBox.Text = str;
            textBox.SelectionStart = str.Length + 10;
            textBox.SelectionLength = 0;//
        }
        public static string GetFlowCode(string strProvince,string Mid,string Las)
        {
            return GetCode(strProvince) + "-" + Mid + "-" + Las;
        }
        public static string GetCode(string strProvince)
        {
            //动态合成将来实现
            string strFir = "";
            switch (strProvince)
            {
                case "上海市":
                    strFir = "SH";
                    break;
                case "北京市":
                    strFir = "BJ";
                    break;
                case "香港":
                    strFir = "HK";
                    break;
                case "台湾":
                    strFir = "TW";
                    break;
                case "新疆":
                    strFir = "XJ";
                    break;
                case "澳门":
                    strFir = "AM";
                    break;
                case "宁夏":
                    strFir = "NX";
                    break;
                case "西藏":
                    strFir = "XZ";
                    break;
                case "广西":
                    strFir = "GX";
                    break;
                case "甘肃省":
                    strFir = "GS";
                    break;
                case "青海省":
                    strFir = "QH";
                    break;
                case "内蒙古":
                    strFir = "NMG";
                    break;
                case "云南省":
                    strFir = "YN";
                    break;
                case "贵州省":
                    strFir = "GZ";
                    break;
                case "四川省":
                    strFir = "SC";
                    break;
                case "海南省":
                    strFir = "HND";
                    break;
                case "山东省":
                    strFir = "SD";
                    break;
                case "江西省":
                    strFir = "JX";
                    break;
                case "福建省":
                    strFir = "FJ";
                    break;
                case "安徽省":
                    strFir = "AH";
                    break;
                case "浙江省":
                    strFir = "ZJ";
                    break;
                case "江苏省":
                    strFir = "JS";
                    break;
                case "黑龙江":
                    strFir = "HLJ";
                    break;
                case "吉林省":
                    strFir = "JL";
                    break;
                case "辽宁省":
                    strFir = "LN";
                    break;
                case "陕西省":
                    strFir = "SX";
                    break;
                case "山西省":
                    strFir = "SXG";
                    break;
                case "河北省":
                    strFir = "HB";
                    break;
                case "河南省":
                    strFir = "HNY";
                    break;
                case "湖北省":
                    strFir = "HBE";
                    break;
                case "湖南省":
                    strFir = "HN";
                    break;
                case "广东省":
                    strFir = "GD";
                    break;
                case "重庆市":
                    strFir = "CQ";
                    break;
                case "天津市":
                    strFir = "TJ";
                    break;
                default:
                    strFir = "NO";
                    break;
            }
            return strFir;
        }
    }
}
