﻿using System.Data;
using System.Text;
using System.IO;
using System.Web.UI.WebControls;
using iTextSharp.text;
using iTextSharp.text.pdf;
namespace Utils
{
  public   class PrintUtility
    {

        /// <summary>
        /// 拼出要打印的表
        /// </summary>
        /// <param name="ds">DATASET</param>
        /// <param name="dg">DATAGRID</param>
        /// <returns></returns>
      public string DTPrint(DataTable myDataTable)
        {
            //*************************************************************//
          

            int myRow = myDataTable.Rows.Count;
            int myCol = myDataTable.Columns.Count;

            StringBuilder sb = new StringBuilder();

            string colHeaders = "<html><body>" +
                "<object ID='WebBrowser' WIDTH=0 HEIGHT=0 CLASSID='CLSID:8856F961-340A-11D0-A96B-00C04FD705A2'VIEWASTEXT></object>"
                + "<table><tr>";

            for (int i = 0; i < myCol; i++)
            {
                colHeaders += "<td>" + myDataTable.Columns[i].ColumnName.ToString() + "</td>";
            }
            colHeaders += "</tr>";
            sb.Append(colHeaders);

            for (int i = 0; i < myRow; i++)
            {
                sb.Append("<tr>");
                for (int j = 0; j < myCol; j++)
                {
                    sb.Append("<td>");
                    sb.Append(myDataTable.Rows[i][j].ToString().Trim());
                    sb.Append("</td>");
                }
                sb.Append("</tr>");
            }

            sb.Append("</table></body></html>");
            colHeaders = sb.ToString();
            colHeaders += "<script languge='javascript'>WebBrowser.ExecWB(6,1); window.opener=null;window.close();</script>";
            return (colHeaders);
            //*************************************************************//

        }

        /// <summary>
        ///  拼出要打印的表
        /// </summary>
        /// <param name="gv">GridView</param>
        /// <returns></returns>
        public string GVPrint(GridView gv)
        {
            int myRow = gv.Rows.Count;
            int myCol = gv.Columns.Count;
            StringBuilder sb = new StringBuilder();

            string colHeaders = "<html><body>" +
                "<object ID='WebBrowser' WIDTH=0 HEIGHT=0 CLASSID='CLSID:8856F961-340A-11D0-A96B-00C04FD705A2'VIEWASTEXT></object>"
                + "<table><tr>";

            for (int i = 0; i < myCol; i++)
            {
                colHeaders += "<td>" + gv.Columns[i].HeaderText.ToString() + "</td>";
            }
            colHeaders += "</tr>";
            sb.Append(colHeaders);

            for (int i = 0; i < myRow; i++)
            {
                sb.Append("<tr>");
                for (int j = 0; j < myCol; j++)
                {
                    sb.Append("<td>");
                    sb.Append(gv.Rows[i].Cells[j].Text.Trim());
                    sb.Append("</td>");
                }
                sb.Append("</tr>");
            }
            sb.Append("</table></body></html>");
            colHeaders = sb.ToString();
            colHeaders += "<script languge='javascript'>WebBrowser.ExecWB(7,1); window.opener=null;window.close();</script>";
            return (colHeaders);
        }
        #region 打印
        public static void CrearePdfDoc(DataSet ds, string headerText, string footerText)
        {
            try
            {
                Document document = new Document();
                PdfWriter writer = PdfWriter.GetInstance(document, new FileStream(System.Web.HttpContext.Current.Server.MapPath("~/log/Chap0101.pdf"), FileMode.Create));
                document.Open();

                BaseFont bfChinese = BaseFont.CreateFont("C:\\WINDOWS\\Fonts\\simsun.ttc,1", BaseFont.IDENTITY_H, BaseFont.NOT_EMBEDDED);
                Font fontChinese = new Font(bfChinese, 12, Font.NORMAL, new BaseColor(0, 0, 0));

                //document.Add(new Paragraph(this.TextBox1.Text.ToString(), fontChinese));
                //  iTextSharp.text.Image jpeg = iTextSharp.text.Image.GetInstance(Server.MapPath("pic015.jpg"));
                //   document.Add(jpeg);
                DataTable datatable = ds.Tables[0];
                PdfPTable table = new PdfPTable(datatable.Columns.Count);
                for (int i = 0; i < datatable.Rows.Count; i++)
                {
                    for (int j = 0; j < datatable.Columns.Count; j++)
                    {
                        table.AddCell(new Phrase(datatable.Rows[i][j].ToString(), fontChinese));
                    }
                }
                document.Add(table);
                document.Close();
                writer.Close();
            }
            catch (DocumentException ee)
            {
                LogHelper.WriteLog("从配置文件获取要显示的字段出错。", ee);
            }
        }

        /// <summary>
        /// 打印gridview
        /// 使用方式：方法调用
        /// </summary>
        /// <param name="strTitle">标题</param>
        /// <param name="gvID">GridView的ID</param>
        public static void Printer(string strTitle, GridView gvID)
        {
            GoldPrinter.MisGoldPrinter webmis = new GoldPrinter.MisGoldPrinter();
            webmis.Title = strTitle;  //标题，还可设置子标题
            //(webmis.Title as GoldPrinter.Title).Font = new System.Drawing.Font("宋体", 12, System.Drawing.FontStyle.Bold);
            (webmis.Body as GoldPrinter.Body).DataSource = ToStringArray(gvID, true);

            //为人特性化，自定义表体，可以设置字体、列宽、列对齐方式
            // GoldPrinter.Body gridBody = new GoldPrinter.Body();
            //任意二维的数据通通打印，或者是设置GridText属性
            // gridBody.DataSource = ToStringArray(gvID, true);          
            // webmis.Body = gridBody;


            webmis.Preview();
            webmis.Dispose();
        }
        /// <summary>
        /// 将GridView控件的数据导出到二维数组。
        /// </summary>
        /// <param name="dataGridView">VS.Net 2005 DataGridView控件。</param>
        /// <param name="includeColumnText">是否要把列标题文本也导到数组中。</param>
        /// <returns>二维数组。</returns>
        /// </summary>
        protected static string[,] ToStringArray(GridView dataGridView, bool includeColumnText)
        {
            string[,] arrReturn = null;
            int rowsCount = dataGridView.Rows.Count;
            int colsCount = dataGridView.Columns.Count;
            int i = 0;

            //包括列标题
            if (includeColumnText)
            {
                rowsCount++;
                arrReturn = new string[rowsCount, colsCount];
                for (i = 0; i < colsCount; i++)
                {
                    arrReturn[0, i] = dataGridView.Columns[i].HeaderText;
                }
                i = 1;
            }
            else
            {
                arrReturn = new string[rowsCount, colsCount];
            }

            //读取单元格数据
            int rowIndex = 0;
            for (; i < rowsCount; i++, rowIndex++)
            {
                for (int j = 0; j < colsCount; j++)
                {
                    arrReturn[i, j] = dataGridView.Rows[rowIndex].Cells[j].Text.Trim();
                }
            }

            return arrReturn;
        }

        #endregion
    }
}
