﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

namespace Utils
{
    public class RegexRule
    {
        //检测是否登陆
        public static void CheckLoginUser()
        {

            if (System.Web.HttpContext.Current.Session["user"] == null)
            {
                System.Web.HttpContext.Current.Response.Redirect("~/Default.aspx");
                System.Web.HttpContext.Current.Response.End();
            }

        }
        #region  验证输入字符串为数字
        /// <summary>是否数字</summary>
        /// <param name="strInput">输入字符串</param>
        /// <returns>true/false</returns>
        public static bool IsNumeric(string strInput)
        {
            if (string.IsNullOrEmpty(strInput))
                return false;
            var reg = new Regex(@"^[-]?\d+[.]?\d*$");
            return reg.IsMatch(strInput);
        }

        /// <summary>
        /// 带小数位的小数
        /// </summary>
        /// <param name="strNumber"></param>
        /// <returns></returns>
        public static bool IsDotNumber(String strNumber)
        {
            Regex objNotNumberPattern = new Regex("[^0-9.-]");
            Regex objTwoDotPattern = new Regex("[0-9]*[.][0-9]*[.][0-9]*");
            Regex objTwoMinusPattern = new Regex("[0-9]*[-][0-9]*[-][0-9]*");
            String strValidRealPattern = "^([-]|[.]|[-.]|[0-9])[0-9]*[.]*[0-9]+$";
            String strValidIntegerPattern = "^([-]|[0-9])[0-9]*$";
            Regex objNumberPattern = new Regex("(" + strValidRealPattern + ")|(" + strValidIntegerPattern + ")");

            return !objNotNumberPattern.IsMatch(strNumber) &&
            !objTwoDotPattern.IsMatch(strNumber) &&
            !objTwoMinusPattern.IsMatch(strNumber) &&
            objNumberPattern.IsMatch(strNumber);
        }
        
     
        /// <summary>
        /// 验证输入字符串为整数
        /// </summary>
        /// <param name="P_str_num">输入字符</param>
        /// <returns>返回一个bool类型的值</returns>
        public static bool IsInt(string P_str_num)
        {

            return Regex.IsMatch(P_str_num, "^-?\\d+$");
        }

        public static bool IsDecimal(string P_str_num)
        {         
            Regex reg = new Regex("^(-?\\d+)(\\.\\d+)?$");
            return reg.IsMatch(P_str_num);          
        }


        #endregion

        public static bool IsDate(string vDateStr)
        {
            bool r = true;
            try
            {
                DateTime mDt = DateTime.Parse(vDateStr);
            }
            catch (FormatException)
            {
                r = false;
            }
            return r;
        }

        /// <summary>
        /// 是不是时间类型数据
        /// </summary>
        /// <param name="strDate"></param>
        /// <returns></returns>
        //public static bool IsDate(string strDate)
        //{
        //    var reg =
        //        new Regex(@"(((^((1[8-9]\d{2})|([2-9]\d{3}))([-\/\._])(10|12|0?[13578])([-\/\._])(3[01]|[12][0-9]|0?[1-9]))|(^((1[8-9]\d{2})|([2-9]\d{3}))([-\/\._])(11|0?[469])([-\/\._])(30|[12][0-9]|0?[1-9]))|(^((1[8-9]\d{2})|([2-9]\d{3}))([-\/\._])(0?2)([-\/\._])(2[0-8]|1[0-9]|0?[1-9]))|(^([2468][048]00)([-\/\._])(0?2)([-\/\._])(29))|(^([3579][26]00)([-\/\._])(0?2)([-\/\._])(29))|(^([1][89][0][48])([-\/\._])(0?2)([-\/\._])(29))|(^([2-9][0-9][0][48])([-\/\._])(0?2)([-\/\._])(29))|(^([1][89][2468][048])([-\/\._])(0?2)([-\/\._])(29))|(^([2-9][0-9][2468][048])([-\/\._])(0?2)([-\/\._])(29))|(^([1][89][13579][26])([-\/\._])(0?2)([-\/\._])(29))|(^([2-9][0-9][13579][26])([-\/\._])(0?2)([-\/\._])(29)))((\s+(0?[1-9]|1[012])(:[0-5]\d){0,2}(\s[AP]M))?$|(\s+([01]\d|2[0-3])(:[0-5]\d){0,2})?$))");
        //    return reg.IsMatch(strDate);
        //}

        #region  验证输入字符串为URL地址
        /// <summary>
        /// 验证输入字符串为网络地址
        /// </summary>
        /// <param name="P_str_naddress">输入字符串</param>
        /// <returns>返回一个bool类型的值</returns>
        public static bool IsURL(string P_str_naddress)
        {
            return Regex.IsMatch(P_str_naddress, @"http(s)?://([\w-]+\.)+[\w-]+(/[\w- ./?%&=]*)?");
        }
        #endregion


        #region  验证输入字符串为E-mail地址
        /// <summary>
        /// 验证输入字符串为E-mail地址
        /// </summary>
        /// <param name="P_str_email">输入字符串</param>
        /// <returns>返回一个bool类型的值</returns>
        public static bool IsEmail(string P_str_email)
        {
            return Regex.IsMatch(P_str_email, @"\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*");
        }
        #endregion

        #region  验证输入字符串为邮政编码
        /// <summary>
        /// 验证输入字符串为邮政编码
        /// </summary>
        /// <param name="P_str_postcode">输入字符串</param>
        /// <returns>返回一个bool类型的值</returns>
        public static bool IsPostCode(string P_str_postcode)
        {
            return Regex.IsMatch(P_str_postcode, @"\d{6}");
        }
        #endregion

        //实现换行  用在gridview里面
        public String HtmlReturn(string TString)
        {
            if (TString != null)
            {
                TString = TString.Replace("\r", "<br>");
                TString = TString.Replace(" ", " ");
                return TString;
            }
            else
            {
                return TString = "无内容";
            }
        } 
        /// 处理网页中的HTML代码，并消除危险字符
        public static string HTMLEncode(string str)
        {
            //替换尖括号
            string strContent = "";
            if (str != string.Empty)
            {
                str = str.Replace("&", "&amp;");
                str = str.Replace("'", "''");
                str = str.Replace("\"", "&quot;");
                str = str.Replace(" ", "&nbsp;");
                str = str.Replace("<", "&lt;");
                str = str.Replace(">", "&gt;");
                str = str.Replace("\n", "<br>");
                str = str.Replace(((char)13).ToString(), "<br />");
                //str = str.Replace(((char)10).ToString(), "<br />");
                str = str.Replace(((char)10).ToString(), " ");
                strContent = str;
            }
            return strContent;
        }
     
    }
}
