﻿using System;
using System.Data;
using System.IO;
using System.Text;
using System.Security.Cryptography;
using System.Web.UI.WebControls;
using iTextSharp.text;
using iTextSharp.text.pdf;
using System.Management;

namespace Utils
{
   public class ToolUtility
   {

       /// <summary>
       /// 全部填充为空白行
       /// </summary>
       /// <param name="rowNum"></param>
       ///// <returns></returns>
       //public static DataTable FillBlankRows(int rowNum)
       //{
       //    DataTable dt = new DataTable();

       //    for (int i = 0; i < rowNum; i++)
       //            {
       //                DataRow dr = dt.NewRow();
       //                dt.Rows.Add(dr);
       //            }
       //    return dt;

       //}
     
       #region 页脚统计
       /// <summary>
       /// ReturnTotal 统计gridview列
       /// </summary>
       /// <param name="gvList"></param>
       /// <param name="col"></param>
       /// <returns></returns>
       /*使用方法 
         if (e.Row.RowType == DataControlRowType.Footer)
            {

                int cols = gvList.HeaderRow.Cells.Count-1;
                 for (int i = 5; i <= cols; i++)
                 {
                     e.Row.Cells[0].Text = "合计";
                     e.Row.Cells[2].Text =gvList.Rows.Count+ "人";
                     e.Row.Cells[i].Text =Utils.ToolUtility.ReturnTotal(gvList,i).ToString();
                 }                
            }
        * */
           public static decimal ReturnTotal(GridView gvList, int col)
       {
           decimal char_total = 0;
           foreach (GridViewRow gvr in gvList.Rows)
           {
               if (gvr.RowType == DataControlRowType.DataRow)
               // if (null != gvr.Cells[col].Text)
               {
                   string str = gvr.Cells[col].Text.Trim();
                   if (!string.IsNullOrWhiteSpace(str) && str != "&nbsp;")
                   {
                       char_total += Convert.ToDecimal(str);
                   }
               }
           }
           return char_total;
       }
       #endregion
           /// <summary>
       /// 文本框设置为只读
       /// </summary>
       /// <param name="tb">文本框</param>
       /// <param name="flag">true：只读</param>
       public static void TextBoxReadOnly(TextBox tb, bool flag)
       {
           if (flag)
           {
               tb.ReadOnly = true;
               tb.BackColor =  System.Drawing.Color.Gray;
           }
           else
           {
               tb.ReadOnly = false;
               tb.BackColor = System.Drawing.Color.White;
           }
       }

       

       
        
  


       #region 获取硬件信息
        public static string GetIPAddress()
        {
            string ipAddress = string.Empty;
            System.Net.IPHostEntry ipHostEntrys = System.Net.Dns.GetHostEntry(System.Net.Dns.GetHostName());
            foreach (System.Net.IPAddress ip in ipHostEntrys.AddressList)
            {
                ipAddress = ip.ToString();
            }
            return ipAddress;
        }

        public static string GetCPUSerialNo()
        {
            string cpuSerialNo = string.Empty;
            ManagementClass managementClass = new ManagementClass("Win32_Processor");
            ManagementObjectCollection managementObjectCollection = managementClass.GetInstances();
            foreach (ManagementObject managementObject in managementObjectCollection)
            {
                // 可能是有多个
                cpuSerialNo = managementObject.Properties["ProcessorId"].Value.ToString();
                break;
            }
            return cpuSerialNo;
        }

        public static string GetHardDiskInfo()
        {
            string hardDisk = string.Empty;
            ManagementClass managementClass = new ManagementClass("Win32_DiskDrive");
            ManagementObjectCollection managementObjectCollection = managementClass.GetInstances();
            foreach (ManagementObject managementObject in managementObjectCollection)
            {
                // 可能是有多个
                hardDisk = (string)managementObject.Properties["Model"].Value;
                break;
            }
            return hardDisk;
        }

        public static string GetMacAddress()
        {
            string macAddress = string.Empty;
            ManagementClass managementClass = new ManagementClass("Win32_NetworkAdapterConfiguration");
            ManagementObjectCollection managementObjectCollection = managementClass.GetInstances();
            foreach (ManagementObject managementObject in managementObjectCollection)
            {
                // 可能是有多个
                if ((bool)managementObject["IPEnabled"] == true)
                {
                    macAddress = managementObject["MacAddress"].ToString();
                    break;
                }
            }
            return macAddress;
        }

       #endregion

   }
}
