﻿var $ = function (id) {
	return "string" == typeof id ? document.getElementById(id) : id;
};

var Class = {
  create: function() {
	return function() {
	  this.initialize.apply(this, arguments);
	}
  }
}

Object.extend = function(destination, source) {
	for (var property in source) {
		destination[property] = source[property];
	}
	return destination;
}

var TransformView = Class.create();
TransformView.prototype = {
  //容器对象,滑动对象,切换参数,切换数量
  initialize: function(phototop, slider, parameter, count, options) {
	if(parameter <= 0 || count <= 0) return;
	var oPhototop = $(phototop), oSlider = $(slider), oThis = this;

	this.Index = 0;//当前索引
	
	this._timer = null;//定时器
	this._slider = oSlider;//滑动对象
	this._parameter = parameter;//切换参数
	this._count = count || 0;//切换数量
	this._target = 0;//目标参数
	
	this.SetOptions(options);
	
	this.Up = !!this.options.Up;
	this.Step = Math.abs(this.options.Step);
	this.Time = Math.abs(this.options.Time);
	this.Auto = !!this.options.Auto;
	this.Pause = Math.abs(this.options.Pause);
	this.onStart = this.options.onStart;
	this.onFinish = this.options.onFinish;
	
	oPhototop.style.overflow = "hidden";
	oPhototop.style.position = "relative";
	
	oSlider.style.position = "absolute";
	oSlider.style.top = oSlider.style.left = 0;
  },
  //设置默认属性
  SetOptions: function(options) {
	this.options = {//默认值
		Up:			true,//是否向上(否则向左)
		Step:		5,//滑动变化率
		Time:		10,//滑动延时
		Auto:		true,//是否自动转换
		Pause:		10000,//停顿时间(Auto为true时有效)
		onStart:	function(){},//开始转换时执行
		onFinish:	function(){}//完成转换时执行
	};
	Object.extend(this.options, options || {});
  },
  //开始切换设置
  Start: function() {
	if(this.Index < 0){
		this.Index = this._count - 1;
	} else if (this.Index >= this._count){ this.Index = 0; }
	
	this._target = -1 * this._parameter * this.Index;
	this.onStart();
	this.Move();
  },
  //移动
  Move: function() {
	clearTimeout(this._timer);
	var oThis = this, style = this.Up ? "top" : "left", iNow = parseInt(this._slider.style[style]) || 0, iStep = this.GetStep(this._target, iNow);
	
	if (iStep != 0) {
		this._slider.style[style] = (iNow + iStep) + "px";
		this._timer = setTimeout(function(){ oThis.Move(); }, this.Time);
	} else {
		this._slider.style[style] = this._target + "px";
		this.onFinish();
		if (this.Auto) { this._timer = setTimeout(function(){ oThis.Index++; oThis.Start(); }, this.Pause); }
	}
  },
  //获取步长
  GetStep: function(iTarget, iNow) {
	var iStep = (iTarget - iNow) / this.Step;
	if (iStep == 0) return 0;
	if (Math.abs(iStep) < 1) return (iStep > 0 ? 1 : -1);
	return iStep;
  },
  //停止
  Stop: function(iTarget, iNow) {
	clearTimeout(this._timer);
	this._slider.style[this.Up ? "top" : "left"] = this._target + "px";
  }
};

function playphototop(){
	function Each(list, fun){
		for (var i = 0, len = list.length; i < len; i++) { fun(list[i], i); }
	};
	
	var objs = $("idNum").getElementsByTagName("li");
	
	var tv = new TransformView("idTransformView", "idSlider", 248, objs.length, {
		onStart : function(){ Each(objs, function(o, i){ o.className = tv.Index == i ? "on" : ""; }) }//按钮样式
	});
	
	tv.Start();
	
	Each(objs, function(o, i){
		o.onmouseover = function(){
			o.className = "on";
			tv.Auto = false;
			tv.Index = i;
			tv.Start();
		}
		o.onmouseout = function(){
			o.className = "";
			tv.Auto = true;
			tv.Start();
		}
	})
}
playphototop();



 //PNG  correctly handle PNG transparency in Win IE 5.5 & 6. 
function correctPNG() 

{ 

    var arVersion = navigator.appVersion.split("MSIE") 

    var version = parseFloat(arVersion[1]) 

    if ((version >= 5.5) && (document.body.filters)) 

    { 

       for(var j=0; j<document.images.length; j++) 

       { 

          var img = document.images[j] 

          var imgName = img.src.toUpperCase() 

          if (imgName.substring(imgName.length-3, imgName.length) == "PNG") 

          { 

             var imgID = (img.id) ? "id='" + img.id + "' " : "" 

             var imgClass = (img.className) ? "class='" + img.className + "' " : "" 

             var imgTitle = (img.title) ? "title='" + img.title + "' " : "title='" + img.alt + "' " 

             var imgStyle = "display:inline-block;" + img.style.cssText 

             if (img.align == "left") imgStyle = "float:left;" + imgStyle 

             if (img.align == "right") imgStyle = "float:right;" + imgStyle 

             if (img.parentElement.href) imgStyle = "cursor:hand;" + imgStyle 

             var strNewHTML = "<span " + imgID + imgClass + imgTitle 

             + " style=\"" + "width:" + img.width + "px; height:" + img.height + "px;" + imgStyle + ";" 

             + "filter:progid:DXImageTransform.Microsoft.AlphaImageLoader" 

             + "(src=\'" + img.src + "\', sizingMethod='scale');\"></span>" 

             img.outerHTML = strNewHTML 

             j = j-1 

          } 

       } 

    }     

} 

window.attachEvent("onload", correctPNG); 