﻿(function($)
{
	$.fn.loadpic = function (opt, callback)
	{
		var _this		= $(this);
		var defa		= {
			src		: '',
			wrapObj	: null
		}
		var opts		= $.fn.extend(defa, opt);
		var hasCallBack	= arguments[1] ? true : false;

		_this.hide();

		var _img = new Image();
		$(_img).load(function(){
			img		= {};
			img.w	= _img.width;
			img.h	= _img.height;

			var imgNew	= $.resizePic({
				'w' : $(opts.wrapObj).width(),
				'h' : $(opts.wrapObj).height()
			}, img);
			var imgMarg = $.centerPic({
				'w' : $(opts.wrapObj).width(),
				'h' : $(opts.wrapObj).height()
			}, img);
			_this.css({
				width		: img.w,
				height		: img.h,
				marginLeft	: imgMarg.left,
				marginTop	: imgMarg.top
			});

			_this.attr('src', opts.src).fadeIn('slow');
			if (hasCallBack) callback(imgNew, imgMarg);  //返回当前图片的宽高和上左margin
		}).attr('src', opts.src);
		return _this;
	}
})(jQuery);

jQuery.resizePic = function (maxWrap, img)
{
	if (img.w > 0 && img.h > 0)
	{
		var percent = 0;
		if ( img.w > img.h ) {
			percent = maxWrap.w / img.w;
		}
		else {
			percent = maxWrap.h / img.h;
		}
		//var percent = (maxWrap.w / img.w > maxWrap.h / img.h) ? maxWrap.w / img.w : maxWrap.h / img.h;
		if (percent <= 1)
		{
			img.w = img.w * percent;
			img.h = img.h * percent;
		}
	}
	return img;
}

jQuery.centerPic = function (maxWrap, img)
{
	return {
		'top'	: ((maxWrap.h - img.h) / 2) <= 0 ? 0 : (maxWrap.h - img.h) / 2,
		'left'	: (maxWrap.w - img.w) / 2
	};
}