<%@ Control Language="C#" EnableViewState="false" AutoEventWireup="false" Inherits="FredCK.FCKeditorV2.FileBrowser.Config" %>

<script runat="server">

    /**
	 * This function must check the user session to be sure that he/she is
	 * authorized to upload and access files in the File Browser.
	 */
    private bool CheckAuthentication()
    {
        // WARNING : DO NOT simply return "true". By doing so, you are allowing
        // "anyone" to upload and list the files in your server. You must implement
        // some kind of session validation here. Even something very simple as...
        //
        //		return ( Session[ "IsAuthorized" ] != null && (bool)Session[ "IsAuthorized" ] == true );
        //
        // ... where Session[ "IsAuthorized" ] is set to "true" as soon as the
        // user logs in your system.

        return true;
    }

    public override void SetConfig()
    {
        // SECURITY: You must explicitly enable this "connector". (Set it to "true").
        Enabled = CheckAuthentication();

        // URL path to user files.
        string dir = "~/App_Data/p/guest/" + DateTime.Now.ToString("yyyyMMdd") + "/";        
        if (ZK.ifLogin) dir = "~/p/m/" + ZK.uid + "/";
        if (HttpContext.Current.User.Identity.IsAuthenticated) dir = "~/p/a/" + DateTime.Now.ToString("yyyyMMdd") + "/";
        UserFilesPath = dir;

        // The connector tries to resolve the above UserFilesPath automatically.
        // Use the following setting it you prefer to explicitely specify the
        // absolute path. Examples: 'C:\\MySite\\userfiles\\' or '/root/mysite/userfiles/'.
        // Attention: The above 'UserFilesPath' URL must point to the same directory.
        UserFilesAbsolutePath = "";

        // Due to security issues with Apache modules, it is recommended to leave the
        // following setting enabled.
        ForceSingleExtension = true;

        // Allowed Resource Types
        AllowedTypes = new string[] { "File", "Image", "Flash", "Media" };

        // For security, HTML is allowed in the first Kb of data for files having the
        // following extensions only.
        HtmlExtensions = new string[] { "html", "htm", "shtml", "shtm", "xml", "xsd", "txt", "js", "css" };


        if (HttpContext.Current.User.Identity.IsAuthenticated)
        {
            TypeConfig["File"].AllowedExtensions = new string[] { "7z", "aiff", "asf", "avi", "bmp", "csv", "doc", "docx", "wps", "fla", "flv", "gif", "gz", "gzip", "jpeg", "jpg", "mid", "mov", "mp3", "mp4", "mpc", "mpeg", "mpg", "ods", "odt", "pdf", "png", "ppt", "pptx", "dps", "pxd", "qt", "ram", "rar", "rm", "rmi", "rmvb", "rtf", "sdc", "sitd", "swf", "sxc", "sxw", "tar", "tgz", "tif", "tiff", "txt", "vsd", "wav", "wma", "wmv", "xls", "xlsx", "et", "xml", "zip", "iso", "cab", "psd", "ico", "exe", "eps", "css", "js", "cdr" };
        }
        else
        {
            TypeConfig["File"].AllowedExtensions = new string[] { "7z", "rar", "zip", "iso", "cab", "doc", "docx", "wps", "xls", "xlsx", "et", "ppt", "pptx", "dps", "pdf" };
        }
        TypeConfig["File"].DeniedExtensions = new string[] { };
        TypeConfig["File"].FilesPath = "%UserFilesPath%"; //"%UserFilesPath%file/";
        TypeConfig["File"].FilesAbsolutePath = (UserFilesAbsolutePath == "" ? "" : "%UserFilesAbsolutePath%file/");
        TypeConfig["File"].QuickUploadPath = "%UserFilesPath%";
        TypeConfig["File"].QuickUploadAbsolutePath = (UserFilesAbsolutePath == "" ? "" : "%UserFilesAbsolutePath%");

        TypeConfig["Image"].AllowedExtensions = new string[] { "bmp", "gif", "jpeg", "jpg", "png" };
        TypeConfig["Image"].DeniedExtensions = new string[] { };
        TypeConfig["Image"].FilesPath = "%UserFilesPath%";// "%UserFilesPath%image/";
        TypeConfig["Image"].FilesAbsolutePath = (UserFilesAbsolutePath == "" ? "" : "%UserFilesAbsolutePath%image/");
        TypeConfig["Image"].QuickUploadPath = "%UserFilesPath%";
        TypeConfig["Image"].QuickUploadAbsolutePath = (UserFilesAbsolutePath == "" ? "" : "%UserFilesAbsolutePath%");

        TypeConfig["Flash"].AllowedExtensions = new string[] { "swf", "flv", "fla", "mpg", "asf", "wma", "wmv", "avi", "mov", "mp3", "rmvb", "mid" };
        TypeConfig["Flash"].DeniedExtensions = new string[] { };
        TypeConfig["Flash"].FilesPath = "%UserFilesPath%";// "%UserFilesPath%flash/";
        TypeConfig["Flash"].FilesAbsolutePath = (UserFilesAbsolutePath == "" ? "" : "%UserFilesAbsolutePath%flash/");
        TypeConfig["Flash"].QuickUploadPath = "%UserFilesPath%";
        TypeConfig["Flash"].QuickUploadAbsolutePath = (UserFilesAbsolutePath == "" ? "" : "%UserFilesAbsolutePath%");

        TypeConfig["Media"].AllowedExtensions = new string[] { "aiff", "asf", "avi", "bmp", "fla", "flv", "gif", "jpeg", "jpg", "mid", "mov", "mp3", "mp4", "mpc", "mpeg", "mpg", "png", "qt", "ram", "rm", "rmi", "rmvb", "swf", "tif", "tiff", "wav", "wma", "wmv" };
        TypeConfig["Media"].DeniedExtensions = new string[] { };
        TypeConfig["Media"].FilesPath = "%UserFilesPath%"; //"%UserFilesPath%media/";
        TypeConfig["Media"].FilesAbsolutePath = (UserFilesAbsolutePath == "" ? "" : "%UserFilesAbsolutePath%media/");
        TypeConfig["Media"].QuickUploadPath = "%UserFilesPath%";
        TypeConfig["Media"].QuickUploadAbsolutePath = (UserFilesAbsolutePath == "" ? "" : "%UserFilesAbsolutePath%");
    }

</script>

