<%@ Page Language="C#" ContentType="text/html" Inherits="Ycbw.Data.OleDbClient" %>

<%@ Register TagPrefix="Rajah" TagName="Head" src="../ctrls/head.ascx" %>
<%@ Register TagPrefix="Rajah" TagName="Foot" src="../ctrls/foot.ascx" %>

<script language="c#" runat="server">

private void Page_Load(object sender,EventArgs e)
{
	if( !Page.IsPostBack )
	{
		this.Initialize();
	}
}

private void Initialize()
{
	string sql = "Select *, (select count(id) from [b_article_categories] where lft < c.lft and depth = c.depth and parent = c.parent) as front, (select count(id) from [b_article_categories] where rgt > c.rgt and depth = c.depth and parent = c.parent) as back from [b_article_categories] c";
	
	if( Request.QueryString["id"] != null )
	{
		Ycbw.Categories c = new Ycbw.Categories(this,Convert.ToInt32(Request.QueryString["id"]),"b_article_categories");
		
		sql += " where lft between "+ c.Lft +" and "+ c.Rgt;
		
		this.panel_addroot.Visible = false;
	}
	
	this.BindGrid( sql + " order by lft", "categories", data_categories );

	for(int i=0;i<data_categories.Items.Count;i++)   
	{   
		data_categories.Items[i].Attributes.Add("onMouseOver","this.style.backgroundColor='#EAF3FF'");   
		data_categories.Items[i].Attributes.Add("onMouseOut","this.style.backgroundColor='#ffffff'");   
	}  
}

private void button_addroot_click(object sender, EventArgs e)
{
	this.Fill("select top 1 * from [b_article_categories] where depth = 0 order by rgt desc", "rgt");
	
	int rgt = 0;
	
	if( Tables["rgt"].Rows.Count > 0 )
		rgt = Convert.ToInt32(Tables["rgt"].Rows[0]["rgt"]);
	
	//
	this.Execute("update [b_article_categories] set lft = lft + 2 where lft > "+ rgt);
	this.Execute("update [b_article_categories] set rgt = rgt + 2 where rgt > "+ rgt);
	
	//
	this.Execute("insert into [b_article_categories] (name, depth, lft, rgt, folder, file) values ('"+ name_root.Text +"',0 ,"+ (rgt + 1) +", "+ (rgt + 2) +", 'list', 'article')" );

	string id = this.GetIdentity();
	
	this.Execute("Update [b_article_categories] set root = "+ id +" where id = "+ id);
	
	this.Initialize();
	
	this.name_root.Text = "";
}

private void button_child_add_click(object sender, EventArgs e)
{
	string parent = this.id.Text;
	
	this.Fill("Select * from [b_article_categories] where id = "+ parent, "parent" );
	
	System.Data.DataRow dr = this.Data.Tables["parent"].Rows[0];

	int lft = Convert.ToInt32(dr["lft"]);
	int rgt = Convert.ToInt32(dr["rgt"]);
	
	//
	//this.Execute("update [b_article_categories] set lft = lft + 2 where lft > "+ lft);
	//this.Execute("update [b_article_categories] set rgt = rgt + 2 where rgt > "+ lft);
	//this.Execute("insert into [b_article_categories] (name, root, depth, parent, lft, rgt) values ('"+ this.name.Text +"','"+ dr["root"] +"','"+ (Convert.ToInt32(dr["depth"]) + 1) +"',"+ parent +","+ (lft + 1) +", "+ (lft + 1) +")");

	//׷
	this.Execute("update [b_article_categories] set lft = lft + 2 where lft > "+ rgt);
	this.Execute("update [b_article_categories] set rgt = rgt + 2 where rgt >= "+ rgt);
	
	this.Execute("insert into [b_article_categories] (name, root, depth, parent, lft, rgt, folder, file) values ('"+ this.name.Text +"','"+ dr["root"] +"','"+ (Convert.ToInt32(dr["depth"]) + 1) +"',"+ parent +","+ rgt +", "+ (rgt + 1) +", '"+ dr["folder"] +"', '"+ dr["file"] +"')");
	
	this.Initialize();
}

private void data_delete_click(object sender, DataGridCommandEventArgs e)
{
	string id = ((Label)e.Item.FindControl("id")).Text;
	
	this.Fill("Select * from [b_article_categories] where id = "+ id, "category" );
	
	System.Data.DataRow dr = this.Data.Tables["category"].Rows[0];
	
	int rgt = Convert.ToInt32(dr["rgt"]);
	int width = Convert.ToInt32(dr["rgt"]) - Convert.ToInt32(dr["lft"]) + 1;
	
	//
	this.Execute("delete from [b_article_categories] where lft between "+ dr["lft"] +" and "+ dr["rgt"]);
	
	this.Execute("update [b_article_categories] set lft = lft - "+ width +" where lft > "+ rgt);
	this.Execute("update [b_article_categories] set rgt = rgt - "+ width +" where rgt > "+ rgt);
	
	this.Initialize();
}

private void data_update_click(object sender, DataGridCommandEventArgs e)
{
	string id 		= ((Label)e.Item.FindControl("id")).Text;
	string name 	= ((TextBox)e.Item.FindControl("name")).Text;
	string link    	= ((TextBox)e.Item.FindControl("link")).Text;
	string folder 	= ((TextBox)e.Item.FindControl("folder")).Text;
	string file 	= ((TextBox)e.Item.FindControl("file")).Text;
	string view 	= ((DropDownList)e.Item.FindControl("view")).Text;
	int hidden     	= Convert.ToInt32(((CheckBox)e.Item.FindControl("hidden")).Checked);

	this.Execute( "Update [b_article_categories] set name = '"+ name +"',[link] = '"+ link +"', folder = '"+ folder +"', [view] = '"+ view +"', file = '"+ file +"', hidden = "+ hidden +" where id = "+ id );

	this.Initialize();
}


private void button_submit_click(object sender, EventArgs e)
{
	for(int i=0;i<data_categories.Items.Count;i++)   
	{   
		string id 		= ((Label)data_categories.Items[i].FindControl("id")).Text;
		string name 	= ((TextBox)data_categories.Items[i].FindControl("name")).Text;
		string link    	= ((TextBox)data_categories.Items[i].FindControl("link")).Text;
		string folder 	= ((TextBox)data_categories.Items[i].FindControl("folder")).Text;
		string file 	= ((TextBox)data_categories.Items[i].FindControl("file")).Text;
		string view 	= ((DropDownList)data_categories.Items[i].FindControl("view")).Text;
		int hidden     	= Convert.ToInt32(((CheckBox)data_categories.Items[i].FindControl("hidden")).Checked);
		
		this.Execute( "Update [b_article_categories] set name = '"+ name +"',[link] = '"+ link +"', folder = '"+ folder +"', [view] = '"+ view +"', file = '"+ file +"', hidden = "+ hidden +" where id = "+ id );
	}
	
	this.Initialize();
}

private void data_item_click(object sender, DataGridCommandEventArgs e)
{
	string id = ((Label)e.Item.FindControl("id")).Text;

	//origin
	this.Fill("Select * from [b_article_categories] c where id = "+ id, "origin" );

	System.Data.DataRow dr = this.Data.Tables["origin"].Rows[0];
	
	int o_lft = Convert.ToInt32(dr["lft"]);
	int o_rgt = Convert.ToInt32(dr["rgt"]);
	int o_width = o_rgt - o_lft + 1;
	string o_family = GetFamily(o_lft, o_rgt);
	
	System.Data.DataRow dr_t;
	int t_lft, t_rgt, t_width;
	string t_family;
	
	switch(e.CommandName)
	{
		case "up":
			this.Fill("select * from [b_article_categories] c where rgt = "+ (o_lft - 1), "target");
			
			dr_t = Tables["target"].Rows[0];
			
			t_lft = Convert.ToInt32(dr_t["lft"]);
			t_rgt = Convert.ToInt32(dr_t["rgt"]);
			t_width = t_rgt - t_lft + 1;
			t_family = GetFamily(t_lft, t_rgt);
			
			this.Execute("update [b_article_categories] set lft = lft - "+ t_width +", rgt = rgt - "+ t_width +" where id in ("+ o_family +")");
			this.Execute("update [b_article_categories] set lft = lft + "+ o_width +", rgt = rgt + "+ o_width +" where id in ("+ t_family +")");
			
			break;
			
		case "down":
			this.Fill("select * from [b_article_categories] c where lft = "+ (o_rgt + 1), "target");

			dr_t = Tables["target"].Rows[0];
			
			t_lft = Convert.ToInt32(dr_t["lft"]);
			t_rgt = Convert.ToInt32(dr_t["rgt"]);
			t_width = t_rgt - t_lft + 1;
			t_family = GetFamily(t_lft, t_rgt);
			
			this.Execute("update [b_article_categories] set lft = lft + "+ t_width +", rgt = rgt + "+ t_width +" where id in ("+ o_family +")");
			this.Execute("update [b_article_categories] set lft = lft - "+ o_width +", rgt = rgt - "+ o_width +" where id in ("+ t_family +")");

			break;
	}

	this.Initialize();
}

private string GetFamily(int lft, int rgt)
{
	string family = "";
	
	this.Fill("select id from [b_article_categories] where lft between "+ lft +" and "+ rgt, "family");
	
	foreach(System.Data.DataRow dr in Tables["family"].Rows)
	{
		family += dr["id"].ToString() + ",";
	}
	
	return family.TrimEnd(',');
}

private bool GetEnabledByCount(object count)
{
	if( Convert.ToInt32(count) == 0 )
		return false;
	else
		return true;
}
</script>
<Rajah:Head ID="Head" Runat="Server" />
<form runat="server">
<table width="100%" align="center" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td class="title3"><div style="float:left"></div>
      <div style="float:right"></div></td>
  </tr>
</table>

<table width="100%" border="0" align="center" cellpadding="0" cellspacing="8">
  <tr>
	<td>
	<table width="100%" border="0" cellspacing="0" cellpadding="0" class="table3">
	  <tr>
		<td>&nbsp;</td>
		<td align="right">&nbsp;</td>
	  </tr>
	</table>
	<asp:DataGrid ID="data_categories" Width="100%" BorderWidth="0" CellPadding="0" CellSpacing="0" AutoGenerateColumns="false" runat="server" 
	CssClass="autotext" HeaderStyle-CssClass="header1" ItemStyle-CssClass="item1"
	OnDeleteCommand="data_delete_click" OnUpdateCommand="data_update_click" OnItemCommand="data_item_click">
	  <columns>
		
        <asp:TemplateColumn HeaderStyle-Width="40">
		  <headertemplate></headertemplate>
          <itemtemplate>
            <asp:Label ID="id" Text='<%# DataBinder.Eval(Container.DataItem, "id") %>' runat="server" />
          </itemtemplate>
        </asp:TemplateColumn>
			
        <asp:TemplateColumn HeaderStyle-Width="200">
		  <headertemplate></headertemplate>
          <itemtemplate> <%# ConvertDepth( DataBinder.Eval(Container.DataItem, "depth") ) %>
            <asp:TextBox ID="name" Text='<%# DataBinder.Eval(Container.DataItem, "name") %>' CssClass="text1" Width="120" runat="server" />
          </itemtemplate>
        </asp:TemplateColumn>

		<asp:TemplateColumn HeaderStyle-Width="40">
		  <headertemplate></headertemplate>
		  <itemtemplate>
			<asp:CheckBox ID="hidden" Checked='<%# Convert.ToBoolean(Eval("hidden")) %>' runat="server" />
		  </itemtemplate>
		</asp:TemplateColumn>
		
		<asp:TemplateColumn HeaderStyle-Width="100%">
		  <headertemplate>ⲿ</headertemplate>
			<itemtemplate>
			  <asp:TextBox ID="link" Text='<%# DataBinder.Eval(Container.DataItem, "link") %>' CssClass="text1" Width="95%" runat="server" />
			</itemtemplate>
		</asp:TemplateColumn>

		<asp:TemplateColumn HeaderStyle-Width="80">
		  <headertemplate>αַ̬</headertemplate>
		  <itemtemplate>
			<asp:TextBox CssClass="text1" Width="90%" ID="folder" Text='<%# Eval("folder") %>' runat="server" />
		  </itemtemplate>
		</asp:TemplateColumn>

		<asp:TemplateColumn HeaderStyle-Width="80">
		  <headertemplate>ʽ</headertemplate>
		  <itemtemplate>
			<asp:DropDownList ID="view" text='<%# Eval( "view" ) %>' Width="70" runat="server">
				<asp:ListItem Value="" Text="" style="color:#CCCCCC" />
				<asp:ListItem Value="list" Text="б" />
				<asp:ListItem Value="detail" Text="ϸ" />
				<asp:ListItem Value="small" Text="Сͼ" />
				<asp:ListItem Value="large" Text="ͼ" />
			</asp:DropDownList>
		  </itemtemplate>
		</asp:TemplateColumn>

		<asp:TemplateColumn HeaderStyle-Width="80">
		  <headertemplate>ļ</headertemplate>
		  <itemtemplate>
			<asp:TextBox CssClass="text1" Width="90%" ID="file" Text='<%# Eval("file") %>' runat="server" />
		  </itemtemplate>
		</asp:TemplateColumn>

        <asp:TemplateColumn HeaderStyle-Width="80">
		  <headertemplate></headertemplate>
          <itemtemplate>
            <asp:LinkButton CommandName="up" CommandArgument='<%# Eval("lft") %>' Enabled='<%# GetEnabledByCount(Eval("front")) %>' Text="" runat="server" />
            <asp:LinkButton CommandName="down" CommandArgument='<%# Eval("rgt") %>' Enabled='<%# GetEnabledByCount(Eval("back")) %>' Text="" runat="server" />
          </itemtemplate>
        </asp:TemplateColumn>

		<asp:TemplateColumn HeaderStyle-Width="230">
		  <headertemplate></headertemplate>
		  <itemtemplate>
			<a href="#" onclick="button_show_click('<%# DataBinder.Eval(Container.DataItem, "id") %>','<%# DataBinder.Eval(Container.DataItem, "name") %>')">[С]</a>&nbsp;<asp:LinkButton Text="[]" CommandName="update" runat="server" />&nbsp;<span onclick="return confirm('棡÷µСҲͬʱᱻɾȷҪɾ?')"><asp:LinkButton Text="[ɾ]" CommandName="delete" runat="server" /></span>&nbsp;<a href="categories.aspx?id=<%# DataBinder.Eval(Container.DataItem, "id") %>">[С]</a>
		  </itemtemplate>
		</asp:TemplateColumn>
	  </columns>
	</asp:DataGrid>
	<asp:Panel ID="panel_addroot" Visible="true" runat="server">
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
	  <tr>
		<td width="53" height="24">&nbsp;</td>
		<td><asp:TextBox ID="name_root" CssClass="text1" Width="120" runat="server" /></td>
		<td width="50">&nbsp;</td>
		<td width="230"><asp:LinkButton Text="[Ӵ]" OnClick="button_addroot_click" runat="server" /></td>
	  </tr>
	</table>
	</asp:Panel>
	</td>
  </tr>
  <tr>
    <td>
	<table width="100%" border="0" cellspacing="0" cellpadding="0" class="table3">
	  <tr>
		<td><asp:Button Text=" ȫ " OnClick="button_submit_click" runat="server" /></td>
		<td align="right">&nbsp;</td>
	  </tr>
	</table>
	</td>
  </tr>
</table>

<div id="add" style="position:absolute; left:100px; top:100px; display:none">
<table border="0" cellspacing="1" cellpadding="0" class="form1">
  <tr>
	<td class="title4">С</td>
  </tr>
  <tr bgcolor="#ffffff">
	<td>
	<asp:TextBox ID="id" runat="server" style="display:none" />
	<table border="0" align="center" cellpadding="5" cellspacing="0">
	  <tr>
		<td width="64" align="right" height="24"></td>
		<td width="200"><span id="parent"></span></td>
	  </tr>
	  <tr>
		<td align="right" height="24">С</td>
		<td><asp:TextBox ID="name" CssClass="text1" Width="100%" runat="server" /></td>
	  </tr>
	  <tr>
		<td colspan="2" class="table4"><span onclick="return checkAdd()"><asp:Button Text="  " OnClick="button_child_add_click" runat="server" /></span><input type="button" value=" ȡ " onclick="hideAdd()"></td>
	  </tr>
	</table>
	</td>
  </tr>
</table>
</div>

<script language="javascript">
function button_show_click(id, name)
{
	document.getElementById("id").value = id;
	document.getElementById("parent").innerHTML = name;
	
	var add = document.getElementById("add");

	add.style.display = '';
	//add.style.posLeft = ( document.body.offsetWidth - add.offsetWidth ) / 2 - 9;
}

function checkAdd()
{
	return true;
}

function hideAdd()
{
	document.getElementById("add").style.display = 'none';
}
</script>
</form>
<Rajah:Foot ID="Foot" Runat="Server" />
