﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Drawing;

public partial class vcode : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CreateCheckCodeImage(GenerateCheckCode());
    }

    private string[] GenerateCheckCode()
    {
        int num1, num2;
        string code;
        string[] checkCode = new string[3];
        System.Random rad1 = new Random();
        System.Random rad2 = new Random();
        System.Random rad3 = new Random();

        string [] ch=new string[]{"+","-"};

        code = ch[rad3.Next(0, 2)].ToString();

        num1 = rad1.Next(10);
        num2 = rad2.Next(20);

        if (num1 < num2)
        {
            int i = 0;
            i = num1;
            num1 = num2;
            num2 = i;
        }

        checkCode[0] = num1.ToString();
        checkCode[1] = code.ToString();
        checkCode[2] = num2.ToString();
        return checkCode;
    }

    private void CreateCheckCodeImage(string[] code)
    {
        string checkCode = code[0] +" "+ code[1]+" " + code[2];
       
        if (checkCode == null || checkCode.Trim() == String.Empty)
            return;
        System.Drawing.Bitmap image = new System.Drawing.Bitmap((int)Math.Ceiling((checkCode.Length * 10.3)), 22);
        Graphics g = Graphics.FromImage(image);
        try
        {
            //生成随机生成器
            Random random = new Random();
            //清空图片背景色
            g.Clear(Color.White);
            //画图片的背景噪音线
            for (int i = 0; i < 2; i++)
            {
                int x1 = random.Next(image.Width);
                int x2 = random.Next(image.Width);
                int y1 = random.Next(image.Height);
                int y2 = random.Next(image.Height);
                g.DrawLine(new Pen(Color.Black), x1, y1, x2, y2);
            }
            Font font = new System.Drawing.Font("宋体", 12, (System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Italic));
            System.Drawing.Drawing2D.LinearGradientBrush brush = new System.Drawing.Drawing2D.LinearGradientBrush(new Rectangle(0, 0, image.Width, image.Height), Color.Blue, Color.DarkRed, 1.2f, true);
            g.DrawString(checkCode, font, brush, 2, 2);
            //画图片的前景噪音点
			/*
            for (int i = 0; i < 200; i++)
            {
                int x = random.Next(image.Width);
                int y = random.Next(image.Height);
                image.SetPixel(x, y, Color.FromArgb(random.Next()));
            }
			*/
            //画图片的边框线
            g.DrawRectangle(new Pen(Color.Silver), 0, 0, image.Width - 1, image.Height - 1);
            System.IO.MemoryStream ms = new System.IO.MemoryStream();
            image.Save(ms, System.Drawing.Imaging.ImageFormat.Gif);
            Response.ClearContent();
            Response.ContentType = "image/Gif";
            Response.BinaryWrite(ms.ToArray());
        }
        finally
        {
			int i =0;
			
			if(code[1] == "+")
				i = int.Parse(code[0])+int.Parse(code[2]);
			else
				i = int.Parse(code[0])-int.Parse(code[2]);

            Session["vcode"] = i;
            g.Dispose();
            image.Dispose();
        }
    }
}
