﻿/*
 * 软件名称：化工产业数据库
 * 
 * 软件作者：随风缘(QQ：4259024,MAIL：jumbot114@126.com)
 * 
 */


using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.SessionState;
using System.Timers;

namespace JumboTCMS.Server
{
    public class Global : System.Web.HttpApplication
    {
        private static HttpContext myContext = HttpContext.Current;
        private string AutoTaskSiteUrl = "";
        private bool AutoCollectNews = false;
        private int RunningTask = 0;
        protected void Application_Start(object sender, EventArgs e)
        {
            AutoTaskSiteUrl = System.Configuration.ConfigurationManager.AppSettings["AutoTask:SiteUrl"];
            AutoCollectNews = System.Configuration.ConfigurationManager.AppSettings["AutoCollectNews"] == "1";
            System.Timers.Timer aTimer = new System.Timers.Timer();
            aTimer.Elapsed += new ElapsedEventHandler(TimeEvent);
            aTimer.Interval = 1000;// 设置引发时间的时间间隔　此处设置为１秒
            aTimer.Enabled = true;
        }
        private void TimeEvent(object source, ElapsedEventArgs e)
        {
            // 得到 hour minute second　如果等于某个值就开始执行某个程序。
            int intHour = e.SignalTime.Hour;
            int intMinute = e.SignalTime.Minute;
            int intSecond = e.SignalTime.Second;
            #region 每天的0:01:00开始删除2周前的采集日志
            if ((intHour == 0 && intMinute == 1 && intSecond == 0))
            {
                string _url = ServerUrl() + "/plus/autotask.aspx?oper=DeleteCollectLogs&password=" + System.Configuration.ConfigurationManager.AppSettings["AutoTask:Password"];
                System.IO.StreamWriter sw = new System.IO.StreamWriter(myContext.Request.PhysicalApplicationPath + "\\_data\\log\\autotask_" + DateTime.Now.ToString("yyyyMMdd") + ".txt", true, System.Text.Encoding.UTF8);
                sw.WriteLine(e.SignalTime.ToString());
                sw.WriteLine(GetHttpPage(_url));
                sw.Close();
                sw.Dispose();
            }
            #endregion
            #region 每天的0:11:00开始删除7天内未审核过的新闻
            if ((intHour == 0 && intMinute == 11 && intSecond == 0))
            {
                string _url = ServerUrl() + "/plus/autotask.aspx?oper=DeleteUncheckArticle&password=" + System.Configuration.ConfigurationManager.AppSettings["AutoTask:Password"];
                System.IO.StreamWriter sw = new System.IO.StreamWriter(myContext.Request.PhysicalApplicationPath + "\\_data\\log\\autotask_" + DateTime.Now.ToString("yyyyMMdd") + ".txt", true, System.Text.Encoding.UTF8);
                sw.WriteLine(e.SignalTime.ToString());
                sw.WriteLine(GetHttpPage(_url));
                sw.Close();
                sw.Dispose();
            }
            #endregion
            #region 每天的0:21:00开始删除阅读时间超过7天的通知
            if ((intHour == 0 && intMinute == 21 && intSecond == 0))
            {
                string _url = ServerUrl() + "/plus/autotask.aspx?oper=DeleteNotice&password=" + System.Configuration.ConfigurationManager.AppSettings["AutoTask:Password"];
                System.IO.StreamWriter sw = new System.IO.StreamWriter(myContext.Request.PhysicalApplicationPath + "\\_data\\log\\autotask_" + DateTime.Now.ToString("yyyyMMdd") + ".txt", true, System.Text.Encoding.UTF8);
                sw.WriteLine(e.SignalTime.ToString());
                sw.WriteLine(GetHttpPage(_url));
                sw.Close();
                sw.Dispose();
            }
            #endregion
            #region 每天的0:31:00开始删除3天内未激活的会员
            if ((intHour == 0 && intMinute == 31 && intSecond == 0))
            {
                string _url = ServerUrl() + "/plus/autotask.aspx?oper=DeleteUnactivedUser&password=" + System.Configuration.ConfigurationManager.AppSettings["AutoTask:Password"];
                System.IO.StreamWriter sw = new System.IO.StreamWriter(myContext.Request.PhysicalApplicationPath + "\\_data\\log\\autotask_" + DateTime.Now.ToString("yyyyMMdd") + ".txt", true, System.Text.Encoding.UTF8);
                sw.WriteLine(e.SignalTime.ToString());
                sw.WriteLine(GetHttpPage(_url));
                sw.Close();
                sw.Dispose();
            }
            #endregion

            #region 开始自动采集新闻
            if (AutoCollectNews)
            {
                if (((intMinute + 60 * intSecond) % 19 == 1) && (RunningTask < 8))
                {
                    RunningTask++;
                    string _init = "0";
                    if (myContext.Application["AutoCollectNews"] == null)
                    {
                        _init = "1";
                        myContext.Application.Lock();
                        myContext.Application["AutoCollectNews"] = "true";
                        myContext.Application.UnLock();
                    }
                    string _url = ServerUrl() + "/plus/autotask.aspx?init=" + _init + "&oper=AutoCollectNews&password=" + System.Configuration.ConfigurationManager.AppSettings["AutoTask:Password"];
                    System.IO.StreamWriter sw = new System.IO.StreamWriter(myContext.Request.PhysicalApplicationPath + "\\_data\\log\\autotask_" + DateTime.Now.ToString("yyyyMMdd") + ".txt", true, System.Text.Encoding.UTF8);
                    sw.WriteLine(e.SignalTime.ToString() + " ～ " + System.DateTime.Now.ToString());
                    sw.WriteLine(GetHttpPage(_url));
                    sw.Close();
                    sw.Dispose();
                    RunningTask--;
                }
            }
            #endregion

        }
        private string ServerUrl()
        {
            if (AutoTaskSiteUrl != "")
                return AutoTaskSiteUrl;
            if (myContext.Request.Url.Port == 80)
                return "http://" + myContext.Request.Url.Host;
            else
                return "http://" + myContext.Request.Url.Host + ":" + myContext.Request.Url.Port;
        }
        private string AppPath()
        {
            string _ApplicationPath = myContext.Request.ApplicationPath;
            if (_ApplicationPath != "/")
                _ApplicationPath += "/";
            return _ApplicationPath;
        }
        private string GetHttpPage(string url)
        {
            string strResult = string.Empty;
            try
            {
                System.Net.WebClient MyWebClient = new System.Net.WebClient();
                MyWebClient.Credentials = System.Net.CredentialCache.DefaultCredentials;
                MyWebClient.Encoding = System.Text.Encoding.UTF8;
                strResult = MyWebClient.DownloadString(url);
            }
            catch (Exception e)
            {
                strResult = "页面" + url + "获取失败\r\n" + e.Message;
            }
            return strResult;
        }
        protected void Session_Start(object sender, EventArgs e)
        {

        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {
        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {

        }

        protected void Application_Error(object sender, EventArgs e)
        {

        }

        protected void Session_End(object sender, EventArgs e)
        {

        }

        protected void Application_End(object sender, EventArgs e)
        {

        }
    }
}