﻿/*
 * 程序名称: JumboTCMS(将博内容管理系统通用版)
 * 
 * 程序版本: 6.x
 * 
 * 程序作者: 将博开发团队 (商业合作请联系：791104444@qq.com)
 * 
 * 版权申明: http://www.jumbotcms.net/about/copyright.html
 * 
 * 技术答疑: http://forum.jumbotcms.net/
 * 
 */


using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.SessionState;
using System.Timers;

namespace JumboTCMS.WebFile
{
    public class Global : System.Web.HttpApplication
    {
        public static HttpContext myContext = HttpContext.Current;
        protected void Application_Start(object sender, EventArgs e)
        {
            System.Timers.Timer aTimer = new System.Timers.Timer();
            aTimer.Elapsed += new ElapsedEventHandler(TimeEvent);
            aTimer.Interval = 1000;// 设置引发时间的时间间隔　此处设置为１秒
            aTimer.Enabled = true;
        }
        private void TimeEvent(object source, ElapsedEventArgs e)
        {
            // 得到 hour minute second　如果等于某个值就开始执行某个程序。
            int intHour = e.SignalTime.Hour;
            int intMinute = e.SignalTime.Minute;
            int intSecond = e.SignalTime.Second;
            #region 每天的准点开始生成一次首页
            //假设web服务异常或正常的重启，则强行执行一次任务（目的是为防止遗漏）
            //if ((intMinute == 0 && intSecond == 0) || myContext.Application["AutoTask_1"] == null)
            if ((intMinute == 0 && intSecond == 0))
            {
                string _url = ServerUrl() + "/plus/autotask.aspx?oper=CreateDefaultPage&password=" + System.Configuration.ConfigurationManager.AppSettings["AutoTask:Password"];
                System.IO.StreamWriter sw = new System.IO.StreamWriter(myContext.Request.PhysicalApplicationPath + "\\_data\\log\\autotask_" + DateTime.Now.ToString("yyyyMMdd") + ".txt", true, System.Text.Encoding.UTF8);
                sw.WriteLine(e.SignalTime.ToString());
                sw.WriteLine(GetHttpPage(_url));
                sw.Close();
                sw.Dispose();
                myContext.Application.Lock();
                myContext.Application["AutoTask_1"] = "true";
                myContext.Application.UnLock();
            }
            #endregion
        }
        private string ServerUrl()
        {
            if (myContext.Request.Url.Port == 80)
                return "http://" + myContext.Request.Url.Host;
            else
                return "http://" + myContext.Request.Url.Host + ":" + myContext.Request.Url.Port;
        }
        private string AppPath()
        {
            string _ApplicationPath = myContext.Request.ApplicationPath;
            if (_ApplicationPath != "/")
                _ApplicationPath += "/";
            return _ApplicationPath;
        }
        private string GetHttpPage(string url)
        {
            string strResult = string.Empty;
            try
            {
                System.Net.WebClient MyWebClient = new System.Net.WebClient();
                MyWebClient.Credentials = System.Net.CredentialCache.DefaultCredentials;
                MyWebClient.Encoding = System.Text.Encoding.UTF8;
                strResult = MyWebClient.DownloadString(url);
            }
            catch (Exception)
            {
                strResult = "页面获取失败";
            }
            return strResult;
        }
        protected void Session_Start(object sender, EventArgs e)
        {

        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {

        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {

        }

        protected void Application_Error(object sender, EventArgs e)
        {

        }

        protected void Session_End(object sender, EventArgs e)
        {

        }

        protected void Application_End(object sender, EventArgs e)
        {

        }
    }
}