﻿/*
 * 程序名称: JumboTCMS(将博内容管理系统通用版)
 * 
 * 程序版本: 6.x
 * 
 * 程序作者: 将博开发团队 (商业合作请联系：791104444@qq.com)
 * 
 * 版权申明: http://www.jumbotcms.net/about/copyright.html
 * 
 * 技术答疑: http://forum.jumbotcms.net/
 * 
 */

using System;
using System.Collections.Specialized;
using System.Collections.Generic;
using System.Data;
using System.Web;
using JumboTCMS.Utils;
using JumboTCMS.Common;
namespace JumboTCMS.WebFile.Admin
{
    public partial class __authorize_ajax : JumboTCMS.UI.AdminCenter
    {
        private string _operType = string.Empty;
        private string _response = string.Empty;

        protected void Page_Load(object sender, EventArgs e)
        {
            Admin_Load("master", "json");
            this._operType = q("oper");
            switch (this._operType)
            {
                case "ajaxGetList":
                    ajaxGetList();
                    break;
                case "ajaxCheck":
                    ajaxCheck();
                    break;
                case "ajaxRemind":
                    ajaxRemind();
                    break;
                default:
                    DefaultResponse();
                    break;
            }
            Response.Write(this._response);
        }

        private void DefaultResponse()
        {
            this._response = JsonResult(0, "未知操作");
        }
        private void ajaxGetList()
        {
            int page = Int_ThisPage();
            int PSize = Str2Int(q("pagesize"), 20);
            string whereStr = "1=1";
            doh.Reset();
            doh.ConditionExpress = whereStr;
            string sqlStr = "";
            int _totalcount = doh.Count("jcms_official_authorization");
            NameValueCollection orders = new NameValueCollection();
            string FiledsList = "*,(select Title FROM [jcms_official_authorization_type] where id=[jcms_official_authorization].accredittype) as accredittypename";
            orders.Add("AccreditType", "asc");
            orders.Add("State", "asc");
            orders.Add("CanRemind", "desc");
            orders.Add("LastRemindTime", "asc");
            orders.Add("Id", "desc");
            sqlStr = JumboTCMS.Utils.SqlHelp.GetSql1(FiledsList,
                "jcms_official_authorization", _totalcount,PSize, page, orders, whereStr);

            doh.Reset();
            doh.SqlCmd = sqlStr;
            DataTable dt = doh.GetDataTable();
            this._response = "{\"result\" :\"1\"," +
                "\"returnval\" :\"操作成功\"," +
                "\"pagebar\" :\"" + JumboTCMS.Utils.PageBar.GetPageBar(3, "js", 2, _totalcount, PSize, page, "javascript:ajaxList(<#page#>);") + "\"," +
                JumboTCMS.Utils.dtHelp.DT2JSON(dt, (PSize * (page - 1))) +
                "}";
            dt.Clear();
            dt.Dispose();
        }
        private void ajaxCheck()
        {
            string aId = f("id");
            doh.Reset();
            doh.ConditionExpress = "id=@id";
            doh.AddConditionParameter("@id", aId);
            object[] _value = doh.GetFields("jcms_official_authorization", "WebName,DefaultPage");
            string _webname = _value[0].ToString();
            string _defaultpage = _value[1].ToString();
            //需要检测首页文件是否含Jumbotcms
            if (JumboTCMS.Utils.Validator.IsFreeSite(_defaultpage, _webname))
            {
                doh.Reset();
                doh.ConditionExpress = "id=@id";
                doh.AddConditionParameter("@id", aId);
                doh.AddFieldItem("State", 1);
                doh.Update("jcms_official_authorization");
                this._response = JsonResult(1, "检测完成");
            }
            else
            {
                doh.Reset();
                doh.ConditionExpress = "id=@id";
                doh.AddConditionParameter("@id", aId);
                doh.AddFieldItem("State", 0);
                doh.Update("jcms_official_authorization");
                this._response = JsonResult(1, "检测完成");
            }
        }
        private void ajaxRemind()
        {
            string aId = f("id");
            doh.Reset();
            doh.ConditionExpress = "id=@id";
            doh.AddConditionParameter("@id", aId);
            object[] _value = doh.GetFields("jcms_official_authorization", "WebName,Domain,LinkEmail,MobileTel");
            string _WebName = _value[0].ToString();
            string _Domain = _value[1].ToString();
            string _LinkEmail = _value[2].ToString();
            string _MobileTel = _value[3].ToString();
            string strXmlFile = HttpContext.Current.Server.MapPath("~/_data/config/_authorize_remind.config");
            JumboTCMS.DBUtility.XmlControl XmlTool = new JumboTCMS.DBUtility.XmlControl(strXmlFile);
            string _Title = XmlTool.GetText("Root/AuthorityRemind/Title", true).Replace("{$WebName}", _WebName).Replace("{$Domain}", _Domain);
            string _EmailBody = XmlTool.GetText("Root/AuthorityRemind/EmailBody", true).Replace("{$WebName}", _WebName).Replace("{$Domain}", _Domain);
            string _MobileBody = XmlTool.GetText("Root/AuthorityRemind/MobileBody", true).Replace("{$WebName}", _WebName).Replace("{$Domain}", _Domain);
            XmlTool.Dispose();
            string _result = "";
            bool _reminedOK = false;
            if (_LinkEmail != "")
            {
                if (new JumboTCMS.DAL.Normal_UserMailDAL().SendMail(_LinkEmail, _Title, _EmailBody))
                {
                    _result += "邮件发送成功";
                    _reminedOK = true;
                }
                else
                {
                    _result += "邮件发送失败";
                }
            }
            if (_MobileTel != "")
            {
                if (SendMobileMessage(_MobileTel, _MobileBody))
                {
                    _result += ",短信发送成功";
                    _reminedOK = true;
                }
                else
                {
                    _result += ",短信发送失败";
                }
            }
            if (_result != "")
            {
                if (_reminedOK)
                {
                    doh.Reset();
                    doh.ConditionExpress = "id=@id";
                    doh.AddConditionParameter("@id", aId);
                    doh.AddFieldItem("LastRemindTime", DateTime.Now.ToString());
                    doh.Update("jcms_official_authorization");
                }
                this._response = JsonResult(1, _result);
            }
            else
                this._response = JsonResult(0, "未填邮箱和手机号");
        }
    }
}