﻿<%@ page language="C#" autoeventwireup="true" inherits="NewsDetail, App_Web_flu4wwrf" enableviewstate="false" enableEventValidation="false" %>

<%@ Register src="inc/PageHead.ascx" tagname="PageHead" tagprefix="uc1" %>
<%@ Register src="inc/PageSearchBox.ascx" tagname="PageSearchBox" tagprefix="uc2" %>
<%@ Register src="inc/PageFooter.ascx" tagname="PageFooter" tagprefix="uc3" %>
<%@ Register src="inc/NewsRight.ascx" tagname="NewsRight" tagprefix="uc4" %>
<%@ Register src="inc/ParamPageNavigator.ascx" tagname="ParamPageNavigator" tagprefix="uc5" %>
<%@ Register src="inc/NewsTopAds.ascx" tagname="NewsTopAds" tagprefix="uc6" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7" />
    <meta name="description" content="<%= Utils.GetShortTextNotEx(Utils.FilterHtml(Content),200).Replace("\t","").Replace(" ","").Replace("\r","").Replace("\n","") %>" />
    <meta name="keywords" content="<%= newsDetails.keywords %>" />
    
    <title><%= page == 1 ? "" : Utils.GetShortTextNotEx(Utils.FilterHtml(Content), 25).Replace("\t", "").Replace("  ", "").Replace(" ", "").Replace("\r", "").Replace("\n", "").Trim() %><%= newsDetails.title.Trim() %>_<%= ConfigurationManager.AppSettings["site_title"]%>_<%= ConfigurationManager.AppSettings["app_domain"] %></title>
    <link href="/css/style.css" rel="stylesheet" type="text/css" />
    <link href="/css/front.css" rel="stylesheet" type="text/css" />
    <style type="text/css"></style>
    <script type="text/javascript" src="/Js/jquery.js"></script>
    <script type="text/javascript" src="/Js/utils.js"></script>
    <script type="text/javascript" src="/Js/_effect.js"></script>
    <script type="text/javascript" src="/js/ajax.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="wrapper">
            <uc1:PageHead ID="PageHead1" runat="server" />
            
            <div class="body">
                <!-- 主要内容开始 -->
                <uc2:PageSearchBox ID="PageSearchBox1" runat="server" />
                
                <uc6:NewsTopAds ID="NewsTopAds2" runat="server" />
                <div class="clear"></div>
                
                <div class="newsdetail mg_top">
                    <div class="left">
                        <div class="news_top">
                            <div class="category"><%= cate[2] %></div>
                            <div class="position">当前位置：<a href="/">首页</a> &gt; 
                            <a href="/newshome/">婚嫁资讯</a> &gt; 
                            <a href="/news/<%= cate[4] %>/"><%= cate[3] %></a></div>
                        </div>
                        <div class="news_cnt">
                            <div class="keywords"><h1><%= newsDetails.keywords %></h1></div>
                            <h1 class="title"><%= newsDetails.title %></h1>
                            <div class="descr">
                                <%= newsDetails.postdate.ToString("yyyy年MM月dd日 hh:mm") %> &nbsp;&nbsp;&nbsp; 文章来源：<%= newsDetails.newssource == "" ? ConfigurationManager.AppSettings["app_name"] : newsDetails.newssource%> 
                                &nbsp;&nbsp;&nbsp; <a href="#discus_mark">我要评论</a>(<%= newsDetails.discuscount %>) 
                            </div>
                            <div class="cnt">
                                <center style="padding:3px;">
                                
                                <!-- zanox AdServer code start-->
<script type="text/javascript" src="http://zbox.zanox.com/scripts/adbox_content.js">
</script>
<script type="text/javascript">
CallAdBoxTracking(379546, 507246441, 0, 468, 60, 'B0E0E6', 'FFFFFF', '000000', '336699', '333333', '0', '', true);
</script>
<!-- zanox AdServer code end -->

                                
                                <%= Content %>
                            </div>
                            
                            <% if (ParamPageNavigator1.PageCount > 1) {%>
                            <div class="clear"></div>                            
                            <div class="pages">
                                <div><uc5:ParamPageNavigator ID="ParamPageNavigator1" runat="server" RewriteExpression="/news/*.html" /></div>
                            </div>
                            <%} %>
                        </div>
                        
                        <div class="t_center mg_top">
                            <a href="<%= ConfigurationManager.AppSettings["url_forum"] %>"><img src="/images/bbs_ent.gif" alt="新娘论坛" /></a>
                        </div>
                        
                        <div class="about_news">
                            <div class="cnt newstit">
                                <ul>
                                    <li>上一篇 <span><a href="<%= PrevNews.newsid > 0 ? "/news/" + PrevNews.newsid + ".html" : "#"%>" title="<%= PrevNews.title %>"><%= Utils.GetShortText(PrevNews.title,26) %></a></span></li>
                                    <li>下一篇 <span><a href="<%= NextNews.newsid > 0 ? "/news/" + NextNews.newsid + ".html" : "#"%>" title="<%= NextNews.title %>"><%= Utils.GetShortText(NextNews.title,26) %></a></span></li>
                                </ul>
                            </div>
                        </div>
                        
                        <div class="about_news">
                            <div class="tit">相关新闻</div>
                            <div class="cnt newstit">
                                <ul>
                                    <asp:Repeater ID="rptAboutNews" runat="server">
                                    <ItemTemplate>
                                        <li><span><a href="/news/<%# DataBinder.Eval(Container.DataItem, "newsid")%>.html"><%# Utils.GetShortText(DataBinder.Eval(Container.DataItem, "title") as string,28) %></a></span></li>
                                    </ItemTemplate>
                                    </asp:Repeater>
                                </ul>
                            </div>
                        </div>
                        
                        <div class="clear"></div>
                        
                        <!-- 评论 -->
                        <a id="discus_mark"></a>
                        <div class="discus">
                            <div id="discuz_panel" class="mg_top">正在加载评论...</div>
                            
                            <table  width="100%" class="mg_top">
                                <tr>
                                    <td width="270">昵称：</td><td>
                                    <div style="text-align:left;"><input id="txtNick" type="text" value="婚嫁网友" />
                                        &nbsp; 您的IP：<%= Utils.MarkIP(Request.ServerVariables["REMOTE_ADDR"]) %>
                                    </div></td>
                                </tr>
                                <tr>
                                    <td>内容：
                                    <br />
                                    <img src="/faces/1.gif" /> <br />
                                        心情 (可选)
                                    </td> <td>
                                    <textarea id="txtContent" style="width:500px;height:100px;"></textarea></td>
                                </tr>
                                <tr>
                                    <td colspan="2" align="right" class="btns">
                                        提交时，请输入验证码：<input id="txtValidateCode" type="text" style="width:60px" /> &nbsp;
                                      <span id="validateimg"><img src="/inc/aspx/ValidateCode.aspx?" style="cursor:pointer;" /></span>
                                      
                                      <input type="button" id="btnSubmit" value="提交评论" class="btn" />
                                    </td>
                                </tr>
                            </table>
                        </div>
                        
                        <div class="intro newsdetailintro"></div>
                    </div>
                    <div class="center"></div>
                    <div class="right">
                        <uc4:NewsRight ID="NewsRight1" runat="server" />
                    </div>
                </div>
                
                <!-- 主要内容结束 -->
                <uc3:PageFooter ID="PageFooter1" runat="server" />
            </div>
        </div>
    </form>
    
    <script type="text/javascript">
        $(document).ready(function() {
            GetNewsDiscus(false,<%= Request.QueryString["id"] %>,"","","",1);
            
            $("#btnSubmit").bind("click",function(){
                GetNewsDiscus(true,<%= Request.QueryString["id"] %>,$("#txtNick").attr("value"),$("#txtContent").attr("value"),$("#txtValidateCode").attr("value"),1);
            });
            
            $("#validateimg").bind("click", function() {
                $("#validateimg img").attr("src","/inc/aspx/ValidateCode.aspx?t=" + new Date().getTime());
            });
        });
    </script>
</body>
</html>
