﻿<%@ page language="C#" autoeventwireup="true" inherits="Reg, App_Web_flu4wwrf" enableEventValidation="false" %>

<%@ Register src="inc/PageHead.ascx" tagname="PageHead" tagprefix="uc1" %>
<%@ Register src="inc/PageSearchBox.ascx" tagname="PageSearchBox" tagprefix="uc2" %>
<%@ Register src="inc/PageFooter.ascx" tagname="PageFooter" tagprefix="uc3" %>
<%@ Register src="inc/NewsRight.ascx" tagname="NewsRight" tagprefix="uc4" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7" />
    
    <title>会员注册_<%= ConfigurationManager.AppSettings["app_name"] %>_<%= ConfigurationManager.AppSettings["app_domain"] %></title>
    <link href="/css/style.css" rel="stylesheet" type="text/css" />
    <link href="/css/front.css" rel="stylesheet" type="text/css" />
    <style type="text/css"></style>
    <script type="text/javascript" src="/Js/jquery.js"></script>
    <script type="text/javascript" src="/Js/utils.js"></script>
    <script type="text/javascript" src="/Js/_effect.js"></script>
    <script type="text/javascript" src="js/data.js"></script>
    <script type="text/javascript">
        $(function() {
            $("#<%= txtUname.ClientID %>").bind("blur", function() {
                if ($("#<%= txtUname.ClientID %>").val() == "") {
                    $("#uname_valid").hide();
                    return;
                }

                if ($("#<%= txtUname.ClientID %>").val().length < 5) {
                    $("#uname_valid").show();
                    $("#uname_valid").html("请正确输入用户名");
                    $("#uname_valid").attr("class", "err");
                    return;
                }

                $.ajax({
                    url: "/Service/MarryService.ashx",
                    data: { act: "validateuname", uname: $("#<%= txtUname.ClientID %>").val() },
                    cache: false,
                    success: function(html) {
                        $("#uname_valid").show();
                        if (html == "0") {
                            $("#uname_valid").html("该用户名已存在");
                            $("#uname_valid").attr("class", "err");
                        }
                        else {
                            $("#uname_valid").html("该用户名可用");
                            $("#uname_valid").attr("class", "done");
                        }
                    }
                });
            });


            $("#<%= txtemail.ClientID %>").bind("blur", function() {
                if ($("#<%= txtemail.ClientID %>").val() == "") {
                    $("#email_valid").hide();
                    return;
                }

                $.ajax({
                    url: "/Service/MarryService.ashx",
                    data: { act: "validateemail", email: $("#<%= txtemail.ClientID %>").val() },
                    cache: false,
                    success: function(html) {
                        if (html == "0") {
                            $("#email_valid").show();
                            $("#email_valid").html("该邮箱已被注册");
                            $("#email_valid").attr("class", "err");
                        }
                        else
                            $("#email_valid").hide();
                    }
                });
            });
        });
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="wrapper">
            <uc1:PageHead ID="PageHead1" runat="server" />
            
            <div class="body">
                <!-- 主要内容开始 -->
                
                <div class="reg">
                    <div class="big_tit">会员注册</div>
                    
                    <div class="big_tab">
                        <span class="tit">填写注册信息</span>
                        <span class="descr">带*项为必填</span>
                    </div>
                    
                    <div class="inputs">
                        <div class="item">
                            <span class="tit">用户名：</span>
                            <span class="cnt"><asp:TextBox ID="txtUname" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="请输入用户名" ControlToValidate="txtUname"  ForeColor="#404040" CssClass="err" Display="Dynamic"></asp:RequiredFieldValidator>
                            <asp:Label ID="lblErr" runat="server" CssClass="err" Text="该用户名已存在" Visible="false"></asp:Label><span id="uname_valid"></span>
                            </span>
                            <span class="descr">*中、英文、数字均可（注：用户名注册后不能更换）。
                             </span>
                        </div>
                        
                        <div class="item">
                            <span class="tit">登录密码：</span>
                            <span class="cnt"><asp:TextBox ID="txtPassword" runat="server" TextMode="Password"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ErrorMessage="请输入登录密码" ControlToValidate="txtPassword"  ForeColor="#404040" CssClass="err" Display="Dynamic"></asp:RequiredFieldValidator></span>
                            </span>
                            <span class="descr"> * 由6-16位字符组成，请使用英文字母、符号或数字。</span>
                        </div>
                        <div class="item">
                            <span class="tit">密码确认：</span>
                            <span class="cnt"><asp:TextBox ID="txtRepass" runat="server" TextMode="Password"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ErrorMessage="请输入密码确认" ControlToValidate="txtRepass"  ForeColor="#404040" CssClass="err" Display="Dynamic"></asp:RequiredFieldValidator>
                            <asp:CompareValidator ID="CompareValidator1" runat="server" 
                                ErrorMessage="两次输入的密码不同" ControlToValidate="txtRepass" ControlToCompare="txtPassword" ForeColor="#404040" CssClass="err" Display="Dynamic"></asp:CompareValidator>
                            </span>
                            </span>
                            <span class="descr">* 为了确保您输入的密码正确，请再次输入密码</span>
                        </div>
                        <div class="item">
                            <span class="tit">电子邮件：</span>
                            <span class="cnt"><asp:TextBox ID="txtemail" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ErrorMessage="请输入电子邮件" ControlToValidate="txtEmail"  ForeColor="#404040" CssClass="err" Display="Dynamic"></asp:RequiredFieldValidator>
                            <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" 
                                ErrorMessage="请正确输入电子邮件" 
                                ValidationExpression="\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*" ForeColor="#404040" CssClass="err" Display="Dynamic" ControlToValidate="txtemail"></asp:RegularExpressionValidator>
                            <span id="email_valid"></span>
                            </span>
                            <span class="descr">* 为了确保您输入的密码正确，请再次输入密码</span>
                        </div>
                        <div class="item">
                            <span class="tit">所在地区：</span>
                            <span class="cnt_long"><asp:HiddenField ID="hidArea" runat="server" Value="福建,福州"></asp:HiddenField> 
                                <script type="text/javascript">            new DropdownLists(arrCity, "<%= hidArea.ClientID %>",null,true);</script>
                            </span>
                        </div>
                        <div class="item">
                            <span class="tit">出生日期：</span>
                            <span class="cnt"><asp:DropDownList ID="ddlYear" runat="server"></asp:DropDownList>年
                            <asp:DropDownList ID="ddlMonth" runat="server"></asp:DropDownList>月
                            <asp:DropDownList ID="ddlDay" runat="server"></asp:DropDownList>日</span>
                            <span class="descr">* 为了确保您输入的密码正确，请再次输入密码</span>
                        </div>
                        <div class="item">
                            <span class="tit">用户类型：</span>
                            <span class="cnt2" style=" ">
                                <asp:RadioButtonList ID="rblUType" runat="server" RepeatDirection="Horizontal">
                                    <asp:ListItem Text="普通用户" Style="font-size:14px;"></asp:ListItem>
                                    <asp:ListItem Text="商家用户" Style="font-weight:bold;font-size:14px; color:Red;"></asp:ListItem>
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator5" runat="server" ErrorMessage="请选择用户类型" ControlToValidate="rblUType"  ForeColor="#404040" CssClass="err" Display="Dynamic"></asp:RequiredFieldValidator>
                            </span>
                            <span class="descr">* 如果您想在本站发布商业广告请选择商家用户</span>
                        </div>
                        <div class="chk">
                            <input id="chkAccept" type="checkbox" checked="checked" />
                            <a href="/about/default.aspx?id=600" target="_blank">我接受《<%= ConfigurationManager.AppSettings["app_name"] %>服务条款》</a>
                        </div>
                        <div class="confirm">
                            <asp:LinkButton ID="btnSubmit" runat="server" CssClass="confirmbtn" 
                                onclick="btnSubmit_Click" OnClientClick="return beforeConfirm();">提交注册信息</asp:LinkButton>
                        </div>
                    </div>
                    
                    <div class="step">
                        <img src="/images/reg_step.gif" />
                        <div class="tit">火爆论坛</div>
                        <div class="cnt">学习经验，分享幸福</div>
                        <div class="tit">个性用户中心</div>
                        <div class="cnt">个人相册、婚嫁工具等</div>
                        <div class="tit">预约优秀品牌商家</div>
                        <div class="cnt">为您的消费保驾护航</div>
                        <div class="tit">学习新婚常识</div>
                        <div class="cnt">让您婚礼更加个性</div>
                    </div>
                    <div class="clear"></div>
                </div>
                
                <!-- 主要内容结束 -->
                <uc3:PageFooter ID="PageFooter1" runat="server" />
            </div>
        </div>
    </form>
    <script type="text/javascript">
        function beforeConfirm() {
            if (!$("#chkAccept").attr("checked")) {
                alert("请接受服务条款后才能继续");
                return false;
            }
            return true;
        }
    </script>
</body>
</html>
