﻿<%@ WebHandler Language="C#" Class="BusinessGradeService" %>

using System;
using System.Web;
using System.Data;
using System.IO;
using Marry.DAL.Base;
using Marry.DAL;
using Marry.DAL.Details;
using System.Data.SqlClient;
using Newtonsoft.Json;
using System.Collections.Generic;


public class BusinessGradeService : IHttpHandler {
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/html";
        
        string itemkey = context.Request["itemkey"]; // KEY_ID
        int buid = Convert.ToInt32(context.Request.QueryString["buid"]);
        int newGrade = Convert.ToInt32(context.Request["grade"]); //1~5
        
        using (Mry_businessuser bs = new Mry_businessuser())
        {
            DataTable dt = bs.SelectTable("SELECT grade,totalgrade FROM Mry_businessuser WHERE buid = " + context.Request["buid"]);
            if (dt.Rows.Count > 0)
            {
                JsonSerializer ser = new JsonSerializer();
                List<JsonGradeItem> resultItems = null;
                using (StringReader sr = new StringReader(dt.Rows[0]["grade"].ToString()))
                {
                    resultItems =
                        ser.Deserialize(new JsonReader(new StringReader(dt.Rows[0]["grade"].ToString())),
                        typeof(List<JsonGradeItem>)) as List<JsonGradeItem>;
                }

                bool found = false;
                if (resultItems != null)
                {
                    foreach (JsonGradeItem i in resultItems)
                    {
                        if (i.Name == itemkey)
                        {
                            i.Count++; // 投票总数
                            i.Value = ((i.Value * (i.Count - 1)) + newGrade) / i.Count;
                            found = true;
                        }
                    }
                }
                else
                {
                    resultItems = new List<JsonGradeItem>();
                }
                
                if (!found)
                    resultItems.Add(new JsonGradeItem() { Name = itemkey, Value = newGrade, Count = 1 });

                float totalgrade = 0f;
                // 计算平均总分
                foreach (JsonGradeItem i in resultItems)
                    totalgrade += i.Value;
                totalgrade = totalgrade / resultItems.Count;
                
                TextWriter tw = new StringWriter();
                JsonWriter jw = new JsonWriter(tw);
                ser.Serialize(jw, resultItems);
                tw.Flush();
                tw.Close();
                jw.Close();
                string result = tw.ToString();

                bs.BuildCommand("UPDATE Mry_businessuser SET totalgrade = @totalgrade,grade = @grade,gradevotes = gradevotes + 1 WHERE buid = @buid"
                    , new SqlParameter("totalgrade", totalgrade), new SqlParameter("grade", result), new SqlParameter("buid", buid)).ExecuteNonQuery();
            }
        }
    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }
}