﻿<%@ WebHandler Language="C#" Class="PhotoSaving" %>

using System;
using System.Web;
using System.Configuration;
using Marry.DAL.Base;
using Marry.DAL;
using Marry.DAL.Details;
using System.Data.SqlClient;

public class PhotoSaving : IHttpHandler {
    
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/html";

        string[] photos = context.Request.QueryString["files"].Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
        using (DbObject db = new DbObject())
        {
            string Ids = "";
            if (context.Request.QueryString["utype"] == "p")
            {
                // 个人相册
                foreach (string photo in photos)
                {
                    Mry_personphoto p = new Mry_personphoto(db.Conn);
                    Mry_personphotoDetails pd = new Mry_personphotoDetails();
                    pd.Fill(Convert.ToInt32(context.Request["album"]), Convert.ToInt32(context.Request["uid"]),
                        photo, 0, "", 0, 0);
                    
                    Ids += p.Add(pd) + ",";
                }

                // 判断 相册是否有缩略图，若没有生成缩略图
                Mry_personalbum album = new Mry_personalbum(db.Conn);
                Mry_personalbumDetails albumDetail = album.GetDetails(Convert.ToInt32(context.Request["album"]));
                if (albumDetail != null)
                {
                    albumDetail.photocount += photos.Length;
                    if (albumDetail.picurl == "")
                        albumDetail.picurl = photos[0];

                    album.Update(albumDetail);
                }

                db.BuildCommand("UPDATE Mry_personuser SET picount = picount + @newpicount WHERE puid = @puid",
                            new SqlParameter("puid", context.Request["uid"]),
                            new SqlParameter("newpicount", photos.Length)).ExecuteNonQuery();
            }
            else 
            { 
                // 商家相册
                foreach (string photo in photos)
                {
                    Mry_businessphoto p = new Mry_businessphoto(db.Conn);
                    Mry_businessphotoDetails pd = new Mry_businessphotoDetails();
                    pd.Fill(Convert.ToInt32(context.Request["album"]), Convert.ToInt32(context.Request["uid"]), 0,
                        photo, "");

                    Ids += p.Add(pd) + ",";
                }

                // 判断 相册是否有缩略图，若没有生成缩略图
                Mry_businessalbum album = new Mry_businessalbum(db.Conn);
                Mry_businessalbumDetails albumDetail = album.GetDetails(Convert.ToInt32(context.Request["album"]));
                if (albumDetail != null)
                {
                    albumDetail.photocount += photos.Length;
                    if (albumDetail.picurl == "")
                        albumDetail.picurl = photos[0];

                    album.Update(albumDetail);
                }
            }

            if (Ids != "")
                Ids = Ids.Substring(0, Ids.Length - 1);
            context.Response.Write(Ids);
        }
    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }

}