﻿<%@ WebHandler Language="C#" Class="UploadSvr" %>

using System;
using System.Web;
using System.IO;

public class UploadSvr : IHttpHandler {
    public static Random rnd = new Random();
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/html";

        if (context.Request.Files.Count > 0)
            {
                string msg = "";
                string error = "";
                
                for (int i = 0; i < context.Request.Files.Count; i++)
                {
                    HttpPostedFile file = context.Request.Files[i];
                    if (file.ContentLength == 0)
                        error = "文件长度为0";
                    else
                    {
                        string filename = DateTime.Now.ToString("yyMMdd") + "\\" + DateTime.Now.ToString("HHmmss") + DateTime.Now.Millisecond.ToString() + rnd.Next(1000, 9999).ToString()
                             + ".jpg";

                        string allName = context.Server.MapPath("~/UploadFiles") + "\\" + filename;
                        if (!Directory.Exists(Path.GetDirectoryName(allName)))
                            Directory.CreateDirectory(Path.GetDirectoryName(allName));
                        file.SaveAs(allName);
                        
                        // 生成缩略图
                        Utils.ZoomImage(allName, allName + "_100x100" + Path.GetExtension(allName), 100, 100);
                        Utils.ZoomImage(allName, allName + "_200x200" + Path.GetExtension(allName), 200, 200);
                        Utils.ZoomImage(allName, allName + "_640x480" + Path.GetExtension(allName), 800, 800, true);

                        if (File.Exists(allName))
                            File.Delete(allName);
                        
                        msg = filename.Replace("\\", "/");
                    }
                }
                string result = "{error:'" + error + "', msg:'" + msg.Replace("\\", "\\\\") + "'}";
                context.Response.Write(result);
                context.Response.End();
            }
    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }
}