﻿<%@ Page Language="C#" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="Marry.DAL" %>
<%@ Import Namespace="Marry.DAL.Details" %>

<script runat="server">
    List<Dictionary<string, string>> ds = new List<Dictionary<string, string>>();
    string type = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            type = Request.QueryString["type"];
            if (type == null) type = "1";
            string localfilename = Server.MapPath("~/UploadFiles/personplans/" + Utils.GetLoginedUserDescr().uid + "_" + type + ".xml");

            if (!File.Exists(localfilename))
            {
                return;
            }
            else
            {
                ds = ObjectXMLSerializer<List<Dictionary<string, string>>>.Deserialize(File.ReadAllText(localfilename));
            } 
            
            if (Request.QueryString["act"] == "updatetime")
            {
                // 更新时间
                string newguid = Request.QueryString["id"];
                bool isNew = false;
                if (newguid == "")
                {
                    isNew = true;
                    newguid = System.Guid.NewGuid().ToString().Replace("-", "");
                    Response.Write(newguid);
                }

                if (isNew)
                {
                    Dictionary<string, string> item = new Dictionary<string, string>();
                    item.Add("id", newguid);
                    item.Add("status", Convert.ToBoolean(Request.QueryString["status"]).ToString());
                    item.Add("date", Request.QueryString["date"]);
                    item.Add("descr", Request.QueryString["descr"]);
                    ds.Insert(0, item);
                }
                else
                {
                    Update(newguid, "date", Request.QueryString["val"]);
                }
                
                SortDS();

                Write(localfilename);
                Response.End();
            }
            else if (Request.QueryString["act"] == "updatestatus")
            {
                string id = Request.QueryString["id"];
                Update(id, "status", Convert.ToBoolean(Request.QueryString["val"]).ToString());
                Write(localfilename);
                
                Response.Write("1");
                Response.End();
            }
            else if (Request.QueryString["act"] == "updatecnt")
            {
                string id = Request.QueryString["id"];
                Update(id, "descr", Request.QueryString["val"]);
                Write(localfilename);
                
                Response.Write("1");
                Response.End();
            }
            else if (Request.QueryString["act"] == "delete")
            {
                string id = Request.QueryString["id"];
                foreach (Dictionary<string, string> _item in ds)
                {
                    if (_item["id"] == id)
                    {
                        ds.Remove(_item);
                        break;
                    }
                }
                Write(localfilename);
                Response.Write("1");
                Response.End();
            }
        }
    }

    protected void Write(string localfilename)
    {
        if (!File.Exists(localfilename))
            File.Delete(localfilename);
        File.WriteAllText(localfilename, ObjectXMLSerializer<List<Dictionary<string, string>>>.Serialize(ds));
    }
    
    protected void SortDS()
    {
        ds.Sort(new Comparison<Dictionary<string, string>>(SortCallback));
    }

    protected int SortCallback(Dictionary<string, string> s1, Dictionary<string, string> s2)
    {
        return Convert.ToDateTime(s1["date"]).CompareTo(Convert.ToDateTime(s2["date"]));
    }

    protected void Update(string id,string key,string val)
    {
        foreach (Dictionary<string, string> _item in ds)
        {
            if (_item["id"] == id)
            {
                _item[key] = val;
            }
        }
    }
    
</script>

<%if(Request.QueryString["act"] == "get"){ %>
<table width="100%" class="table">
    <tr class="head">
        <td class="c1">已完成</td>
        <td class="c2">计划日期</td>
        <td class="c3">行程内容</td>
        <td class="c4">删除</td>
    </tr>
    <%
        DateTime userDate = DateTime.Now;
        using (Mry_personuser pu = new Mry_personuser())
        {
            Mry_personuserDetails pud = pu.GetDetails(Utils.GetLoginedUserDescr().uid);
            if (type == "1")
                userDate = pud.engagementdate; // 订婚日期
            else
                userDate = pud.marrydate; // 结婚日期
        }

        List<int> dispedSysDateIndexs = new List<int>();
        List<object[]> sysDates = new List<object[]>();
      
        // 小于天数 大于天数 文字
        //if (type == "1")
        //{
        //    sysDates.Add(new object[] { "365", "31", "2～3 个月前" });
        //    sysDates.Add(new object[] { "30", "9", "1个月前" });
        //    sysDates.Add(new object[] { "8", "2", "1个星期前" });
        //    sysDates.Add(new object[] { "1", "1", "1天前" });
        //    sysDates.Add(new object[] { "0", "0", "当天" });
        //}
        //else
        //{
        //    sysDates.Add(new object[] { "9999", "365", "1年前" });
        //    sysDates.Add(new object[] { "365", "91", "4～6 个月前" });
        //    sysDates.Add(new object[] { "90", "31", "2～3 个月前" });
        //    sysDates.Add(new object[] { "30", "16", "1个月前" });
        //    sysDates.Add(new object[] { "15", "9", "2个星期前" });
        //    sysDates.Add(new object[] { "8", "2", "1个星期前" });
        //    sysDates.Add(new object[] { "1", "1", "1天前" });
        //    sysDates.Add(new object[] { "0", "0", "当天" });
        //}
      
        sysDates = Utils.GetPersonPlanSysDates(type);
      
       %>
    <%foreach (Dictionary<string, string> item in ds)
      { %>
    <%
        int index = -1;
        foreach (object[] objs in sysDates)
        {
            index++;
            if (Convert.ToDateTime(Convert.ToDateTime(item["date"]).ToLongDateString()) >= userDate.AddDays(-Convert.ToInt32(objs[0])) &&
                Convert.ToDateTime(Convert.ToDateTime(item["date"]).ToLongDateString()) <= userDate.AddDays(-Convert.ToInt32(objs[1])))
            {
                if (!dispedSysDateIndexs.Contains(index) && (Request.QueryString["list"] == "all" || Request.QueryString["list"] == index.ToString()))
                {
                    dispedSysDateIndexs.Add(index);
                    %>
                    <tr class="fullrow" index="<%= index %>" start="<%= userDate.AddDays(-Convert.ToInt32(objs[0])).ToString("yyyy-MM-dd") %>" end="<%= userDate.AddDays(-Convert.ToInt32(objs[1])).ToString("yyyy-MM-dd") %>">
                        <td colspan="4"><%= objs[2] %></td>
                    </tr>
                    <%
                }
                break;
            }
        }

        if (Request.QueryString["list"] == "all" || Request.QueryString["list"] == index.ToString())
        {
           %>
        <tr class="irow" index="<%= index %>" id="<%= item["id"] %>">
            <td class="c1"><input type="checkbox" class="chk" <%= Convert.ToBoolean(item["status"]) ? "checked='checked'" : "" %> /></td>
            <td class="c2"><input class="txt date" type="text" value="<%= Convert.ToDateTime(item["date"]).ToString("yyyy-MM-dd") %>" /> <span><%= Utils.GetWeekText(Convert.ToDateTime(item["date"]))%></span></td>
            <td class="c3"><input class="txt desc" type="text" maxlength="50" value="<%= item["descr"] %>" /></td>
            <td class="c4"><a href="javascript:void(0);"><img src="/images/del.gif" /></a></td>
        </tr>
    <%}
      }%>
</table>
<%} %>